/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.container.service.classloader;

import com.alipay.sofa.ark.api.ArkConfigs;
import com.alipay.sofa.ark.bootstrap.UseFastConnectionExceptionsEnumeration;
import com.alipay.sofa.ark.common.log.ArkLoggerFactory;
import com.alipay.sofa.ark.common.util.StringUtils;
import com.alipay.sofa.ark.container.model.BizModel;
import com.alipay.sofa.ark.container.service.ArkServiceContainerHolder;
import com.alipay.sofa.ark.container.service.classloader.BizClassLoader;
import com.alipay.sofa.ark.container.service.classloader.CompoundEnumeration;
import com.alipay.sofa.ark.exception.ArkLoaderException;
import com.alipay.sofa.ark.loader.jar.Handler;
import com.alipay.sofa.ark.loader.jar.JarUtils;
import com.alipay.sofa.ark.spi.service.classloader.ClassLoaderService;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;

public abstract class AbstractClasspathClassLoader
extends URLClassLoader {
    protected static final String CLASS_RESOURCE_SUFFIX = ".class";
    protected ClassLoaderService classloaderService = ArkServiceContainerHolder.getContainer().getService(ClassLoaderService.class);
    protected Cache<String, LoadClassResult> classCache;
    protected Cache<String, Optional<Package>> packageCache;
    protected Cache<String, Optional<URL>> urlResourceCache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).build();
    protected boolean exploded = false;

    public AbstractClasspathClassLoader(URL[] urls) {
        super(urls, (ClassLoader)null);
        this.classCache = CacheBuilder.newBuilder().initialCapacity(ArkConfigs.getIntValue((String)"ark.classloader.cache.class.size.initial", (int)2500)).maximumSize((long)ArkConfigs.getIntValue((String)"ark.classloader.cache.class.size.max", (int)2500)).concurrencyLevel(ArkConfigs.getIntValue((String)"ark.classloader.cache.concurrencylevel", (int)16)).expireAfterWrite(30L, TimeUnit.SECONDS).recordStats().build();
        this.packageCache = CacheBuilder.newBuilder().initialCapacity(ArkConfigs.getIntValue((String)"ark.classloader.cache.class.size.initial", (int)2000)).maximumSize((long)ArkConfigs.getIntValue((String)"ark.classloader.cache.class.size.max", (int)2000)).concurrencyLevel(ArkConfigs.getIntValue((String)"ark.classloader.cache.concurrencylevel", (int)16)).expireAfterWrite(30L, TimeUnit.SECONDS).recordStats().build();
    }

    public AbstractClasspathClassLoader(URL[] urls, boolean exploded) {
        this(urls);
        this.exploded = exploded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (StringUtils.isEmpty((String)name)) {
            return null;
        }
        Handler.setUseFastConnectionExceptions((boolean)true);
        try {
            if (!this.exploded) {
                this.definePackageIfNecessary(name);
            }
            Class<?> clazz = this.loadClassWithCache(name, resolve);
            return clazz;
        }
        finally {
            Handler.setUseFastConnectionExceptions((boolean)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void definePackageIfNecessary(String className) {
        String packageName;
        Optional pkgInCache;
        int lastDot = className.lastIndexOf(46);
        if (lastDot >= 0 && (pkgInCache = (Optional)this.packageCache.getIfPresent((Object)(packageName = className.substring(0, lastDot)))) == null) {
            try {
                this.definePackage(className, packageName);
            }
            catch (IllegalArgumentException pkgAfterDefined) {
                Package pkgAfterDefined2 = super.getPackage(packageName);
                this.packageCache.put((Object)packageName, pkgAfterDefined2 == null ? Optional.empty() : Optional.of(pkgAfterDefined2));
                catch (Throwable throwable) {
                    Package pkgAfterDefined3 = super.getPackage(packageName);
                    this.packageCache.put((Object)packageName, pkgAfterDefined3 == null ? Optional.empty() : Optional.of(pkgAfterDefined3));
                    throw throwable;
                }
            }
            Package pkgAfterDefined = super.getPackage(packageName);
            this.packageCache.put((Object)packageName, pkgAfterDefined == null ? Optional.empty() : Optional.of(pkgAfterDefined));
        }
    }

    private void definePackage(final String className, final String packageName) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    StringBuilder pen = new StringBuilder(packageName.length() + 10);
                    StringBuilder cen = new StringBuilder(className.length() + 10);
                    String packageEntryName = pen.append(packageName.replace('.', '/')).append("/").toString();
                    String classEntryName = cen.append(className.replace('.', '/')).append(AbstractClasspathClassLoader.CLASS_RESOURCE_SUFFIX).toString();
                    for (URL url : AbstractClasspathClassLoader.this.getURLs()) {
                        try {
                            JarFile jarFile;
                            URLConnection connection = url.openConnection();
                            if (!(connection instanceof JarURLConnection) || (jarFile = ((JarURLConnection)connection).getJarFile()).getEntry(classEntryName) == null || jarFile.getEntry(packageEntryName) == null || jarFile.getManifest() == null) continue;
                            AbstractClasspathClassLoader.this.definePackage(packageName, jarFile.getManifest(), url);
                            return null;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return null;
                }
            }, AccessController.getContext());
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
    }

    @Override
    protected Package getPackage(String name) {
        Optional pkgInCache = (Optional)this.packageCache.getIfPresent((Object)name);
        if (pkgInCache != null && pkgInCache.isPresent()) {
            return pkgInCache.orElse(null);
        }
        Package pkg = super.getPackage(name);
        if (pkg != null) {
            this.packageCache.put((Object)name, Optional.of(pkg));
        }
        return pkg;
    }

    protected Class<?> loadClassWithCache(String name, boolean resolve) throws ArkLoaderException {
        try {
            LoadClassResult resultInCache = (LoadClassResult)this.classCache.get((Object)name, () -> {
                LoadClassResult r = new LoadClassResult();
                try {
                    r.setClazz(this.loadClassInternal(name, resolve));
                }
                catch (ArkLoaderException ex) {
                    r.setEx(ex);
                }
                return r;
            });
            if (resultInCache.getEx() != null) {
                throw resultInCache.getEx();
            }
            return resultInCache.getClazz();
        }
        catch (ExecutionException e) {
            throw new ArkLoaderException(String.format("[Ark Loader] unexpected exception when load class: %s", name), e.getCause());
        }
    }

    protected abstract Class<?> loadClassInternal(String var1, boolean var2) throws ArkLoaderException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getResource(String name) {
        Handler.setUseFastConnectionExceptions((boolean)true);
        Optional urlOptional = (Optional)this.urlResourceCache.getIfPresent((Object)name);
        try {
            if (urlOptional != null) {
                URL uRL = urlOptional.orElse(null);
                return uRL;
            }
            URL ret = this.preFindResource(name);
            if (ret != null) {
                URL uRL = ret;
                return uRL;
            }
            ret = this.getResourceInternal(name);
            URL url = ret != null ? ret : this.postFindResource(name);
            this.urlResourceCache.put((Object)name, url != null ? Optional.of(url) : Optional.empty());
            URL uRL = url;
            return uRL;
        }
        finally {
            Handler.setUseFastConnectionExceptions((boolean)false);
        }
    }

    protected URL getResourceInternal(String name) {
        URL url = this.getJdkResource(name);
        if (url == null) {
            url = this.getExportResource(name);
        }
        if (url == null) {
            url = this.getClassResource(name);
        }
        if (url == null) {
            url = this.getLocalResource(name);
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Handler.setUseFastConnectionExceptions((boolean)true);
        try {
            if (this.isDeclaredMode()) {
                ArrayList<Enumeration<URL>> enumerationList = new ArrayList<Enumeration<URL>>();
                enumerationList.add(this.preFindResources(name));
                enumerationList.add(this.getResourcesInternal(name));
                enumerationList.add(this.postFindResources(name));
                Enumeration<URL> enumeration = this.uniqueUrls(enumerationList, name);
                return enumeration;
            }
            Enumeration<URL> ret = this.preFindResources(name);
            if (ret != null && ret.hasMoreElements()) {
                CompoundEnumeration<URL> compoundEnumeration = ret;
                return compoundEnumeration;
            }
            ret = this.getResourcesInternal(name);
            if (ret != null && ret.hasMoreElements()) {
                CompoundEnumeration<URL> compoundEnumeration = ret;
                return compoundEnumeration;
            }
            ret = this.postFindResources(name);
            CompoundEnumeration<URL> compoundEnumeration = ret != null ? ret : new CompoundEnumeration<URL>(new Enumeration[0]);
            return compoundEnumeration;
        }
        finally {
            Handler.setUseFastConnectionExceptions((boolean)false);
        }
    }

    private Enumeration<URL> uniqueUrls(List<Enumeration<URL>> enumerationList, String resourceName) {
        HashSet<String> temp = new HashSet<String>();
        ArrayList<URL> uniqueUrls = new ArrayList<URL>();
        for (Enumeration<URL> e : enumerationList) {
            while (e != null && e.hasMoreElements()) {
                String artifactId;
                URL resourceUrl = e.nextElement();
                String filePath = resourceUrl.getFile().replace("file:", "");
                if (filePath.endsWith(resourceName)) {
                    filePath = filePath.substring(0, filePath.lastIndexOf(resourceName));
                }
                if ((artifactId = JarUtils.parseArtifactId((String)filePath)) == null) {
                    uniqueUrls.add(resourceUrl);
                    continue;
                }
                if (temp.contains(artifactId)) continue;
                uniqueUrls.add(resourceUrl);
                temp.add(artifactId);
            }
        }
        return Collections.enumeration(uniqueUrls);
    }

    protected Enumeration<URL> getResourcesInternal(String name) throws IOException {
        ArrayList<Enumeration<URL>> enumerationList = new ArrayList<Enumeration<URL>>();
        enumerationList.add(this.getJdkResources(name));
        enumerationList.add(this.getExportResources(name));
        enumerationList.add(this.getLocalResources(name));
        return new CompoundEnumeration<URL>(enumerationList.toArray(new Enumeration[0]));
    }

    abstract boolean shouldFindExportedClass(String var1);

    abstract boolean shouldFindExportedResource(String var1);

    private boolean isDeclaredMode() {
        return this instanceof BizClassLoader && ((BizClassLoader)this).checkDeclaredMode();
    }

    protected Class<?> resolveJDKClass(String name) {
        try {
            return this.classloaderService.getJDKClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    protected Class<?> resolveExportClass(String name) {
        if (!"override".equals(this.classloaderService.getExportMode(name))) {
            return this.doResolveExportClass(name);
        }
        ClassLoader classLoader = this.classloaderService.findExportClassLoader(name);
        URL url = classLoader.getResource(name.replace('.', '/') + CLASS_RESOURCE_SUFFIX);
        if (url != null) {
            String filePath = url.getFile().replaceFirst("file:", "");
            try {
                byte[] bytes = filePath.contains(".jar") ? this.getClassBytesFromJar(filePath, name.replace('.', '/') + CLASS_RESOURCE_SUFFIX) : FileUtils.readFileToByteArray((File)new File(filePath));
                return this.defineClass(name, bytes, 0, bytes.length);
            }
            catch (Exception e) {
                ArkLoggerFactory.getDefaultLogger().warn(String.format("can't convert class to reLoad by bizClassLoader: %s", e.getMessage()));
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private byte[] getClassBytesFromJar(String jarFilePath, String className) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Class<?> doResolveExportClass(String name) {
        block7: {
            ClassLoader importClassLoader;
            if (this.shouldFindExportedClass(name) && (importClassLoader = this.classloaderService.findExportClassLoader(name)) != null) {
                try {
                    Class<?> clazz = importClassLoader.loadClass(name);
                    if (clazz == null) {
                        return null;
                    }
                    URL url = clazz.getProtectionDomain().getCodeSource().getLocation();
                    if (this instanceof BizClassLoader && ((BizClassLoader)this).getBizModel() != null) {
                        BizModel bizModel = ((BizClassLoader)this).getBizModel();
                        if (url != null && bizModel.isDeclared(url, "")) {
                            return clazz;
                        }
                        String classResourceName = name.replace('.', '/') + CLASS_RESOURCE_SUFFIX;
                        Enumeration<URL> urls = importClassLoader.getResources(classResourceName);
                        while (urls.hasMoreElements()) {
                            URL resourceUrl = urls.nextElement();
                            if (resourceUrl == null || !bizModel.isDeclared(resourceUrl, classResourceName)) continue;
                            ArkLoggerFactory.getDefaultLogger().warn(String.format("find class %s from %s in multiple dependencies.", name, resourceUrl.getFile()));
                            return clazz;
                        }
                        break block7;
                    }
                    return clazz;
                }
                catch (IOException | ClassNotFoundException | NoClassDefFoundError e) {
                    if (!ArkLoggerFactory.getDefaultLogger().isDebugEnabled()) break block7;
                    ArkLoggerFactory.getDefaultLogger().debug("Fail to load export class " + name, e);
                }
            }
        }
        return null;
    }

    protected Class<?> resolveArkClass(String name) {
        if (this.classloaderService.isArkSpiClass(name) || this.classloaderService.isArkApiClass(name) || this.classloaderService.isArkLogClass(name) || this.classloaderService.isArkExceptionClass(name)) {
            try {
                return this.classloaderService.getArkClassLoader().loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    protected Class<?> resolveLocalClass(String name) {
        try {
            return super.loadClass(name, false);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    protected Class<?> resolveJavaAgentClass(String name) {
        try {
            this.classloaderService.getAgentClassLoader().loadClass(name);
            return this.classloaderService.getSystemClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    protected URL getExportResource(String resourceName) {
        Iterator iterator;
        List exportResourceClassLoadersInOrder;
        if (this.shouldFindExportedResource(resourceName) && (exportResourceClassLoadersInOrder = this.classloaderService.findExportResourceClassLoadersInOrder(resourceName)) != null && (iterator = exportResourceClassLoadersInOrder.iterator()).hasNext()) {
            ClassLoader exportResourceClassLoader = (ClassLoader)iterator.next();
            URL url = exportResourceClassLoader.getResource(resourceName);
            if (url != null && this instanceof BizClassLoader) {
                if (((BizClassLoader)this).getBizModel().isDeclared(url, resourceName)) {
                    return url;
                }
                return null;
            }
            return url;
        }
        return null;
    }

    protected URL getJdkResource(String resourceName) {
        return this.classloaderService.getJDKClassLoader().getResource(resourceName);
    }

    protected URL getClassResource(String resourceName) {
        if (resourceName.endsWith(CLASS_RESOURCE_SUFFIX)) {
            String className = this.transformClassName(resourceName);
            if (this.resolveArkClass(className) != null) {
                return this.classloaderService.getArkClassLoader().getResource(resourceName);
            }
            if (this.shouldFindExportedClass(className)) {
                ClassLoader classLoader = this.classloaderService.findExportClassLoader(className);
                return classLoader == null ? null : classLoader.getResource(resourceName);
            }
        }
        return null;
    }

    protected URL getLocalResource(String resourceName) {
        return super.getResource(resourceName);
    }

    private String transformClassName(String name) {
        if (name.endsWith(CLASS_RESOURCE_SUFFIX)) {
            name = name.substring(0, name.length() - CLASS_RESOURCE_SUFFIX.length());
        }
        return name.replace("/", ".");
    }

    protected Enumeration<URL> getExportResources(String resourceName) throws IOException {
        List exportResourceClassLoadersInOrder;
        if (this.shouldFindExportedResource(resourceName) && (exportResourceClassLoadersInOrder = this.classloaderService.findExportResourceClassLoadersInOrder(resourceName)) != null) {
            ArrayList<Enumeration<URL>> enumerationList = new ArrayList<Enumeration<URL>>();
            for (ClassLoader exportResourceClassLoader : exportResourceClassLoadersInOrder) {
                if (exportResourceClassLoader instanceof AbstractClasspathClassLoader) {
                    enumerationList.add(((AbstractClasspathClassLoader)exportResourceClassLoader).getLocalResources(resourceName));
                    continue;
                }
                enumerationList.add(exportResourceClassLoader.getResources(resourceName));
            }
            CompoundEnumeration<URL> urls = new CompoundEnumeration<URL>(enumerationList.toArray(new Enumeration[0]));
            if (this instanceof BizClassLoader) {
                BizModel bizModel = ((BizClassLoader)this).getBizModel();
                ArrayList<URL> matchedResourceUrls = new ArrayList<URL>();
                while (urls.hasMoreElements()) {
                    URL resourceUrl = (URL)urls.nextElement();
                    if (resourceUrl == null || !bizModel.isDeclared(resourceUrl, resourceName)) continue;
                    matchedResourceUrls.add(resourceUrl);
                }
                return Collections.enumeration(matchedResourceUrls);
            }
            return urls;
        }
        return Collections.emptyEnumeration();
    }

    protected Enumeration<URL> getLocalResources(String resourceName) throws IOException {
        return new UseFastConnectionExceptionsEnumeration(super.getResources(resourceName));
    }

    protected Enumeration<URL> getJdkResources(String resourceName) throws IOException {
        return new UseFastConnectionExceptionsEnumeration(this.classloaderService.getJDKClassLoader().getResources(resourceName));
    }

    public void clearCache() {
        this.classCache.cleanUp();
        this.packageCache.cleanUp();
        this.urlResourceCache.cleanUp();
    }

    public void invalidAllCache() {
        this.classCache.invalidateAll();
        this.packageCache.invalidateAll();
        this.urlResourceCache.invalidateAll();
    }

    protected abstract Class<?> preLoadClass(String var1) throws ArkLoaderException;

    protected abstract Class<?> postLoadClass(String var1) throws ArkLoaderException;

    protected abstract URL preFindResource(String var1);

    protected abstract URL postFindResource(String var1);

    protected abstract Enumeration<URL> preFindResources(String var1) throws IOException;

    protected abstract Enumeration<URL> postFindResources(String var1) throws IOException;

    static {
        ClassLoader.registerAsParallelCapable();
    }

    public static class LoadClassResult {
        private ArkLoaderException ex;
        private Class clazz;

        public ArkLoaderException getEx() {
            return this.ex;
        }

        public void setEx(ArkLoaderException ex) {
            this.ex = ex;
        }

        public Class getClazz() {
            return this.clazz;
        }

        public void setClazz(Class clazz) {
            this.clazz = clazz;
        }
    }
}

