/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.container.pipeline;

import com.alipay.sofa.ark.common.log.ArkLoggerFactory;
import com.alipay.sofa.ark.container.pipeline.DeployBizStage;
import com.alipay.sofa.ark.container.pipeline.DeployPluginStage;
import com.alipay.sofa.ark.container.pipeline.ExtensionLoaderStage;
import com.alipay.sofa.ark.container.pipeline.FinishStartupStage;
import com.alipay.sofa.ark.container.pipeline.HandleArchiveStage;
import com.alipay.sofa.ark.container.pipeline.RegisterServiceStage;
import com.alipay.sofa.ark.container.service.ArkServiceContainerHolder;
import com.alipay.sofa.ark.exception.ArkRuntimeException;
import com.alipay.sofa.ark.spi.pipeline.Pipeline;
import com.alipay.sofa.ark.spi.pipeline.PipelineContext;
import com.alipay.sofa.ark.spi.pipeline.PipelineStage;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;

@Singleton
public class StandardPipeline
implements Pipeline {
    private List<PipelineStage> stages = new ArrayList<PipelineStage>();

    public StandardPipeline() {
        this.initializePipeline();
    }

    private void initializePipeline() {
        this.addPipelineStage(ArkServiceContainerHolder.getContainer().getService(HandleArchiveStage.class)).addPipelineStage((PipelineStage)ArkServiceContainerHolder.getContainer().getService(RegisterServiceStage.class)).addPipelineStage((PipelineStage)ArkServiceContainerHolder.getContainer().getService(ExtensionLoaderStage.class)).addPipelineStage((PipelineStage)ArkServiceContainerHolder.getContainer().getService(DeployPluginStage.class)).addPipelineStage((PipelineStage)ArkServiceContainerHolder.getContainer().getService(DeployBizStage.class)).addPipelineStage((PipelineStage)ArkServiceContainerHolder.getContainer().getService(FinishStartupStage.class));
    }

    public Pipeline addPipelineStage(PipelineStage pipelineStage) {
        this.stages.add(pipelineStage);
        return this;
    }

    public void process(PipelineContext pipelineContext) throws ArkRuntimeException {
        for (PipelineStage pipelineStage : this.stages) {
            try {
                ArkLoggerFactory.getDefaultLogger().info(String.format("Start to process pipeline stage: %s", pipelineStage.getClass().getName()));
                pipelineStage.process(pipelineContext);
                ArkLoggerFactory.getDefaultLogger().info(String.format("Finish to process pipeline stage: %s", pipelineStage.getClass().getName()));
            }
            catch (Throwable e) {
                ArkLoggerFactory.getDefaultLogger().error(String.format("Process pipeline stage fail: %s", pipelineStage.getClass().getName()), e);
                throw new ArkRuntimeException(e);
            }
        }
    }
}

