/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.container.model;

import com.alipay.sofa.ark.api.ArkClient;
import com.alipay.sofa.ark.api.ArkConfigs;
import com.alipay.sofa.ark.bootstrap.MainMethodRunner;
import com.alipay.sofa.ark.common.log.ArkLoggerFactory;
import com.alipay.sofa.ark.common.util.AssertUtils;
import com.alipay.sofa.ark.common.util.BizIdentityUtils;
import com.alipay.sofa.ark.common.util.ClassLoaderUtils;
import com.alipay.sofa.ark.common.util.ParseUtils;
import com.alipay.sofa.ark.common.util.StringUtils;
import com.alipay.sofa.ark.container.service.ArkServiceContainerHolder;
import com.alipay.sofa.ark.container.service.classloader.AbstractClasspathClassLoader;
import com.alipay.sofa.ark.exception.ArkRuntimeException;
import com.alipay.sofa.ark.loader.jar.JarUtils;
import com.alipay.sofa.ark.spi.event.ArkEvent;
import com.alipay.sofa.ark.spi.event.biz.AfterBizFailedEvent;
import com.alipay.sofa.ark.spi.event.biz.AfterBizStartupEvent;
import com.alipay.sofa.ark.spi.event.biz.AfterBizStopEvent;
import com.alipay.sofa.ark.spi.event.biz.BeforeBizRecycleEvent;
import com.alipay.sofa.ark.spi.event.biz.BeforeBizStartupEvent;
import com.alipay.sofa.ark.spi.event.biz.BeforeBizStopEvent;
import com.alipay.sofa.ark.spi.model.Biz;
import com.alipay.sofa.ark.spi.model.BizInfo;
import com.alipay.sofa.ark.spi.model.BizState;
import com.alipay.sofa.ark.spi.service.biz.BizManagerService;
import com.alipay.sofa.ark.spi.service.event.EventAdminService;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.io.FileUtils;

public class BizModel
implements Biz {
    private String bizName;
    private String bizVersion;
    private BizState bizState;
    private String mainClass;
    private String webContextPath;
    private URL[] urls;
    private URL bizUrl;
    private URL[] pluginUrls;
    private ClassLoader classLoader;
    private Map<String, String> attributes = new ConcurrentHashMap<String, String>();
    private int priority = 100;
    private Set<String> denyImportPackages;
    private Set<String> denyImportPackageNodes = new HashSet<String>();
    private Set<String> denyImportPackageStems = new HashSet<String>();
    private Set<String> denyImportClasses;
    private Set<String> denyImportResources = new HashSet<String>();
    private Set<String> injectPluginDependencies = new HashSet<String>();
    private Set<String> injectExportPackages = new HashSet<String>();
    private Set<String> declaredLibraries = new LinkedHashSet<String>();
    private Map<String, Boolean> declaredCacheMap = new ConcurrentHashMap<String, Boolean>();
    private Set<String> denyPrefixImportResourceStems = new HashSet<String>();
    private Set<String> denySuffixImportResourceStems = new HashSet<String>();
    private File bizTempWorkDir;
    private List<BizInfo.BizStateRecord> bizStateRecords = new CopyOnWriteArrayList<BizInfo.BizStateRecord>();

    public BizModel setBizName(String bizName) {
        AssertUtils.isFalse((boolean)StringUtils.isEmpty((String)bizName), (String)"Biz Name must not be empty!", (Object[])new Object[0]);
        this.bizName = bizName;
        return this;
    }

    public BizModel setBizVersion(String bizVersion) {
        AssertUtils.isFalse((boolean)StringUtils.isEmpty((String)bizVersion), (String)"Biz Version must not be empty!", (Object[])new Object[0]);
        this.bizVersion = bizVersion;
        return this;
    }

    public BizModel setBizState(BizState bizState) {
        this.bizState = bizState;
        this.addStateChangeLog(BizInfo.StateChangeReason.UNDEFINE, "");
        return this;
    }

    public BizModel setBizState(BizState bizState, BizInfo.StateChangeReason reason) {
        this.bizState = bizState;
        this.addStateChangeLog(reason, "");
        return this;
    }

    public BizModel setBizState(BizState bizState, BizInfo.StateChangeReason reason, String message) {
        this.bizState = bizState;
        this.addStateChangeLog(reason, message);
        return this;
    }

    public BizModel setMainClass(String mainClass) {
        AssertUtils.isFalse((boolean)StringUtils.isEmpty((String)mainClass), (String)"Biz Main Class must not be empty!", (Object[])new Object[0]);
        this.mainClass = mainClass;
        return this;
    }

    public BizModel setClassPath(URL[] urls) {
        this.urls = urls;
        return this;
    }

    public BizModel setBizUrl(URL url) {
        this.bizUrl = url;
        return this;
    }

    public BizModel setPluginClassPath(URL[] urls) {
        this.pluginUrls = urls;
        return this;
    }

    public BizModel setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public BizModel setPriority(String priority) {
        this.priority = priority == null ? 100 : Integer.valueOf(priority);
        return this;
    }

    public BizModel setWebContextPath(String webContextPath) {
        this.webContextPath = webContextPath == null ? "/" : webContextPath;
        return this;
    }

    public BizModel setDenyImportPackages(String denyImportPackages) {
        this.denyImportPackages = StringUtils.strToSet((String)denyImportPackages, (String)",");
        ParseUtils.parsePackageNodeAndStem(this.denyImportPackages, this.denyImportPackageStems, this.denyImportPackageNodes);
        return this;
    }

    public BizModel setDenyImportClasses(String denyImportClasses) {
        this.denyImportClasses = StringUtils.strToSet((String)denyImportClasses, (String)",");
        return this;
    }

    public BizModel setDenyImportResources(String denyImportResources) {
        ParseUtils.parseResourceAndStem((Set)StringUtils.strToSet((String)denyImportResources, (String)","), this.denyPrefixImportResourceStems, this.denySuffixImportResourceStems, this.denyImportResources);
        return this;
    }

    public BizModel setAttribute(String key, String val) {
        this.attributes.put(key, val);
        return this;
    }

    public BizModel setAttributes(Map<String, String> attributes) {
        this.attributes.putAll(attributes);
        return this;
    }

    public BizModel setInjectPluginDependencies(Set<String> injectPluginDependencies) {
        this.injectPluginDependencies = injectPluginDependencies;
        return this;
    }

    public BizModel setInjectExportPackages(String injectExportPackages) {
        this.injectExportPackages = StringUtils.strToSet((String)injectExportPackages, (String)",");
        return this;
    }

    public Set<String> getInjectExportPackages() {
        return this.injectExportPackages;
    }

    private void addStateChangeLog(BizInfo.StateChangeReason reason, String message) {
        this.bizStateRecords.add(new BizInfo.BizStateRecord(new Date(), this.bizState, reason, message));
    }

    public String getBizName() {
        return this.bizName;
    }

    public String getBizVersion() {
        return this.bizVersion;
    }

    public String getIdentity() {
        return BizIdentityUtils.generateBizIdentity((Biz)this);
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public URL[] getClassPath() {
        return this.urls;
    }

    public URL getBizUrl() {
        return this.bizUrl;
    }

    public int getPriority() {
        return this.priority;
    }

    public ClassLoader getBizClassLoader() {
        return this.classLoader;
    }

    public Set<String> getDenyImportPackages() {
        return this.denyImportPackages;
    }

    public Set<String> getDenyImportPackageNodes() {
        return this.denyImportPackageNodes;
    }

    public Set<String> getDenyImportPackageStems() {
        return this.denyImportPackageStems;
    }

    public Set<String> getDenyImportClasses() {
        return this.denyImportClasses;
    }

    public Set<String> getDenyImportResources() {
        return this.denyImportResources;
    }

    public Set<String> getInjectPluginDependencies() {
        return this.injectPluginDependencies;
    }

    public Set<String> getDenyPrefixImportResourceStems() {
        return this.denyPrefixImportResourceStems;
    }

    public Set<String> getDenySuffixImportResourceStems() {
        return this.denySuffixImportResourceStems;
    }

    public void start(String[] args) throws Throwable {
        this.doStart(args, null);
    }

    public void start(String[] args, Map<String, String> envs) throws Throwable {
        this.doStart(args, envs);
    }

    private void doStart(String[] args, Map<String, String> envs) throws Throwable {
        AssertUtils.isTrue((this.bizState == BizState.RESOLVED ? 1 : 0) != 0, (String)"BizState must be RESOLVED", (Object[])new Object[0]);
        if (this.mainClass == null) {
            throw new ArkRuntimeException(String.format("biz: %s has no main method", this.getBizName()));
        }
        ClassLoader oldClassLoader = ClassLoaderUtils.pushContextClassLoader((ClassLoader)this.classLoader);
        EventAdminService eventAdminService = ArkServiceContainerHolder.getContainer().getService(EventAdminService.class);
        try {
            eventAdminService.sendEvent((ArkEvent)new BeforeBizStartupEvent((Biz)this));
            this.resetProperties();
            if (!this.isMasterBizAndEmbedEnable()) {
                long start = System.currentTimeMillis();
                ArkLoggerFactory.getDefaultLogger().info("Ark biz {} start.", (Object)this.getIdentity());
                MainMethodRunner mainMethodRunner = new MainMethodRunner(this.mainClass, args, envs);
                mainMethodRunner.run();
                eventAdminService.sendEvent((ArkEvent)new AfterBizStartupEvent((Biz)this));
                ArkLoggerFactory.getDefaultLogger().info("Ark biz {} started in {} ms", (Object)this.getIdentity(), (Object)(System.currentTimeMillis() - start));
            }
        }
        catch (Throwable e) {
            this.setBizState(BizState.BROKEN, BizInfo.StateChangeReason.FAILED, e.getMessage());
            eventAdminService.sendEvent((ArkEvent)new AfterBizFailedEvent((Biz)this, e));
            throw e;
        }
        finally {
            ClassLoaderUtils.popContextClassLoader((ClassLoader)oldClassLoader);
        }
        BizManagerService bizManagerService = ArkServiceContainerHolder.getContainer().getService(BizManagerService.class);
        if (Boolean.getBoolean("activate.new.module")) {
            Biz currentActiveBiz = bizManagerService.getActiveBiz(this.bizName);
            if (currentActiveBiz == null) {
                this.setBizState(BizState.ACTIVATED, BizInfo.StateChangeReason.STARTED);
            } else {
                ((BizModel)currentActiveBiz).setBizState(BizState.DEACTIVATED, BizInfo.StateChangeReason.SWITCHED, String.format("switch to new biz %s", this.getIdentity()));
                this.setBizState(BizState.ACTIVATED, BizInfo.StateChangeReason.STARTED, String.format("switch from old biz: %s", currentActiveBiz.getIdentity()));
            }
        } else if (bizManagerService.getActiveBiz(this.bizName) == null) {
            this.setBizState(BizState.ACTIVATED, BizInfo.StateChangeReason.STARTED);
        } else {
            this.setBizState(BizState.DEACTIVATED, BizInfo.StateChangeReason.STARTED, "start but is deactivated");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        AssertUtils.isTrue((this.bizState == BizState.ACTIVATED || this.bizState == BizState.DEACTIVATED || this.bizState == BizState.BROKEN ? 1 : 0) != 0, (String)"BizState must be ACTIVATED, DEACTIVATED or BROKEN.", (Object[])new Object[0]);
        if (this.isMasterBizAndEmbedEnable()) {
            return;
        }
        ClassLoader oldClassLoader = ClassLoaderUtils.pushContextClassLoader((ClassLoader)this.classLoader);
        if (this.bizState == BizState.ACTIVATED) {
            this.setBizState(BizState.DEACTIVATED, BizInfo.StateChangeReason.KILLING);
        }
        EventAdminService eventAdminService = ArkServiceContainerHolder.getContainer().getService(EventAdminService.class);
        try {
            long start = System.currentTimeMillis();
            ArkLoggerFactory.getDefaultLogger().info("Ark biz {} stops.", (Object)this.getIdentity());
            eventAdminService.sendEvent((ArkEvent)new BeforeBizStopEvent((Biz)this));
            ArkLoggerFactory.getDefaultLogger().info("Ark biz {} stopped in {} ms", (Object)this.getIdentity(), (Object)(System.currentTimeMillis() - start));
        }
        finally {
            BizManagerService bizManagerService = ArkServiceContainerHolder.getContainer().getService(BizManagerService.class);
            bizManagerService.unRegisterBiz(this.bizName, this.bizVersion);
            this.setBizState(BizState.UNRESOLVED, BizInfo.StateChangeReason.STOPPED);
            eventAdminService.sendEvent((ArkEvent)new BeforeBizRecycleEvent((Biz)this));
            this.urls = null;
            this.denyImportPackages = null;
            this.denyImportClasses = null;
            this.denyImportResources = null;
            if (this.classLoader instanceof AbstractClasspathClassLoader) {
                try {
                    ((AbstractClasspathClassLoader)this.classLoader).close();
                    ((AbstractClasspathClassLoader)this.classLoader).clearCache();
                }
                catch (IOException e) {
                    ArkLoggerFactory.getDefaultLogger().warn("Ark biz {} close biz classloader fail", (Object)this.getIdentity());
                }
            }
            this.classLoader = null;
            BizModel.recycleBizTempWorkDir(this.bizTempWorkDir);
            this.bizTempWorkDir = null;
            ClassLoaderUtils.popContextClassLoader((ClassLoader)oldClassLoader);
            eventAdminService.sendEvent((ArkEvent)new AfterBizStopEvent((Biz)this));
        }
    }

    public void setCustomBizName(String bizName) {
        this.bizName = bizName;
    }

    public BizState getBizState() {
        return this.bizState;
    }

    public String getWebContextPath() {
        return this.webContextPath;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public List<BizInfo.BizStateRecord> getBizStateRecords() {
        return this.bizStateRecords;
    }

    public String toString() {
        return "Ark Biz: " + this.getIdentity() + ",\n biz url: " + this.bizUrl + ",\n classloader: " + this.classLoader + ",\n current state: " + this.bizState + ",\n history states: " + this.bizStateRecords;
    }

    private void resetProperties() {
        if (!ArkConfigs.isEmbedEnable()) {
            System.getProperties().remove("logging.path");
        } else if (this != ArkClient.getMasterBiz()) {
            System.getProperties().remove("spring.application.admin.enabled");
        }
    }

    public File getBizTempWorkDir() {
        return this.bizTempWorkDir;
    }

    public BizModel setBizTempWorkDir(File bizTempWorkDir) {
        this.bizTempWorkDir = bizTempWorkDir;
        return this;
    }

    private boolean isMasterBizAndEmbedEnable() {
        return this == ArkClient.getMasterBiz() && ArkConfigs.isEmbedEnable();
    }

    public BizModel setDeclaredLibraries(String declaredLibraries) {
        if (StringUtils.isEmpty((String)declaredLibraries)) {
            return this;
        }
        this.declaredLibraries = StringUtils.strToSet((String)declaredLibraries, (String)",");
        return this;
    }

    public boolean isDeclared(URL url, String resourceName) {
        if (!this.isDeclaredMode()) {
            return true;
        }
        if (url != null) {
            String libraryFile = url.getFile().replace("file:", "");
            if (!StringUtils.isEmpty((String)resourceName) && libraryFile.endsWith(resourceName)) {
                libraryFile = libraryFile.substring(0, libraryFile.lastIndexOf(resourceName));
            }
            return this.checkDeclaredWithCache(libraryFile);
        }
        return false;
    }

    public boolean isDeclaredMode() {
        return this.declaredLibraries != null && this.declaredLibraries.size() != 0;
    }

    private boolean checkDeclaredWithCache(String libraryFile) {
        return this.declaredCacheMap.computeIfAbsent(libraryFile, this::doCheckDeclared);
    }

    boolean doCheckDeclared(String jarFilePath) {
        if (this.isFromPlugin(jarFilePath)) {
            return true;
        }
        String artifactId = JarUtils.parseArtifactId((String)jarFilePath);
        if (artifactId == null) {
            if (jarFilePath.contains(".jar!") || jarFilePath.endsWith(".jar")) {
                ArkLoggerFactory.getDefaultLogger().info(String.format("Can't find artifact id for %s, default as declared.", jarFilePath));
                return true;
            }
            ArkLoggerFactory.getDefaultLogger().info(String.format("Can't find artifact id for %s, default as not declared.", jarFilePath));
            return false;
        }
        if (StringUtils.startWithToLowerCase((String)artifactId, (String)"sofa-ark-")) {
            return true;
        }
        return this.declaredLibraries.contains(artifactId);
    }

    private boolean isFromPlugin(String jarFilePath) {
        if (this.pluginUrls == null) {
            return false;
        }
        for (URL pluginUrl : this.pluginUrls) {
            String pluginUrlFile = pluginUrl.getFile().replace("file:", "");
            if (pluginUrlFile.endsWith("!/")) {
                pluginUrlFile = pluginUrlFile.substring(0, pluginUrlFile.length() - "!/".length());
            }
            if (!jarFilePath.contains(pluginUrlFile)) continue;
            return true;
        }
        return false;
    }

    public static boolean recycleBizTempWorkDir(File bizTempWorkDir) {
        if (bizTempWorkDir == null) {
            return false;
        }
        if (bizTempWorkDir.isDirectory()) {
            try {
                String newPath = BizModel.markBizTempWorkDirRecycled(bizTempWorkDir);
                File markedFile = new File(newPath);
                if (!markedFile.exists()) {
                    ArkLoggerFactory.getDefaultLogger().warn(String.format("when delete marked biz temp work dir %s, file not exists ", markedFile.getPath()));
                    return false;
                }
                return FileUtils.deleteQuietly((File)markedFile);
            }
            catch (IOException e) {
                throw new ArkRuntimeException("mark and delete biz temp work dir error: " + e.getMessage());
            }
        }
        return FileUtils.deleteQuietly((File)bizTempWorkDir);
    }

    private static String markBizTempWorkDirRecycled(File bizTempWorkDir) throws IOException {
        String sourcePath = bizTempWorkDir.getAbsolutePath();
        String targetPath = String.format("%s-%s-%s", sourcePath, System.currentTimeMillis(), "deleted");
        Files.move(Paths.get(sourcePath, new String[0]), Paths.get(targetPath, new String[0]), new CopyOption[0]);
        ArkLoggerFactory.getDefaultLogger().info(String.format("move biz temp work dir from %s to %s", sourcePath, targetPath));
        return targetPath;
    }
}

