/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.common.util;

import com.alipay.sofa.ark.common.util.FileUtils;
import com.alipay.sofa.ark.exception.ArkRuntimeException;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;

public class ClassLoaderUtils {
    private static final String JAVA_AGENT_MARK = "-javaagent:";
    private static final String JAVA_AGENT_OPTION_MARK = "=";
    private static final String SKYWALKING_AGENT_JAR = "skywalking-agent.jar";
    private static final String[] SKYWALKING_MOUNT_DIR = new String[]{"plugins", "activations"};

    public static ClassLoader pushContextClassLoader(ClassLoader newClassLoader) {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(newClassLoader);
        return oldClassLoader;
    }

    public static void popContextClassLoader(ClassLoader oldClassLoader) {
        Thread.currentThread().setContextClassLoader(oldClassLoader);
    }

    public static URL[] getAgentClassPath() {
        List<String> inputArguments = AccessController.doPrivileged(new PrivilegedAction<List<String>>(){

            @Override
            public List<String> run() {
                return ManagementFactory.getRuntimeMXBean().getInputArguments();
            }
        });
        ArrayList<URL> agentPaths = new ArrayList<URL>();
        for (String argument : inputArguments) {
            if (!argument.startsWith(JAVA_AGENT_MARK)) continue;
            argument = argument.substring(JAVA_AGENT_MARK.length());
            try {
                String path = argument.split(JAVA_AGENT_OPTION_MARK)[0];
                URL url = FileUtils.file(path).getCanonicalFile().toURI().toURL();
                agentPaths.add(url);
                ClassLoaderUtils.processSkyWalking(path, agentPaths);
            }
            catch (Throwable e) {
                throw new ArkRuntimeException("Failed to create java agent classloader", e);
            }
        }
        return agentPaths.toArray(new URL[0]);
    }

    public static void processSkyWalking(String path, List<URL> agentPaths) throws MalformedURLException, IOException {
        if (path.contains(SKYWALKING_AGENT_JAR)) {
            for (String mountFolder : SKYWALKING_MOUNT_DIR) {
                String[] jarFileNames;
                File folder = new File(FileUtils.file(path).getCanonicalFile().getParentFile(), mountFolder);
                if (!folder.exists() || !folder.isDirectory()) continue;
                for (String fileName : jarFileNames = folder.list((dir, name) -> name.endsWith(".jar"))) {
                    File jarFile = new File(folder, fileName);
                    agentPaths.add(jarFile.toURI().toURL());
                }
            }
        }
    }

    public static URL[] getURLs(ClassLoader classLoader) {
        if (classLoader instanceof URLClassLoader) {
            return ((URLClassLoader)classLoader).getURLs();
        }
        String classpath = System.getProperty("java.class.path");
        String[] classpathEntries = classpath.split(System.getProperty("path.separator"));
        ArrayList<URL> classpathURLs = new ArrayList<URL>();
        for (String classpathEntry : classpathEntries) {
            URL url = null;
            try {
                url = FileUtils.file(classpathEntry).toURI().toURL();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                throw new ArkRuntimeException("Failed to get urls from " + classLoader, (Throwable)e);
            }
            classpathURLs.add(url);
        }
        return classpathURLs.toArray(new URL[0]);
    }
}

