/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.spring.initializer;

import com.alipay.sofa.infra.utils.SOFABootEnvUtils;
import com.alipay.sofa.runtime.SofaFramework;
import com.alipay.sofa.runtime.api.client.ReferenceClient;
import com.alipay.sofa.runtime.api.client.ServiceClient;
import com.alipay.sofa.runtime.client.impl.ClientFactoryImpl;
import com.alipay.sofa.runtime.component.impl.StandardSofaRuntimeManager;
import com.alipay.sofa.runtime.ext.client.ExtensionClientImpl;
import com.alipay.sofa.runtime.service.client.ReferenceClientImpl;
import com.alipay.sofa.runtime.service.client.ServiceClientImpl;
import com.alipay.sofa.runtime.service.impl.BindingAdapterFactoryImpl;
import com.alipay.sofa.runtime.service.impl.BindingConverterFactoryImpl;
import com.alipay.sofa.runtime.spi.binding.BindingAdapter;
import com.alipay.sofa.runtime.spi.binding.BindingAdapterFactory;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeContext;
import com.alipay.sofa.runtime.spi.log.SofaLogger;
import com.alipay.sofa.runtime.spi.service.BindingConverter;
import com.alipay.sofa.runtime.spi.service.BindingConverterFactory;
import com.alipay.sofa.runtime.spring.ApplicationShutdownCallbackPostProcessor;
import com.alipay.sofa.runtime.spring.ClientFactoryBeanPostProcessor;
import com.alipay.sofa.runtime.spring.ExtensionClientBeanPostProcessor;
import com.alipay.sofa.runtime.spring.ReferenceAnnotationBeanPostProcessor;
import com.alipay.sofa.runtime.spring.ServiceBeanFactoryPostProcessor;
import com.alipay.sofa.runtime.spring.SofaRuntimeContextAwareProcessor;
import com.alipay.sofa.runtime.spring.bean.SofaParameterNameDiscoverer;
import com.alipay.sofa.runtime.spring.configuration.SofaRuntimeAutoConfiguration;
import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

public class SofaRuntimeSpringContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private static BindingConverterFactory bindingConverterFactory;
    private static BindingAdapterFactory bindingAdapterFactory;
    private static SofaRuntimeContext sofaRuntimeContext;
    private static AtomicBoolean isInitiated;

    public static void initApplicationContext(ConfigurableApplicationContext applicationContext) {
        ConfigurableListableBeanFactory beanFactory = applicationContext.getBeanFactory();
        applicationContext.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)new ServiceBeanFactoryPostProcessor(applicationContext, sofaRuntimeContext, bindingConverterFactory));
        beanFactory.registerSingleton("bindingConverterFactory", (Object)bindingConverterFactory);
        beanFactory.registerSingleton("bindingAdapterFactory", (Object)bindingAdapterFactory);
        beanFactory.registerSingleton("sofaRuntimeContext", (Object)sofaRuntimeContext);
        beanFactory.addBeanPostProcessor((BeanPostProcessor)new SofaRuntimeContextAwareProcessor(sofaRuntimeContext));
        beanFactory.addBeanPostProcessor((BeanPostProcessor)new ClientFactoryBeanPostProcessor(sofaRuntimeContext.getClientFactory()));
        beanFactory.addBeanPostProcessor((BeanPostProcessor)new ExtensionClientBeanPostProcessor(new ExtensionClientImpl(sofaRuntimeContext)));
        beanFactory.addBeanPostProcessor((BeanPostProcessor)new ReferenceAnnotationBeanPostProcessor((ApplicationContext)applicationContext, sofaRuntimeContext, bindingAdapterFactory, bindingConverterFactory));
        ApplicationShutdownCallbackPostProcessor applicationShutdownCallbackPostProcessor = new ApplicationShutdownCallbackPostProcessor(sofaRuntimeContext.getSofaRuntimeManager());
        beanFactory.addBeanPostProcessor((BeanPostProcessor)applicationShutdownCallbackPostProcessor);
        beanFactory.registerSingleton(ApplicationShutdownCallbackPostProcessor.class.getCanonicalName(), (Object)applicationShutdownCallbackPostProcessor);
        if (beanFactory instanceof AbstractAutowireCapableBeanFactory) {
            ((AbstractAutowireCapableBeanFactory)beanFactory).setParameterNameDiscoverer((ParameterNameDiscoverer)new SofaParameterNameDiscoverer((Environment)applicationContext.getEnvironment()));
        }
    }

    public static void setIsInitiated(boolean isInitiated) {
        SofaRuntimeSpringContextInitializer.isInitiated.set(isInitiated);
    }

    public void initialize(ConfigurableApplicationContext applicationContext) {
        ConfigurableEnvironment environment = applicationContext.getEnvironment();
        if (isInitiated.compareAndSet(false, true)) {
            bindingConverterFactory = this.bindingConverterFactory();
            bindingAdapterFactory = this.bindingAdapterFactory();
            sofaRuntimeContext = this.sofaRuntimeContext(environment.getProperty("spring.application.name"), bindingConverterFactory, bindingAdapterFactory);
        }
        SofaRuntimeSpringContextInitializer.initApplicationContext(applicationContext);
        if (SOFABootEnvUtils.isSpringCloudBootstrapEnvironment((Environment)environment)) {
            return;
        }
        SofaLogger.info("SOFABoot Runtime Starting!", new Object[0]);
    }

    private BindingConverterFactory bindingConverterFactory() {
        BindingConverterFactoryImpl bindingConverterFactory = new BindingConverterFactoryImpl();
        bindingConverterFactory.addBindingConverters(this.getClassesByServiceLoader(BindingConverter.class));
        return bindingConverterFactory;
    }

    private BindingAdapterFactory bindingAdapterFactory() {
        BindingAdapterFactoryImpl bindingAdapterFactory = new BindingAdapterFactoryImpl();
        bindingAdapterFactory.addBindingAdapters(this.getClassesByServiceLoader(BindingAdapter.class));
        return bindingAdapterFactory;
    }

    private SofaRuntimeContext sofaRuntimeContext(String appName, BindingConverterFactory bindingConverterFactory, BindingAdapterFactory bindingAdapterFactory) {
        ClientFactoryImpl clientFactoryInternal = new ClientFactoryImpl();
        StandardSofaRuntimeManager sofaRuntimeManager = new StandardSofaRuntimeManager(appName, SofaRuntimeAutoConfiguration.class.getClassLoader(), clientFactoryInternal);
        sofaRuntimeManager.getComponentManager().registerComponentClient(ReferenceClient.class, new ReferenceClientImpl(sofaRuntimeManager.getSofaRuntimeContext(), bindingConverterFactory, bindingAdapterFactory));
        sofaRuntimeManager.getComponentManager().registerComponentClient(ServiceClient.class, new ServiceClientImpl(sofaRuntimeManager.getSofaRuntimeContext(), bindingConverterFactory, bindingAdapterFactory));
        SofaFramework.registerSofaRuntimeManager(sofaRuntimeManager);
        return sofaRuntimeManager.getSofaRuntimeContext();
    }

    private <T> Set<T> getClassesByServiceLoader(Class<T> clazz) {
        ServiceLoader<T> serviceLoader = ServiceLoader.load(clazz);
        HashSet<T> result = new HashSet<T>();
        for (T t : serviceLoader) {
            result.add(t);
        }
        return result;
    }

    static {
        isInitiated = new AtomicBoolean(false);
    }
}

