/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.spring.factory;

import com.alipay.sofa.runtime.api.ServiceRuntimeException;
import com.alipay.sofa.runtime.api.annotation.SofaService;
import com.alipay.sofa.runtime.model.InterfaceMode;
import com.alipay.sofa.runtime.service.binding.JvmBinding;
import com.alipay.sofa.runtime.service.component.Service;
import com.alipay.sofa.runtime.service.component.ServiceComponent;
import com.alipay.sofa.runtime.service.component.impl.ServiceImpl;
import com.alipay.sofa.runtime.spi.binding.Binding;
import com.alipay.sofa.runtime.spi.component.DefaultImplementation;
import com.alipay.sofa.runtime.spi.service.BindingConverterContext;
import com.alipay.sofa.runtime.spring.factory.AbstractContractFactoryBean;

public class ServiceFactoryBean
extends AbstractContractFactoryBean {
    private Object ref;
    private Service service;

    public ServiceFactoryBean() {
    }

    public ServiceFactoryBean(String interfaceType) {
        this.interfaceType = interfaceType;
    }

    @Override
    protected void doAfterPropertiesSet() {
        if (this.hasSofaServiceAnnotation()) {
            throw new ServiceRuntimeException("Bean " + this.beanId + " of type " + this.ref.getClass() + " has already annotated by @SofaService," + " can not be registered using xml. Please check it.");
        }
        DefaultImplementation implementation = new DefaultImplementation();
        implementation.setTarget(this.ref);
        this.service = this.buildService();
        if (this.bindings.size() == 0) {
            this.bindings.add(new JvmBinding());
        }
        for (Binding binding : this.bindings) {
            this.service.addBinding(binding);
        }
        ServiceComponent componentInfo = new ServiceComponent(implementation, this.service, this.bindingAdapterFactory, this.sofaRuntimeContext);
        this.sofaRuntimeContext.getComponentManager().register(componentInfo);
    }

    private boolean hasSofaServiceAnnotation() {
        Class<?> implementationClazz = this.ref.getClass();
        SofaService sofaService = implementationClazz.getAnnotation(SofaService.class);
        if (sofaService == null) {
            return false;
        }
        String annotationUniqueId = sofaService.uniqueId();
        if ((this.uniqueId == null || this.uniqueId.isEmpty()) && (annotationUniqueId == null || annotationUniqueId.isEmpty())) {
            return true;
        }
        return annotationUniqueId.equals(this.uniqueId);
    }

    @Override
    protected void setProperties(BindingConverterContext bindingConverterContext) {
        bindingConverterContext.setBeanId(this.beanId);
    }

    private Service buildService() {
        return new ServiceImpl(this.uniqueId, this.getInterfaceClass(), InterfaceMode.spring, this.ref);
    }

    public Object getObject() throws Exception {
        return this.service;
    }

    public Class<?> getObjectType() {
        return this.service != null ? this.service.getClass() : Service.class;
    }

    @Override
    protected boolean isInBinding() {
        return false;
    }

    public void setRef(Object ref) {
        this.ref = ref;
    }
}

