/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.infra.listener;

import com.alipay.sofa.infra.utils.SOFABootEnvUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.StreamSupport;
import org.springframework.boot.Banner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.config.ConfigFileApplicationListener;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class SofaBootstrapRunListener
implements ApplicationListener<ApplicationEnvironmentPreparedEvent>,
Ordered {
    private static final String LOGGING_PATH = "logging.path";
    private static final String LOGGING_LEVEL = "logging.level";
    private static AtomicBoolean executed = new AtomicBoolean(false);

    private void assemblyLogSetting(ConfigurableEnvironment environment) {
        if (StringUtils.hasText((String)environment.getProperty(LOGGING_PATH))) {
            System.getProperties().setProperty(LOGGING_PATH, environment.getProperty(LOGGING_PATH));
        }
        StreamSupport.stream(environment.getPropertySources().spliterator(), false).filter(propertySource -> propertySource instanceof MapPropertySource).map(propertySource -> Arrays.asList(((MapPropertySource)propertySource).getPropertyNames())).flatMap(Collection::stream).filter(key -> key.startsWith(LOGGING_LEVEL)).forEach(key -> System.getProperties().setProperty((String)key, environment.getProperty(key)));
    }

    private void assemblyRequireProperties(ConfigurableEnvironment environment) {
        if (StringUtils.hasText((String)environment.getProperty("spring.application.name"))) {
            System.getProperties().setProperty("spring.application.name", environment.getProperty("spring.application.name"));
        }
    }

    private void assemblyEnvironmentMark(ConfigurableEnvironment environment) {
        environment.getPropertySources().addFirst((PropertySource)new MapPropertySource("sofaBootstrap", new HashMap()));
    }

    private void unAssemblyEnvironmentMark(ConfigurableEnvironment environment) {
        environment.getPropertySources().remove("sofaBootstrap");
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        ConfigurableEnvironment environment = event.getEnvironment();
        SpringApplication application = event.getSpringApplication();
        if (SOFABootEnvUtils.isSpringCloud() && executed.compareAndSet(false, true)) {
            StandardEnvironment bootstrapEnvironment = new StandardEnvironment();
            for (Object source : event.getEnvironment().getPropertySources()) {
                if (source instanceof PropertySource.StubPropertySource) continue;
                bootstrapEnvironment.getPropertySources().addLast((PropertySource)source);
            }
            ArrayList<Class> sources = new ArrayList<Class>();
            for (Object s : application.getAllSources()) {
                if (s instanceof Class) {
                    sources.add((Class)s);
                    continue;
                }
                if (!(s instanceof String)) continue;
                sources.add(ClassUtils.resolveClassName((String)((String)s), null));
            }
            SpringApplication bootstrapApplication = new SpringApplicationBuilder(new Class[0]).profiles(environment.getActiveProfiles()).bannerMode(Banner.Mode.OFF).environment((ConfigurableEnvironment)bootstrapEnvironment).sources(sources.toArray(new Class[0])).registerShutdownHook(false).logStartupInfo(false).web(WebApplicationType.NONE).listeners(new ApplicationListener[0]).initializers(new ApplicationContextInitializer[0]).build(event.getArgs());
            ApplicationEnvironmentPreparedEvent bootstrapEvent = new ApplicationEnvironmentPreparedEvent(bootstrapApplication, event.getArgs(), (ConfigurableEnvironment)bootstrapEnvironment);
            application.getListeners().stream().filter(listener -> listener instanceof ConfigFileApplicationListener).forEach(listener -> ((ConfigFileApplicationListener)listener).onApplicationEvent((ApplicationEvent)bootstrapEvent));
            this.assemblyLogSetting((ConfigurableEnvironment)bootstrapEnvironment);
            this.assemblyRequireProperties((ConfigurableEnvironment)bootstrapEnvironment);
            this.assemblyEnvironmentMark(environment);
        } else {
            this.unAssemblyEnvironmentMark(environment);
        }
    }
}

