/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.infra.initializer;

import com.alipay.sofa.infra.log.InfraHealthCheckLoggerFactory;
import com.alipay.sofa.infra.log.space.SofaBootLogSpaceIsolationInit;
import com.alipay.sofa.infra.utils.SOFABootEnvUtils;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

public class SOFABootInfrastructureSpringContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext>,
Ordered {
    public void initialize(ConfigurableApplicationContext applicationContext) {
        ConfigurableEnvironment environment = applicationContext.getEnvironment();
        if (SOFABootEnvUtils.isSpringCloudBootstrapEnvironment((Environment)environment)) {
            return;
        }
        String infraLogLevelKey = "logging.level.com.alipay.sofa.infra";
        SofaBootLogSpaceIsolationInit.initSofaBootLogger((Environment)environment, infraLogLevelKey);
        InfraHealthCheckLoggerFactory.getLogger(SOFABootInfrastructureSpringContextInitializer.class).info("SOFABoot Infrastructure Starting!");
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

