/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.infra.env;

import com.alipay.sofa.infra.autoconfigure.SofaBootInfraAutoConfiguration;
import java.util.Properties;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

public class EnvironmentCustomizer
implements EnvironmentPostProcessor {
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        PropertiesPropertySource propertySource = new PropertiesPropertySource("version", this.getSofaBootVersionProperties());
        environment.getPropertySources().addLast((PropertySource)propertySource);
        environment.setRequiredProperties(new String[]{"spring.application.name"});
    }

    private Properties getSofaBootVersionProperties() {
        Properties properties = new Properties();
        String sofaBootVersion = SofaBootInfraAutoConfiguration.class.getPackage().getImplementationVersion();
        sofaBootVersion = StringUtils.isEmpty((Object)sofaBootVersion) ? "" : sofaBootVersion;
        String sofaBootFormattedVersion = sofaBootVersion.isEmpty() ? "" : String.format(" (v%s)", sofaBootVersion);
        properties.setProperty("sofa-boot.version", sofaBootVersion);
        properties.setProperty("sofa-boot.formatted-version", sofaBootFormattedVersion);
        return properties;
    }
}

