/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.utils;

import com.alipay.sofa.common.utils.ArrayUtil;
import java.util.ArrayList;
import java.util.Iterator;

public class StringUtil {
    public static final String EMPTY_STRING = "";
    private static final WordTokenizer CAMEL_CASE_TOKENIZER = new WordTokenizer(){

        @Override
        protected void startSentence(StringBuffer buffer, char ch) {
            buffer.append(Character.toLowerCase(ch));
        }

        @Override
        protected void startWord(StringBuffer buffer, char ch) {
            if (!this.isDelimiter(buffer.charAt(buffer.length() - 1))) {
                buffer.append(Character.toUpperCase(ch));
            } else {
                buffer.append(Character.toLowerCase(ch));
            }
        }

        @Override
        protected void inWord(StringBuffer buffer, char ch) {
            buffer.append(Character.toLowerCase(ch));
        }

        @Override
        protected void startDigitSentence(StringBuffer buffer, char ch) {
            buffer.append(ch);
        }

        @Override
        protected void startDigitWord(StringBuffer buffer, char ch) {
            buffer.append(ch);
        }

        @Override
        protected void inDigitWord(StringBuffer buffer, char ch) {
            buffer.append(ch);
        }

        @Override
        protected void inDelimiter(StringBuffer buffer, char ch) {
            if (ch != '_') {
                buffer.append(ch);
            }
        }
    };
    private static final WordTokenizer PASCAL_CASE_TOKENIZER = new WordTokenizer(){

        @Override
        protected void startSentence(StringBuffer buffer, char ch) {
            buffer.append(Character.toUpperCase(ch));
        }

        @Override
        protected void startWord(StringBuffer buffer, char ch) {
            buffer.append(Character.toUpperCase(ch));
        }

        @Override
        protected void inWord(StringBuffer buffer, char ch) {
            buffer.append(Character.toLowerCase(ch));
        }

        @Override
        protected void startDigitSentence(StringBuffer buffer, char ch) {
            buffer.append(ch);
        }

        @Override
        protected void startDigitWord(StringBuffer buffer, char ch) {
            buffer.append(ch);
        }

        @Override
        protected void inDigitWord(StringBuffer buffer, char ch) {
            buffer.append(ch);
        }

        @Override
        protected void inDelimiter(StringBuffer buffer, char ch) {
            if (ch != '_') {
                buffer.append(ch);
            }
        }
    };
    private static final WordTokenizer UPPER_CASE_WITH_UNDERSCORES_TOKENIZER = new WordTokenizer(){

        @Override
        protected void startSentence(StringBuffer buffer, char ch) {
            buffer.append(Character.toUpperCase(ch));
        }

        @Override
        protected void startWord(StringBuffer buffer, char ch) {
            if (!this.isDelimiter(buffer.charAt(buffer.length() - 1))) {
                buffer.append('_');
            }
            buffer.append(Character.toUpperCase(ch));
        }

        @Override
        protected void inWord(StringBuffer buffer, char ch) {
            buffer.append(Character.toUpperCase(ch));
        }

        @Override
        protected void startDigitSentence(StringBuffer buffer, char ch) {
            buffer.append(ch);
        }

        @Override
        protected void startDigitWord(StringBuffer buffer, char ch) {
            if (!this.isDelimiter(buffer.charAt(buffer.length() - 1))) {
                buffer.append('_');
            }
            buffer.append(ch);
        }

        @Override
        protected void inDigitWord(StringBuffer buffer, char ch) {
            buffer.append(ch);
        }

        @Override
        protected void inDelimiter(StringBuffer buffer, char ch) {
            buffer.append(ch);
        }
    };
    private static final WordTokenizer LOWER_CASE_WITH_UNDERSCORES_TOKENIZER = new WordTokenizer(){

        @Override
        protected void startSentence(StringBuffer buffer, char ch) {
            buffer.append(Character.toLowerCase(ch));
        }

        @Override
        protected void startWord(StringBuffer buffer, char ch) {
            if (!this.isDelimiter(buffer.charAt(buffer.length() - 1))) {
                buffer.append('_');
            }
            buffer.append(Character.toLowerCase(ch));
        }

        @Override
        protected void inWord(StringBuffer buffer, char ch) {
            buffer.append(Character.toLowerCase(ch));
        }

        @Override
        protected void startDigitSentence(StringBuffer buffer, char ch) {
            buffer.append(ch);
        }

        @Override
        protected void startDigitWord(StringBuffer buffer, char ch) {
            if (!this.isDelimiter(buffer.charAt(buffer.length() - 1))) {
                buffer.append('_');
            }
            buffer.append(ch);
        }

        @Override
        protected void inDigitWord(StringBuffer buffer, char ch) {
            buffer.append(ch);
        }

        @Override
        protected void inDelimiter(StringBuffer buffer, char ch) {
            buffer.append(ch);
        }
    };

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return str != null && str.length() > 0;
    }

    public static boolean isBlank(String str) {
        int length;
        if (str != null && (length = str.length()) != 0) {
            for (int i = 0; i < length; ++i) {
                if (Character.isWhitespace(str.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public static boolean isNotBlank(String str) {
        int length;
        if (str != null && (length = str.length()) != 0) {
            for (int i = 0; i < length; ++i) {
                if (Character.isWhitespace(str.charAt(i))) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static String defaultIfNull(String str) {
        return str == null ? EMPTY_STRING : str;
    }

    public static String defaultIfNull(String str, String defaultStr) {
        return str == null ? defaultStr : str;
    }

    public static String defaultIfEmpty(String str) {
        return str == null ? EMPTY_STRING : str;
    }

    public static String defaultIfEmpty(String str, String defaultStr) {
        return str != null && str.length() != 0 ? str : defaultStr;
    }

    public static String defaultIfBlank(String str) {
        return StringUtil.isBlank(str) ? EMPTY_STRING : str;
    }

    public static String defaultIfBlank(String str, String defaultStr) {
        return StringUtil.isBlank(str) ? defaultStr : str;
    }

    public static String trim(String str) {
        return StringUtil.trim(str, null, 0);
    }

    public static String trim(String str, String stripChars) {
        return StringUtil.trim(str, stripChars, 0);
    }

    public static String trimStart(String str) {
        return StringUtil.trim(str, null, -1);
    }

    public static String trimStart(String str, String stripChars) {
        return StringUtil.trim(str, stripChars, -1);
    }

    public static String trimEnd(String str) {
        return StringUtil.trim(str, null, 1);
    }

    public static String trimEnd(String str, String stripChars) {
        return StringUtil.trim(str, stripChars, 1);
    }

    public static String trimToNull(String str) {
        return StringUtil.trimToNull(str, null);
    }

    public static String trimToNull(String str, String stripChars) {
        String result = StringUtil.trim(str, stripChars);
        return result != null && result.length() != 0 ? result : null;
    }

    public static String trimToEmpty(String str) {
        return StringUtil.trimToEmpty(str, null);
    }

    public static String trimToEmpty(String str, String stripChars) {
        String result = StringUtil.trim(str, stripChars);
        return result == null ? EMPTY_STRING : result;
    }

    private static String trim(String str, String stripChars, int mode) {
        int start;
        int end;
        int length;
        block12: {
            if (str == null) {
                return null;
            }
            length = str.length();
            end = length;
            if (mode <= 0) {
                if (stripChars == null) {
                    for (start = 0; start < end && Character.isWhitespace(str.charAt(start)); ++start) {
                    }
                } else {
                    if (stripChars.length() == 0) {
                        return str;
                    }
                    while (start < end && stripChars.indexOf(str.charAt(start)) != -1) {
                        ++start;
                    }
                }
            }
            if (mode < 0) break block12;
            if (stripChars == null) {
                while (start < end && Character.isWhitespace(str.charAt(end - 1))) {
                    --end;
                }
            } else {
                if (stripChars.length() == 0) {
                    return str;
                }
                while (start < end && stripChars.indexOf(str.charAt(end - 1)) != -1) {
                    --end;
                }
            }
        }
        return start <= 0 && end >= length ? str : str.substring(start, end);
    }

    public static boolean equals(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equals(str2);
    }

    public static boolean equalsIgnoreCase(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equalsIgnoreCase(str2);
    }

    public static boolean isAlpha(String str) {
        if (str == null) {
            return false;
        }
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            if (Character.isLetter(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphaSpace(String str) {
        if (str == null) {
            return false;
        }
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            if (Character.isLetter(str.charAt(i)) || str.charAt(i) == ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphanumeric(String str) {
        if (str == null) {
            return false;
        }
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            if (Character.isLetterOrDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphanumericSpace(String str) {
        if (str == null) {
            return false;
        }
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            if (Character.isLetterOrDigit(str.charAt(i)) || str.charAt(i) == ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean isNumeric(String str) {
        if (str == null) {
            return false;
        }
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumericSpace(String str) {
        if (str == null) {
            return false;
        }
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            if (Character.isDigit(str.charAt(i)) || str.charAt(i) == ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean isWhitespace(String str) {
        if (str == null) {
            return false;
        }
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String toUpperCase(String str) {
        return str == null ? null : str.toUpperCase();
    }

    public static String toLowerCase(String str) {
        return str == null ? null : str.toLowerCase();
    }

    public static String capitalize(String str) {
        int strLen;
        return str != null && (strLen = str.length()) != 0 ? new StringBuffer(strLen).append(Character.toTitleCase(str.charAt(0))).append(str.substring(1)).toString() : str;
    }

    public static String uncapitalize(String str) {
        int strLen;
        return str != null && (strLen = str.length()) != 0 ? new StringBuffer(strLen).append(Character.toLowerCase(str.charAt(0))).append(str.substring(1)).toString() : str;
    }

    public static String swapCase(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        StringBuffer buffer = new StringBuffer(strLen);
        char ch = '\u0000';
        for (int i = 0; i < strLen; ++i) {
            ch = str.charAt(i);
            if (Character.isUpperCase(ch)) {
                ch = Character.toLowerCase(ch);
            } else if (Character.isTitleCase(ch)) {
                ch = Character.toLowerCase(ch);
            } else if (Character.isLowerCase(ch)) {
                ch = Character.toUpperCase(ch);
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }

    public static String toCamelCase(String str) {
        return CAMEL_CASE_TOKENIZER.parse(str);
    }

    public static String toPascalCase(String str) {
        return PASCAL_CASE_TOKENIZER.parse(str);
    }

    public static String toUpperCaseWithUnderscores(String str) {
        return UPPER_CASE_WITH_UNDERSCORES_TOKENIZER.parse(str);
    }

    public static String toLowerCaseWithUnderscores(String str) {
        return LOWER_CASE_WITH_UNDERSCORES_TOKENIZER.parse(str);
    }

    public static String[] split(String str) {
        return StringUtil.split(str, null, -1);
    }

    public static String[] split(String str, char separatorChar) {
        if (str == null) {
            return null;
        }
        int length = str.length();
        if (length == 0) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int start = 0;
        boolean match = false;
        while (i < length) {
            if (str.charAt(i) == separatorChar) {
                if (match) {
                    list.add(str.substring(start, i));
                    match = false;
                }
                start = ++i;
                continue;
            }
            match = true;
            ++i;
        }
        if (match) {
            list.add(str.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }

    public static String[] split(String str, String separatorChars) {
        return StringUtil.split(str, separatorChars, -1);
    }

    public static String[] split(String str, String separatorChars, int max) {
        if (str == null) {
            return null;
        }
        int length = str.length();
        if (length == 0) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> list = new ArrayList<String>();
        int sizePlus1 = 1;
        int i = 0;
        int start = 0;
        boolean match = false;
        if (separatorChars == null) {
            while (i < length) {
                if (Character.isWhitespace(str.charAt(i))) {
                    if (match) {
                        if (sizePlus1++ == max) {
                            i = length;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                match = true;
                ++i;
            }
        } else if (separatorChars.length() == 1) {
            char sep = separatorChars.charAt(0);
            while (i < length) {
                if (str.charAt(i) == sep) {
                    if (match) {
                        if (sizePlus1++ == max) {
                            i = length;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                match = true;
                ++i;
            }
        } else {
            while (i < length) {
                if (separatorChars.indexOf(str.charAt(i)) >= 0) {
                    if (match) {
                        if (sizePlus1++ == max) {
                            i = length;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                match = true;
                ++i;
            }
        }
        if (match) {
            list.add(str.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }

    public static String join(Object[] array) {
        return StringUtil.join(array, (String)null);
    }

    public static String join(Object[] array, char separator) {
        if (array == null) {
            return null;
        }
        int arraySize = array.length;
        int bufSize = arraySize == 0 ? 0 : ((array[0] == null ? 16 : array[0].toString().length()) + 1) * arraySize;
        StringBuffer buf = new StringBuffer(bufSize);
        for (int i = 0; i < arraySize; ++i) {
            if (i > 0) {
                buf.append(separator);
            }
            if (array[i] == null) continue;
            buf.append(array[i]);
        }
        return buf.toString();
    }

    public static String join(Object[] array, String separator) {
        int arraySize;
        if (array == null) {
            return null;
        }
        if (separator == null) {
            separator = EMPTY_STRING;
        }
        int bufSize = (arraySize = array.length) == 0 ? 0 : arraySize * ((array[0] == null ? 16 : array[0].toString().length()) + (separator != null ? separator.length() : 0));
        StringBuffer buf = new StringBuffer(bufSize);
        for (int i = 0; i < arraySize; ++i) {
            if (separator != null && i > 0) {
                buf.append(separator);
            }
            if (array[i] == null) continue;
            buf.append(array[i]);
        }
        return buf.toString();
    }

    public static String join(Iterator iterator, char separator) {
        if (iterator == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer(256);
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (obj != null) {
                buf.append(obj);
            }
            if (!iterator.hasNext()) continue;
            buf.append(separator);
        }
        return buf.toString();
    }

    public static String join(Iterator iterator, String separator) {
        if (iterator == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer(256);
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (obj != null) {
                buf.append(obj);
            }
            if (separator == null || !iterator.hasNext()) continue;
            buf.append(separator);
        }
        return buf.toString();
    }

    public static int indexOf(String str, char searchChar) {
        return str != null && str.length() != 0 ? str.indexOf(searchChar) : -1;
    }

    public static int indexOf(String str, char searchChar, int startPos) {
        return str != null && str.length() != 0 ? str.indexOf(searchChar, startPos) : -1;
    }

    public static int indexOf(String str, String searchStr) {
        return str != null && searchStr != null ? str.indexOf(searchStr) : -1;
    }

    public static int indexOf(String str, String searchStr, int startPos) {
        return str != null && searchStr != null ? (searchStr.length() == 0 && startPos >= str.length() ? str.length() : str.indexOf(searchStr, startPos)) : -1;
    }

    public static int indexOfAny(String str, char[] searchChars) {
        if (str != null && str.length() != 0 && searchChars != null && searchChars.length != 0) {
            for (int i = 0; i < str.length(); ++i) {
                char ch = str.charAt(i);
                for (int j = 0; j < searchChars.length; ++j) {
                    if (searchChars[j] != ch) continue;
                    return i;
                }
            }
            return -1;
        }
        return -1;
    }

    public static int indexOfAny(String str, String searchChars) {
        if (str != null && str.length() != 0 && searchChars != null && searchChars.length() != 0) {
            for (int i = 0; i < str.length(); ++i) {
                char ch = str.charAt(i);
                for (int j = 0; j < searchChars.length(); ++j) {
                    if (searchChars.charAt(j) != ch) continue;
                    return i;
                }
            }
            return -1;
        }
        return -1;
    }

    public static int indexOfAny(String str, String[] searchStrs) {
        if (str == null || searchStrs == null) {
            return -1;
        }
        int sz = searchStrs.length;
        int ret = Integer.MAX_VALUE;
        int tmp = 0;
        for (int i = 0; i < sz; ++i) {
            String search = searchStrs[i];
            if (search == null || (tmp = str.indexOf(search)) == -1 || tmp >= ret) continue;
            ret = tmp;
        }
        return ret == Integer.MAX_VALUE ? -1 : ret;
    }

    public static int indexOfAnyBut(String str, char[] searchChars) {
        if (str != null && str.length() != 0 && searchChars != null && searchChars.length != 0) {
            block0: for (int i = 0; i < str.length(); ++i) {
                char ch = str.charAt(i);
                for (int j = 0; j < searchChars.length; ++j) {
                    if (searchChars[j] == ch) continue block0;
                }
                return i;
            }
            return -1;
        }
        return -1;
    }

    public static int indexOfAnyBut(String str, String searchChars) {
        if (str != null && str.length() != 0 && searchChars != null && searchChars.length() != 0) {
            for (int i = 0; i < str.length(); ++i) {
                if (searchChars.indexOf(str.charAt(i)) >= 0) continue;
                return i;
            }
            return -1;
        }
        return -1;
    }

    public static int lastIndexOf(String str, char searchChar) {
        return str != null && str.length() != 0 ? str.lastIndexOf(searchChar) : -1;
    }

    public static int lastIndexOf(String str, char searchChar, int startPos) {
        return str != null && str.length() != 0 ? str.lastIndexOf(searchChar, startPos) : -1;
    }

    public static int lastIndexOf(String str, String searchStr) {
        return str != null && searchStr != null ? str.lastIndexOf(searchStr) : -1;
    }

    public static int lastIndexOf(String str, String searchStr, int startPos) {
        return str != null && searchStr != null ? str.lastIndexOf(searchStr, startPos) : -1;
    }

    public static int lastIndexOfAny(String str, String[] searchStrs) {
        if (str == null || searchStrs == null) {
            return -1;
        }
        int searchStrsLength = searchStrs.length;
        int index = -1;
        int tmp = 0;
        for (int i = 0; i < searchStrsLength; ++i) {
            String search = searchStrs[i];
            if (search == null || (tmp = str.lastIndexOf(search)) <= index) continue;
            index = tmp;
        }
        return index;
    }

    public static boolean contains(String str, char searchChar) {
        return str != null && str.length() != 0 ? str.indexOf(searchChar) >= 0 : false;
    }

    public static boolean contains(String str, String searchStr) {
        return str != null && searchStr != null ? str.indexOf(searchStr) >= 0 : false;
    }

    public static boolean containsOnly(String str, char[] valid) {
        return valid != null && str != null ? (str.length() == 0 ? true : (valid.length == 0 ? false : StringUtil.indexOfAnyBut(str, valid) == -1)) : false;
    }

    public static boolean containsOnly(String str, String valid) {
        return str != null && valid != null ? StringUtil.containsOnly(str, valid.toCharArray()) : false;
    }

    public static boolean containsNone(String str, char[] invalid) {
        if (str != null && invalid != null) {
            int strSize = str.length();
            int validSize = invalid.length;
            for (int i = 0; i < strSize; ++i) {
                char ch = str.charAt(i);
                for (int j = 0; j < validSize; ++j) {
                    if (invalid[j] != ch) continue;
                    return false;
                }
            }
            return true;
        }
        return true;
    }

    public static boolean containsNone(String str, String invalidChars) {
        return str != null && invalidChars != null ? StringUtil.containsNone(str, invalidChars.toCharArray()) : true;
    }

    public static int countMatches(String str, String subStr) {
        if (str != null && str.length() != 0 && subStr != null && subStr.length() != 0) {
            int count = 0;
            int index = 0;
            while ((index = str.indexOf(subStr, index)) != -1) {
                ++count;
                index += subStr.length();
            }
            return count;
        }
        return 0;
    }

    public static String substring(String str, int start) {
        if (str == null) {
            return null;
        }
        if (start < 0) {
            start += str.length();
        }
        if (start < 0) {
            start = 0;
        }
        return start > str.length() ? EMPTY_STRING : str.substring(start);
    }

    public static String substring(String str, int start, int end) {
        if (str == null) {
            return null;
        }
        if (end < 0) {
            end += str.length();
        }
        if (start < 0) {
            start += str.length();
        }
        if (end > str.length()) {
            end = str.length();
        }
        if (start > end) {
            return EMPTY_STRING;
        }
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = 0;
        }
        return str.substring(start, end);
    }

    public static String left(String str, int len) {
        return str == null ? null : (len < 0 ? EMPTY_STRING : (str.length() <= len ? str : str.substring(0, len)));
    }

    public static String right(String str, int len) {
        return str == null ? null : (len < 0 ? EMPTY_STRING : (str.length() <= len ? str : str.substring(str.length() - len)));
    }

    public static String mid(String str, int pos, int len) {
        if (str == null) {
            return null;
        }
        if (len >= 0 && pos <= str.length()) {
            if (pos < 0) {
                pos = 0;
            }
            return str.length() <= pos + len ? str.substring(pos) : str.substring(pos, pos + len);
        }
        return EMPTY_STRING;
    }

    public static String substringBefore(String str, String separator) {
        if (str != null && separator != null && str.length() != 0) {
            if (separator.length() == 0) {
                return EMPTY_STRING;
            }
            int pos = str.indexOf(separator);
            return pos == -1 ? str : str.substring(0, pos);
        }
        return str;
    }

    public static String substringAfter(String str, String separator) {
        if (str != null && str.length() != 0) {
            if (separator == null) {
                return EMPTY_STRING;
            }
            int pos = str.indexOf(separator);
            return pos == -1 ? EMPTY_STRING : str.substring(pos + separator.length());
        }
        return str;
    }

    public static String substringBeforeLast(String str, String separator) {
        if (str != null && separator != null && str.length() != 0 && separator.length() != 0) {
            int pos = str.lastIndexOf(separator);
            return pos == -1 ? str : str.substring(0, pos);
        }
        return str;
    }

    public static String substringAfterLast(String str, String separator) {
        if (str != null && str.length() != 0) {
            if (separator != null && separator.length() != 0) {
                int pos = str.lastIndexOf(separator);
                return pos != -1 && pos != str.length() - separator.length() ? str.substring(pos + separator.length()) : EMPTY_STRING;
            }
            return EMPTY_STRING;
        }
        return str;
    }

    public static String substringBetween(String str, String tag) {
        return StringUtil.substringBetween(str, tag, tag, 0);
    }

    public static String substringBetween(String str, String open, String close) {
        return StringUtil.substringBetween(str, open, close, 0);
    }

    public static String substringBetween(String str, String open, String close, int fromIndex) {
        if (str != null && open != null && close != null) {
            int end;
            int start = str.indexOf(open, fromIndex);
            if (start != -1 && (end = str.indexOf(close, start + open.length())) != -1) {
                return str.substring(start + open.length(), end);
            }
            return null;
        }
        return null;
    }

    public static String deleteWhitespace(String str) {
        if (str == null) {
            return null;
        }
        int sz = str.length();
        StringBuffer buffer = new StringBuffer(sz);
        for (int i = 0; i < sz; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            buffer.append(str.charAt(i));
        }
        return buffer.toString();
    }

    public static String replaceOnce(String text, String repl, String with) {
        return StringUtil.replace(text, repl, with, 1);
    }

    public static String replace(String text, String repl, String with) {
        return StringUtil.replace(text, repl, with, -1);
    }

    public static String replace(String text, String repl, String with, int max) {
        if (text != null && repl != null && with != null && repl.length() != 0 && max != 0) {
            int end;
            StringBuffer buf = new StringBuffer(text.length());
            int start = 0;
            while ((end = text.indexOf(repl, start)) != -1) {
                buf.append(text.substring(start, end)).append(with);
                start = end + repl.length();
                if (--max != 0) continue;
            }
            buf.append(text.substring(start));
            return buf.toString();
        }
        return text;
    }

    public static String replaceChars(String str, char searchChar, char replaceChar) {
        return str == null ? null : str.replace(searchChar, replaceChar);
    }

    public static String replaceChars(String str, String searchChars, String replaceChars) {
        if (str == null || str.length() == 0 || searchChars == null || searchChars.length() == 0) {
            return str;
        }
        char[] chars = str.toCharArray();
        int len = chars.length;
        boolean modified = false;
        int isize = searchChars.length();
        for (int i = 0; i < isize; ++i) {
            char searchChar = searchChars.charAt(i);
            if (replaceChars == null || i >= replaceChars.length()) {
                int pos = 0;
                for (int j = 0; j < len; ++j) {
                    if (chars[j] != searchChar) {
                        chars[pos++] = chars[j];
                        continue;
                    }
                    modified = true;
                }
                len = pos;
                continue;
            }
            for (int j = 0; j < len; ++j) {
                if (chars[j] != searchChar) continue;
                chars[j] = replaceChars.charAt(i);
                modified = true;
            }
        }
        if (!modified) {
            return str;
        }
        return new String(chars, 0, len);
    }

    public static String overlay(String str, String overlay, int start, int end) {
        if (str == null) {
            return null;
        }
        if (overlay == null) {
            overlay = EMPTY_STRING;
        }
        int len = str.length();
        if (start < 0) {
            start = 0;
        }
        if (start > len) {
            start = len;
        }
        if (end < 0) {
            end = 0;
        }
        if (end > len) {
            end = len;
        }
        if (start > end) {
            int temp = start;
            start = end;
            end = temp;
        }
        return new StringBuffer(len + start - end + overlay.length() + 1).append(str.substring(0, start)).append(overlay).append(str.substring(end)).toString();
    }

    public static String chomp(String str) {
        if (str != null && str.length() != 0) {
            if (str.length() == 1) {
                char ch = str.charAt(0);
                return ch != '\r' && ch != '\n' ? str : EMPTY_STRING;
            }
            int lastIdx = str.length() - 1;
            char last = str.charAt(lastIdx);
            if (last == '\n') {
                if (str.charAt(lastIdx - 1) == '\r') {
                    --lastIdx;
                }
            } else if (last != '\r') {
                ++lastIdx;
            }
            return str.substring(0, lastIdx);
        }
        return str;
    }

    public static String chomp(String str, String separator) {
        return str != null && str.length() != 0 && separator != null ? (str.endsWith(separator) ? str.substring(0, str.length() - separator.length()) : str) : str;
    }

    public static String chop(String str) {
        if (str == null) {
            return null;
        }
        int strLen = str.length();
        if (strLen < 2) {
            return EMPTY_STRING;
        }
        int lastIdx = strLen - 1;
        String ret = str.substring(0, lastIdx);
        char last = str.charAt(lastIdx);
        return last == '\n' && ret.charAt(lastIdx - 1) == '\r' ? ret.substring(0, lastIdx - 1) : ret;
    }

    public static String repeat(String str, int repeat) {
        if (str == null) {
            return null;
        }
        if (repeat <= 0) {
            return EMPTY_STRING;
        }
        int inputLength = str.length();
        if (repeat != 1 && inputLength != 0) {
            int outputLength = inputLength * repeat;
            switch (inputLength) {
                case 1: {
                    char ch = str.charAt(0);
                    char[] output1 = new char[outputLength];
                    for (int i = repeat - 1; i >= 0; --i) {
                        output1[i] = ch;
                    }
                    return new String(output1);
                }
                case 2: {
                    char ch0 = str.charAt(0);
                    char ch1 = str.charAt(1);
                    char[] output2 = new char[outputLength];
                    for (int i = repeat * 2 - 2; i >= 0; --i) {
                        output2[i] = ch0;
                        output2[i + 1] = ch1;
                        --i;
                    }
                    return new String(output2);
                }
            }
            StringBuffer buf = new StringBuffer(outputLength);
            for (int i = 0; i < repeat; ++i) {
                buf.append(str);
            }
            return buf.toString();
        }
        return str;
    }

    public static String alignLeft(String str, int size) {
        return StringUtil.alignLeft(str, size, ' ');
    }

    public static String alignLeft(String str, int size, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        return pads <= 0 ? str : StringUtil.alignLeft(str, size, String.valueOf(padChar));
    }

    public static String alignLeft(String str, int size, String padStr) {
        if (str == null) {
            return null;
        }
        if (padStr == null || padStr.length() == 0) {
            padStr = " ";
        }
        int padLen = padStr.length();
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str;
        }
        if (pads == padLen) {
            return str.concat(padStr);
        }
        if (pads < padLen) {
            return str.concat(padStr.substring(0, pads));
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        for (int i = 0; i < pads; ++i) {
            padding[i] = padChars[i % padLen];
        }
        return str.concat(new String(padding));
    }

    public static String alignRight(String str, int size) {
        return StringUtil.alignRight(str, size, ' ');
    }

    public static String alignRight(String str, int size, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        return pads <= 0 ? str : StringUtil.alignRight(str, size, String.valueOf(padChar));
    }

    public static String alignRight(String str, int size, String padStr) {
        if (str == null) {
            return null;
        }
        if (padStr == null || padStr.length() == 0) {
            padStr = " ";
        }
        int padLen = padStr.length();
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str;
        }
        if (pads == padLen) {
            return padStr.concat(str);
        }
        if (pads < padLen) {
            return padStr.substring(0, pads).concat(str);
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        for (int i = 0; i < pads; ++i) {
            padding[i] = padChars[i % padLen];
        }
        return new String(padding).concat(str);
    }

    public static String center(String str, int size) {
        return StringUtil.center(str, size, ' ');
    }

    public static String center(String str, int size, char padChar) {
        if (str != null && size > 0) {
            int strLen = str.length();
            int pads = size - strLen;
            if (pads <= 0) {
                return str;
            }
            str = StringUtil.alignRight(str, strLen + pads / 2, padChar);
            str = StringUtil.alignLeft(str, size, padChar);
            return str;
        }
        return str;
    }

    public static String center(String str, int size, String padStr) {
        if (str != null && size > 0) {
            int strLen;
            int pads;
            if (padStr == null || padStr.length() == 0) {
                padStr = " ";
            }
            if ((pads = size - (strLen = str.length())) <= 0) {
                return str;
            }
            str = StringUtil.alignRight(str, strLen + pads / 2, padStr);
            str = StringUtil.alignLeft(str, size, padStr);
            return str;
        }
        return str;
    }

    public static String reverse(String str) {
        return str != null && str.length() != 0 ? new StringBuffer(str).reverse().toString() : str;
    }

    public static String reverseDelimited(String str, char separatorChar) {
        if (str == null) {
            return null;
        }
        Object[] strs = StringUtil.split(str, separatorChar);
        ArrayUtil.reverse(strs);
        return StringUtil.join(strs, separatorChar);
    }

    public static String reverseDelimited(String str, String separatorChars, String separator) {
        if (str == null) {
            return null;
        }
        Object[] strs = StringUtil.split(str, separatorChars);
        ArrayUtil.reverse(strs);
        return separator == null ? StringUtil.join(strs, ' ') : StringUtil.join(strs, separator);
    }

    public static String abbreviate(String str, int maxWidth) {
        return StringUtil.abbreviate(str, 0, maxWidth);
    }

    public static String abbreviate(String str, int offset, int maxWidth) {
        if (str == null) {
            return null;
        }
        if (maxWidth < 4) {
            maxWidth = 4;
        }
        if (str.length() <= maxWidth) {
            return str;
        }
        if (offset > str.length()) {
            offset = str.length();
        }
        if (str.length() - offset < maxWidth - 3) {
            offset = str.length() - (maxWidth - 3);
        }
        if (offset <= 4) {
            return str.substring(0, maxWidth - 3) + "...";
        }
        if (maxWidth < 7) {
            maxWidth = 7;
        }
        return offset + (maxWidth - 3) < str.length() ? "..." + StringUtil.abbreviate(str.substring(offset), maxWidth - 3) : "..." + str.substring(str.length() - (maxWidth - 3));
    }

    public static String difference(String str1, String str2) {
        if (str1 == null) {
            return str2;
        }
        if (str2 == null) {
            return str1;
        }
        int index = StringUtil.indexOfDifference(str1, str2);
        return index == -1 ? EMPTY_STRING : str2.substring(index);
    }

    public static int indexOfDifference(String str1, String str2) {
        if (str1 != str2 && str1 != null && str2 != null) {
            int i;
            for (i = 0; i < str1.length() && i < str2.length() && str1.charAt(i) == str2.charAt(i); ++i) {
            }
            return i >= str2.length() && i >= str1.length() ? -1 : i;
        }
        return -1;
    }

    public static int getLevenshteinDistance(String s, String t) {
        s = StringUtil.defaultIfNull(s);
        t = StringUtil.defaultIfNull(t);
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[][] d = new int[n + 1][m + 1];
        int i = 0;
        while (i <= n) {
            d[i][0] = i++;
        }
        int j = 0;
        while (j <= m) {
            d[0][j] = j++;
        }
        for (i = 1; i <= n; ++i) {
            char s_i = s.charAt(i - 1);
            for (j = 1; j <= m; ++j) {
                char t_j = t.charAt(j - 1);
                int cost = s_i == t_j ? 0 : 1;
                d[i][j] = StringUtil.min(d[i - 1][j] + 1, d[i][j - 1] + 1, d[i - 1][j - 1] + cost);
            }
        }
        return d[n][m];
    }

    private static int min(int a, int b, int c) {
        if (b < a) {
            a = b;
        }
        if (c < a) {
            a = c;
        }
        return a;
    }

    private static abstract class WordTokenizer {
        protected static final char UNDERSCORE = '_';

        private WordTokenizer() {
        }

        public String parse(String str) {
            if (StringUtil.isEmpty(str)) {
                return str;
            }
            int length = str.length();
            StringBuffer buffer = new StringBuffer(length);
            for (int index = 0; index < length; ++index) {
                int wordIndex;
                char ch = str.charAt(index);
                if (Character.isWhitespace(ch)) continue;
                if (!Character.isUpperCase(ch)) {
                    if (Character.isLowerCase(ch)) {
                        index = this.parseLowerCaseWord(buffer, str, index);
                        continue;
                    }
                    if (Character.isDigit(ch)) {
                        index = this.parseDigitWord(buffer, str, index);
                        continue;
                    }
                    this.inDelimiter(buffer, ch);
                    continue;
                }
                for (wordIndex = index + 1; wordIndex < length; ++wordIndex) {
                    char wordChar = str.charAt(wordIndex);
                    if (Character.isUpperCase(wordChar)) continue;
                    if (!Character.isLowerCase(wordChar)) break;
                    --wordIndex;
                    break;
                }
                index = wordIndex != length && wordIndex <= index ? this.parseTitleCaseWord(buffer, str, index) : this.parseUpperCaseWord(buffer, str, index, wordIndex);
            }
            return buffer.toString();
        }

        private int parseUpperCaseWord(StringBuffer buffer, String str, int index, int length) {
            char ch = str.charAt(index++);
            if (buffer.length() == 0) {
                this.startSentence(buffer, ch);
            } else {
                this.startWord(buffer, ch);
            }
            while (index < length) {
                ch = str.charAt(index);
                this.inWord(buffer, ch);
                ++index;
            }
            return index - 1;
        }

        private int parseLowerCaseWord(StringBuffer buffer, String str, int index) {
            char ch = str.charAt(index++);
            if (buffer.length() == 0) {
                this.startSentence(buffer, ch);
            } else {
                this.startWord(buffer, ch);
            }
            int length = str.length();
            while (index < length && Character.isLowerCase(ch = str.charAt(index))) {
                this.inWord(buffer, ch);
                ++index;
            }
            return index - 1;
        }

        private int parseTitleCaseWord(StringBuffer buffer, String str, int index) {
            char ch = str.charAt(index++);
            if (buffer.length() == 0) {
                this.startSentence(buffer, ch);
            } else {
                this.startWord(buffer, ch);
            }
            int length = str.length();
            while (index < length && Character.isLowerCase(ch = str.charAt(index))) {
                this.inWord(buffer, ch);
                ++index;
            }
            return index - 1;
        }

        private int parseDigitWord(StringBuffer buffer, String str, int index) {
            char ch = str.charAt(index++);
            if (buffer.length() == 0) {
                this.startDigitSentence(buffer, ch);
            } else {
                this.startDigitWord(buffer, ch);
            }
            int length = str.length();
            while (index < length && Character.isDigit(ch = str.charAt(index))) {
                this.inDigitWord(buffer, ch);
                ++index;
            }
            return index - 1;
        }

        protected boolean isDelimiter(char ch) {
            return !Character.isUpperCase(ch) && !Character.isLowerCase(ch) && !Character.isDigit(ch);
        }

        protected abstract void startSentence(StringBuffer var1, char var2);

        protected abstract void startWord(StringBuffer var1, char var2);

        protected abstract void inWord(StringBuffer var1, char var2);

        protected abstract void startDigitSentence(StringBuffer var1, char var2);

        protected abstract void startDigitWord(StringBuffer var1, char var2);

        protected abstract void inDigitWord(StringBuffer var1, char var2);

        protected abstract void inDelimiter(StringBuffer var1, char var2);
    }
}

