/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.log.env;

import com.alipay.sofa.common.log.CommonLoggingConfigurations;
import com.alipay.sofa.common.log.Constants;
import com.alipay.sofa.common.utils.AssertUtil;
import com.alipay.sofa.common.utils.ClassUtil;
import com.alipay.sofa.common.utils.ProcessIdUtil;
import com.alipay.sofa.common.utils.ReportUtil;
import com.alipay.sofa.common.utils.StringUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class LogEnvUtils {
    private static volatile Map<String, String> globalSystemProperties;

    private LogEnvUtils() {
    }

    public static boolean isLogbackUsable(ClassLoader spaceClassloader) {
        AssertUtil.notNull(spaceClassloader);
        try {
            return spaceClassloader.loadClass("ch.qos.logback.classic.LoggerContext") != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isLog4j2Usable(ClassLoader spaceClassloader) {
        AssertUtil.notNull(spaceClassloader);
        try {
            return spaceClassloader.loadClass("org.apache.logging.slf4j.Log4jLoggerFactory") != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isLog4jUsable(ClassLoader spaceClassloader) {
        AssertUtil.notNull(spaceClassloader);
        try {
            return spaceClassloader.loadClass("org.slf4j.impl.Log4jLoggerFactory") != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isCommonsLoggingUsable(ClassLoader spaceClassloader) {
        AssertUtil.notNull(spaceClassloader);
        try {
            return spaceClassloader.loadClass("org.slf4j.impl.JCLLoggerAdapter") != null && spaceClassloader.loadClass("org.apache.commons.logging.impl.Log4JLogger") != null && spaceClassloader.loadClass("org.apache.log4j.Logger") != null && spaceClassloader.loadClass("org.apache.commons.logging.Log") != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static Map<String, String> processGlobalSystemLogProperties() {
        if (globalSystemProperties != null) {
            return globalSystemProperties;
        }
        HashMap<String, String> properties = new HashMap<String, String>(CommonLoggingConfigurations.getExternalConfigurations());
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            String lowerCaseKey = entry.getKey().toLowerCase();
            if (!LogEnvUtils.isSofaCommonLoggingPrefix(lowerCaseKey)) continue;
            properties.put(lowerCaseKey, entry.getValue());
        }
        Properties systemProperties = System.getProperties();
        Set<String> sysKeys = systemProperties.stringPropertyNames();
        for (String key : sysKeys) {
            String lowerCaseKey;
            String value = systemProperties.getProperty(key);
            if (key == null || value == null || !LogEnvUtils.isSofaCommonLoggingPrefix(lowerCaseKey = key.toLowerCase())) continue;
            properties.put(lowerCaseKey, value);
        }
        properties.put("PID", ProcessIdUtil.getProcessId());
        if (System.getProperties().contains("file.encoding")) {
            properties.put("file.encoding", System.getProperty("file.encoding"));
        } else {
            properties.putIfAbsent("file.encoding", "UTF-8");
        }
        String loggingPath = System.getProperty("logging.path");
        String loggingRoot = System.getProperty("loggingRoot");
        if (!StringUtil.isBlank(loggingPath)) {
            loggingRoot = loggingPath;
        } else if (!StringUtil.isBlank(loggingRoot)) {
            loggingPath = loggingRoot;
        }
        if (StringUtil.isNotEmpty(loggingPath)) {
            properties.put("logging.path", loggingPath);
            properties.put("loggingRoot", loggingRoot);
        } else {
            properties.putIfAbsent("logging.path", Constants.LOGGING_PATH_DEFAULT);
            properties.putIfAbsent("loggingRoot", Constants.LOGGING_PATH_DEFAULT);
        }
        globalSystemProperties = properties;
        LogEnvUtils.keepCompatible(globalSystemProperties, !LogEnvUtils.isLogStarterExist());
        return globalSystemProperties;
    }

    public static String getLogConfEnvSuffix(String spaceName) {
        String logEnvConfig = System.getProperty("log.env.suffix", "");
        String[] spaceNameToEnvSuffix = logEnvConfig.split("&");
        String suffix = null;
        for (int i = 0; i < spaceNameToEnvSuffix.length && suffix == null; ++i) {
            String envConf = spaceNameToEnvSuffix[i];
            String[] conf = envConf.split(":");
            if (conf.length != 2 || !conf[0].equals(spaceName)) continue;
            if (!conf[1].isEmpty()) {
                conf[1] = "." + conf[1];
            }
            suffix = conf[1];
        }
        String string = suffix = suffix == null ? "" : suffix;
        if (!suffix.isEmpty()) {
            ReportUtil.reportDebug(spaceName + " log configuration: " + "log-conf.xml" + suffix);
        }
        return suffix;
    }

    public static void keepCompatible(Map<String, String> context, boolean keep) {
        if (!keep) {
            return;
        }
        String loggingPath = System.getProperty("logging.path", context.get("logging.path"));
        String fileEncoding = System.getProperty("file.encoding", context.get("file.encoding"));
        System.setProperty("logging.path", loggingPath);
        System.setProperty("loggingRoot", System.getProperty("loggingRoot", loggingPath));
        System.setProperty("file.encoding", fileEncoding);
    }

    public static boolean isLogStarterExist() {
        return ClassUtil.isPresent("com.alipay.sofa.common.boot.logging.Mark");
    }

    private static boolean isSofaCommonLoggingPrefix(String key) {
        return key.startsWith("sofa.middleware.log.") || key.startsWith("logging.level.") || key.startsWith("logging.path.") || key.startsWith("logging.config.");
    }

    public static boolean isSofaCommonLoggingConfig(String key) {
        return LogEnvUtils.isSofaCommonLoggingPrefix(key) || key.equals("logging.path") || key.equals("loggingRoot") || key.equals("file.encoding");
    }

    @Deprecated
    public static boolean filterAllLogConfig(String key) {
        return LogEnvUtils.isSofaCommonLoggingConfig(key);
    }
}

