/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.code;

import com.alipay.sofa.common.space.SpaceId;
import com.alipay.sofa.common.utils.ReportUtil;
import com.alipay.sofa.common.utils.StringUtil;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class LogCode2Description {
    private static final Map<SpaceId, LogCode2Description> LOG_CODE_2_DESCRIPTION_MAP = new ConcurrentHashMap<SpaceId, LogCode2Description>();
    private String logFormat;
    private Properties properties;

    public static String convert(String spaceName, String code) {
        return LogCode2Description.convert(SpaceId.withSpaceName(spaceName), code);
    }

    public static String convert(SpaceId spaceId, String code) {
        LogCode2Description logCode2Description = null;
        logCode2Description = LogCode2Description.isCodeSpaceInitialized(spaceId) ? LOG_CODE_2_DESCRIPTION_MAP.get(spaceId) : LogCode2Description.create(spaceId);
        return logCode2Description.convert(code);
    }

    public static LogCode2Description create(String spaceName) {
        return LogCode2Description.create(SpaceId.withSpaceName(spaceName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogCode2Description create(SpaceId spaceId) {
        if (LogCode2Description.isCodeSpaceInitialized(spaceId)) {
            ReportUtil.reportWarn("Code space: \"" + spaceId.getSpaceName() + "\" is already initialized!");
            return LOG_CODE_2_DESCRIPTION_MAP.get(spaceId);
        }
        SpaceId spaceId2 = spaceId;
        synchronized (spaceId2) {
            if (LogCode2Description.isCodeSpaceInitialized(spaceId)) {
                ReportUtil.reportWarn("Code space: \"" + spaceId.getSpaceName() + "\" is already initialized!");
                return LOG_CODE_2_DESCRIPTION_MAP.get(spaceId);
            }
            LogCode2Description logCode2Description = LogCode2Description.doCreate(spaceId);
            ReportUtil.reportInfo("Code Space: \"" + spaceId.getSpaceName() + "\" init ok");
            return logCode2Description;
        }
    }

    private static LogCode2Description doCreate(SpaceId spaceId) {
        LogCode2Description logCode2Description = new LogCode2Description(spaceId);
        LOG_CODE_2_DESCRIPTION_MAP.put(spaceId, logCode2Description);
        return logCode2Description;
    }

    private static boolean isCodeSpaceInitialized(SpaceId spaceId) {
        return LOG_CODE_2_DESCRIPTION_MAP.containsKey(spaceId);
    }

    public static void removeCodeSpace(String spaceName) {
        LogCode2Description.removeCodeSpace(SpaceId.withSpaceName(spaceName));
    }

    public static void removeCodeSpace(SpaceId spaceId) {
        if (spaceId == null || !LogCode2Description.isCodeSpaceInitialized(spaceId)) {
            return;
        }
        LOG_CODE_2_DESCRIPTION_MAP.remove(spaceId);
    }

    private LogCode2Description(SpaceId spaceId) {
        this.logFormat = spaceId.getSpaceName().toUpperCase() + "-%s: %s";
        String prefix = spaceId.getSpaceName().replace(".", "/") + "/log-codes";
        String encoding = Locale.getDefault().toString();
        if (StringUtil.isEmpty(encoding)) {
            encoding = Locale.ENGLISH.toString();
        }
        String fileName = prefix + "_" + encoding + ".properties";
        if (this.getClass().getClassLoader().getResource(fileName) == null) {
            fileName = prefix + ".properties";
        }
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream(fileName);){
            this.properties = new Properties();
            if (in == null) {
                ReportUtil.reportError(String.format("Code file for CodeSpace \"%s\" doesn't exist!", spaceId.getSpaceName()));
            } else {
                InputStreamReader reader = new InputStreamReader(in);
                this.properties.load(reader);
            }
        }
        catch (Throwable e) {
            ReportUtil.reportError(String.format("Code space \"%s\" initializing failed!", spaceId.getSpaceName()), e);
        }
    }

    public String convert(String code) {
        Object description = this.properties.get(code);
        if (description == null) {
            description = "Unknown Code";
        }
        return String.format(this.logFormat, code, description);
    }
}

