/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.log.factory;

import com.alipay.sofa.common.log.SpaceInfo;
import com.alipay.sofa.common.log.adapter.level.AdapterLevel;
import com.alipay.sofa.common.log.factory.AbstractLoggerSpaceFactory;
import com.alipay.sofa.common.log.factory.AbstractLoggerSpaceFactoryBuilder;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.slf4j.Log4jLogger;
import org.slf4j.Logger;

public class LoggerSpaceFactory4Log4j2Builder
extends AbstractLoggerSpaceFactoryBuilder {
    public LoggerSpaceFactory4Log4j2Builder(SpaceInfo spaceInfo) {
        super(spaceInfo);
    }

    @Override
    protected String getLoggingToolName() {
        return "log4j2";
    }

    @Override
    public AbstractLoggerSpaceFactory doBuild(String spaceName, ClassLoader spaceClassloader, URL url) {
        try {
            final LoggerContext context = new LoggerContext(spaceName, null, url.toURI());
            Configuration config = null;
            ConfigurationFactory configurationFactory = ConfigurationFactory.getInstance();
            try {
                Class[] parameterTypes = new Class[]{String.class, URI.class, ClassLoader.class};
                Method getConfigurationMethod = configurationFactory.getClass().getMethod("getConfiguration", parameterTypes);
                config = (Configuration)getConfigurationMethod.invoke((Object)configurationFactory, spaceName, url.toURI(), spaceClassloader);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Class[] parameterTypes = new Class[]{LoggerContext.class, String.class, URI.class, ClassLoader.class};
                Method getConfigurationMethod = configurationFactory.getClass().getMethod("getConfiguration", parameterTypes);
                config = (Configuration)getConfigurationMethod.invoke((Object)configurationFactory, context, spaceName, url.toURI(), spaceClassloader);
            }
            if (config == null) {
                throw new RuntimeException("No log4j2 configuration are found.");
            }
            for (Map.Entry<Object, Object> entry : this.getProperties().entrySet()) {
                config.getProperties().put((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
                config.getProperties().put((String)entry.getKey(), (String)entry.getValue());
            }
            context.start(config);
            return new AbstractLoggerSpaceFactory(this.getLoggingToolName()){
                private ConcurrentMap<String, Log4jLogger> loggerMap;
                {
                    super(x0);
                    this.loggerMap = new ConcurrentHashMap<String, Log4jLogger>();
                }

                @Override
                public Logger setLevel(String loggerName, AdapterLevel adapterLevel) throws Exception {
                    Log4jLogger log4jLoggerAdapter = (Log4jLogger)this.getLogger(loggerName);
                    String key = "ROOT".equals(loggerName) ? "" : loggerName;
                    org.apache.logging.log4j.core.Logger log4j2Logger = context.getLogger(key);
                    Level log4j2Level = this.toLog4j2Level(adapterLevel);
                    log4j2Logger.setLevel(log4j2Level);
                    return log4jLoggerAdapter;
                }

                public Logger getLogger(String name) {
                    String key = "ROOT".equals(name) ? "" : name;
                    org.apache.logging.log4j.core.Logger log4jLogger = context.getLogger(key);
                    Log4jLogger oldInst = (Log4jLogger)this.loggerMap.get(key);
                    if (oldInst != null) {
                        return oldInst;
                    }
                    Log4jLogger newInst = new Log4jLogger((ExtendedLogger)log4jLogger, key);
                    oldInst = this.loggerMap.putIfAbsent(key, newInst);
                    return oldInst == null ? newInst : oldInst;
                }

                private Level toLog4j2Level(AdapterLevel adapterLevel) {
                    if (adapterLevel == null) {
                        throw new IllegalStateException("AdapterLevel is NULL when adapter to log4j2.");
                    }
                    switch (adapterLevel) {
                        case TRACE: {
                            return Level.TRACE;
                        }
                        case DEBUG: {
                            return Level.DEBUG;
                        }
                        case INFO: {
                            return Level.INFO;
                        }
                        case WARN: {
                            return Level.WARN;
                        }
                        case ERROR: {
                            return Level.ERROR;
                        }
                    }
                    throw new IllegalStateException((Object)((Object)adapterLevel) + " is unknown when adapter to log4j2.");
                }
            };
        }
        catch (Throwable e) {
            throw new IllegalStateException("Log4j2 loggerSpaceFactory build error!", e);
        }
    }
}

