/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.service.schema.model.attribute;

import com.alipay.service.schema.exception.ServiceSchemaException;
import com.alipay.service.schema.model.attribute.Attribute;
import com.alipay.service.schema.model.enums.AttrTypeEnum;
import com.alipay.service.schema.model.enums.SchemaErrorEnum;
import com.alipay.service.schema.util.StringUtil;
import com.alipay.service.schema.util.XmlUtils;
import org.dom4j.Element;

public class SingleAttribute
extends Attribute {
    private String id;
    private String value;

    @Override
    public Element toElement() throws ServiceSchemaException {
        Element attributeNode = XmlUtils.createRootElement("attribute");
        if (StringUtil.isEmpty(this.id)) {
            throw new ServiceSchemaException(SchemaErrorEnum.ATTR_MISS_ID);
        }
        if (this.getType() == null || StringUtil.isEmpty(this.getType().getType())) {
            throw new ServiceSchemaException(SchemaErrorEnum.ATTR_MISS_TYPE, this.id);
        }
        AttrTypeEnum fieldEnum = AttrTypeEnum.getType(this.getType().getType());
        if (fieldEnum == null) {
            throw new ServiceSchemaException(SchemaErrorEnum.ATTR_TYPE_ERROR, this.id);
        }
        attributeNode.addAttribute("id", this.id);
        attributeNode.addAttribute("name", this.getName());
        attributeNode.addAttribute("type", this.getType().getType());
        attributeNode.addAttribute("valueType", this.getValueType().getCode());
        Element valueNode = XmlUtils.appendElement(attributeNode, "value");
        if (!StringUtil.isEmpty(this.value)) {
            valueNode.setText(this.value);
        }
        this.appendRulesElement(attributeNode, this.getRules(), this.getId());
        this.appendOptionsElement(attributeNode, this.getOptions(), this.getId());
        return attributeNode;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

