package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 场景营销内容
 *
 * @author auto create
 * @since 1.0, 2018-06-05 11:05:01
 */
public class SceneMarketingContent extends AlipayObject {

	private static final long serialVersionUID = 4732599994112444448L;

	/**
	 * 小图标地址
	 */
	@ApiField("icon")
	private String icon;

	/**
	 * 营销图片地址
	 */
	@ApiField("image")
	private String image;

	/**
	 * 营销内容意义
	 */
	@ApiField("meaning")
	private String meaning;

	/**
	 * 营销内容标签
	 */
	@ApiListField("tags")
	@ApiField("string")
	private List<String> tags;

	/**
	 * 限制及特性描述
	 */
	@ApiListField("tips")
	@ApiField("string")
	private List<String> tips;

	/**
	 * 营销内容标题
	 */
	@ApiField("title")
	private String title;

	/**
	 * 营销内容类型
	 */
	@ApiField("type")
	private String type;

	/**
	 * 营销内容跳转地址
	 */
	@ApiField("url")
	private String url;

	public String getIcon() {
		return this.icon;
	}
	public void setIcon(String icon) {
		this.icon = icon;
	}

	public String getImage() {
		return this.image;
	}
	public void setImage(String image) {
		this.image = image;
	}

	public String getMeaning() {
		return this.meaning;
	}
	public void setMeaning(String meaning) {
		this.meaning = meaning;
	}

	public List<String> getTags() {
		return this.tags;
	}
	public void setTags(List<String> tags) {
		this.tags = tags;
	}

	public List<String> getTips() {
		return this.tips;
	}
	public void setTips(List<String> tips) {
		this.tips = tips;
	}

	public String getTitle() {
		return this.title;
	}
	public void setTitle(String title) {
		this.title = title;
	}

	public String getType() {
		return this.type;
	}
	public void setType(String type) {
		this.type = type;
	}

	public String getUrl() {
		return this.url;
	}
	public void setUrl(String url) {
		this.url = url;
	}

}
