/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.hppc;

import org.teavm.hppc.BitMixer;
import org.teavm.hppc.FloatObjectHashMap;
import org.teavm.hppc.HashOrderMixing;

public class FloatObjectScatterMap<VType>
extends FloatObjectHashMap<VType> {
    public FloatObjectScatterMap() {
        this(4);
    }

    public FloatObjectScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public FloatObjectScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(float key) {
        return BitMixer.mixPhi(key);
    }

    public static <VType> FloatObjectScatterMap<VType> from(float[] keys, VType[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        FloatObjectScatterMap<VType> map = new FloatObjectScatterMap<VType>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

