/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.hppc;

import org.teavm.hppc.BitMixer;
import org.teavm.hppc.CharLongHashMap;
import org.teavm.hppc.HashOrderMixing;

public class CharLongScatterMap
extends CharLongHashMap {
    public CharLongScatterMap() {
        this(4);
    }

    public CharLongScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public CharLongScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(char key) {
        return BitMixer.mixPhi(key);
    }

    public static CharLongScatterMap from(char[] keys, long[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        CharLongScatterMap map = new CharLongScatterMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

