/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.hppc;

import org.teavm.hppc.BitMixer;
import org.teavm.hppc.CharCharHashMap;
import org.teavm.hppc.HashOrderMixing;

public class CharCharScatterMap
extends CharCharHashMap {
    public CharCharScatterMap() {
        this(4);
    }

    public CharCharScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public CharCharScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(char key) {
        return BitMixer.mixPhi(key);
    }

    public static CharCharScatterMap from(char[] keys, char[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        CharCharScatterMap map = new CharCharScatterMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

