/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjson.serializer;

import com.antgroup.antchain.myjava.interop.NoMetadata;
import com.antgroup.antchain.myjson.JSONException;
import com.antgroup.antchain.myjson.annotation.JSONField;
import com.antgroup.antchain.myjson.serializer.BeanContext;
import com.antgroup.antchain.myjson.serializer.JSONSerializer;
import com.antgroup.antchain.myjson.serializer.JavaBeanSerializer;
import com.antgroup.antchain.myjson.serializer.ObjectSerializer;
import com.antgroup.antchain.myjson.serializer.SerializeWriter;
import com.antgroup.antchain.myjson.serializer.SerializerFeature;
import com.antgroup.antchain.myjson.util.FieldInfo;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;

@NoMetadata
public class FieldSerializer
implements Comparable<FieldSerializer> {
    public final FieldInfo fieldInfo;
    protected final boolean writeNull;
    protected int features;
    private final String double_quoted_fieldPrefix;
    private String un_quoted_fieldPrefix;
    protected BeanContext fieldContext;
    protected boolean disableCircularReferenceDetect = false;
    protected boolean serializeUsing = false;
    protected boolean browserCompatible;
    private RuntimeSerializerInfo runtimeInfo;

    public FieldSerializer(Class<?> beanType, FieldInfo fieldInfo) {
        this.fieldInfo = fieldInfo;
        this.fieldContext = new BeanContext(beanType, fieldInfo);
        fieldInfo.setAccessible();
        this.double_quoted_fieldPrefix = '\"' + fieldInfo.name + "\":";
        boolean writeNull = false;
        JSONField annotation = fieldInfo.getAnnotation();
        if (annotation != null) {
            for (SerializerFeature feature : annotation.serialzeFeatures()) {
                if ((feature.getMask() & SerializerFeature.WRITE_MAP_NULL_FEATURES) == 0) continue;
                writeNull = true;
                break;
            }
            for (SerializerFeature feature : annotation.serialzeFeatures()) {
                if (feature == SerializerFeature.DisableCircularReferenceDetect) {
                    this.disableCircularReferenceDetect = true;
                    continue;
                }
                if (feature != SerializerFeature.BrowserCompatible) continue;
                this.browserCompatible = true;
            }
            this.features |= SerializerFeature.of(annotation.serialzeFeatures());
        }
        this.writeNull = writeNull;
    }

    public void writePrefix(JSONSerializer serializer) throws IOException {
        SerializeWriter out = serializer.out;
        if (out.quoteFieldNames) {
            out.write(this.double_quoted_fieldPrefix);
        } else {
            if (this.un_quoted_fieldPrefix == null) {
                this.un_quoted_fieldPrefix = this.fieldInfo.name + ":";
            }
            out.write(this.un_quoted_fieldPrefix);
        }
    }

    public Object getPropertyValueDirect(Object object) throws InvocationTargetException, IllegalAccessException {
        return this.fieldInfo.get(object);
    }

    public Object getPropertyValue(Object object) throws InvocationTargetException, IllegalAccessException {
        Object propertyValue = this.fieldInfo.get(object);
        return propertyValue;
    }

    @Override
    public int compareTo(FieldSerializer o) {
        return this.fieldInfo.compareTo(o.fieldInfo);
    }

    public void writeValue(JSONSerializer serializer, Object propertyValue) throws Exception {
        long value;
        if (this.runtimeInfo == null) {
            Class<Object> runtimeFieldClass;
            if (propertyValue == null) {
                runtimeFieldClass = this.fieldInfo.fieldClass;
                if (runtimeFieldClass == Byte.TYPE) {
                    runtimeFieldClass = Byte.class;
                } else if (runtimeFieldClass == Short.TYPE) {
                    runtimeFieldClass = Short.class;
                } else if (runtimeFieldClass == Integer.TYPE) {
                    runtimeFieldClass = Integer.class;
                } else if (runtimeFieldClass == Long.TYPE) {
                    runtimeFieldClass = Long.class;
                } else if (runtimeFieldClass == Float.TYPE) {
                    runtimeFieldClass = Float.class;
                } else if (runtimeFieldClass == Double.TYPE) {
                    runtimeFieldClass = Double.class;
                } else if (runtimeFieldClass == Boolean.TYPE) {
                    runtimeFieldClass = Boolean.class;
                }
            } else {
                runtimeFieldClass = propertyValue.getClass();
            }
            if (runtimeFieldClass != null && runtimeFieldClass.isEnum()) {
                throw new JSONException("field " + this.fieldInfo.name + " enum type not supported in myjson");
            }
            ObjectSerializer fieldSerializer = null;
            if (fieldSerializer == null) {
                fieldSerializer = serializer.getObjectWriter(runtimeFieldClass);
            }
            this.runtimeInfo = new RuntimeSerializerInfo(fieldSerializer, runtimeFieldClass);
        }
        RuntimeSerializerInfo runtimeInfo = this.runtimeInfo;
        int fieldFeatures = (this.disableCircularReferenceDetect ? this.fieldInfo.serialzeFeatures | SerializerFeature.DisableCircularReferenceDetect.mask : this.fieldInfo.serialzeFeatures) | this.features;
        if (propertyValue == null) {
            SerializeWriter out = serializer.out;
            if (this.fieldInfo.fieldClass == Object.class && out.isEnabled(SerializerFeature.WRITE_MAP_NULL_FEATURES)) {
                out.writeNull();
                return;
            }
            Class<?> runtimeFieldClass = runtimeInfo.runtimeFieldClass;
            if (Number.class.isAssignableFrom(runtimeFieldClass)) {
                out.writeNull(this.features, SerializerFeature.WriteNullNumberAsZero.mask);
                return;
            }
            if (String.class == runtimeFieldClass) {
                out.writeNull(this.features, SerializerFeature.WriteNullStringAsEmpty.mask);
                return;
            }
            if (Boolean.class == runtimeFieldClass) {
                out.writeNull(this.features, SerializerFeature.WriteNullBooleanAsFalse.mask);
                return;
            }
            if (Collection.class.isAssignableFrom(runtimeFieldClass) || runtimeFieldClass.isArray()) {
                out.writeNull(this.features, SerializerFeature.WriteNullListAsEmpty.mask);
                return;
            }
            ObjectSerializer fieldSerializer = runtimeInfo.fieldSerializer;
            if (out.isEnabled(SerializerFeature.WRITE_MAP_NULL_FEATURES) && fieldSerializer instanceof JavaBeanSerializer) {
                out.writeNull();
                return;
            }
            fieldSerializer.write(serializer, null, this.fieldInfo.name, this.fieldInfo.fieldType, fieldFeatures);
            return;
        }
        Class<?> valueClass = propertyValue.getClass();
        ObjectSerializer valueSerializer = valueClass == runtimeInfo.runtimeFieldClass || this.serializeUsing ? runtimeInfo.fieldSerializer : serializer.getObjectWriter(valueClass);
        if (!(!this.browserCompatible || this.fieldInfo.fieldClass != Long.TYPE && this.fieldInfo.fieldClass != Long.class || (value = ((Long)propertyValue).longValue()) <= 0x1FFFFFFFFFFFFFL && value >= -9007199254740991L)) {
            serializer.getWriter().writeString(Long.toString(value));
            return;
        }
        valueSerializer.write(serializer, propertyValue, this.fieldInfo.name, this.fieldInfo.fieldType, fieldFeatures);
    }

    @NoMetadata
    static class RuntimeSerializerInfo {
        final ObjectSerializer fieldSerializer;
        final Class<?> runtimeFieldClass;

        public RuntimeSerializerInfo(ObjectSerializer fieldSerializer, Class<?> runtimeFieldClass) {
            this.fieldSerializer = fieldSerializer;
            this.runtimeFieldClass = runtimeFieldClass;
        }
    }
}

