/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.wasc;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.jpountz.lz4.LZ4FrameOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teavm.apachecommons.io.FileUtils;

public class WascTool {
    private static final Logger log = LoggerFactory.getLogger(WascTool.class);
    public static final int WASC_MAGIC_NUMBER_HEX = 1668505975;
    public static final int DEFAULT_WASM_SECTION_CODE = 1;

    private static byte[] littleEndianInt(int value) {
        byte[] result = new byte[4];
        result[3] = (byte)(value >> 24 & 0xFF);
        result[2] = (byte)(value >> 16 & 0xFF);
        result[1] = (byte)(value >> 8 & 0xFF);
        result[0] = (byte)(value & 0xFF);
        return result;
    }

    private static void writeSectionHeader(OutputStream outputStream, int sectionCode, int offset, int length) throws IOException {
        outputStream.write(WascTool.littleEndianInt(sectionCode));
        outputStream.write(WascTool.littleEndianInt(offset));
        outputStream.write(WascTool.littleEndianInt(length));
    }

    public static void generateWascFile(OutputStream outputStream, int contractVersion, int wasmSectionCode, byte[] wasmData, byte[] abiData, byte[] namesSectionData) throws IOException {
        outputStream.write(WascTool.littleEndianInt(1668505975));
        outputStream.write(WascTool.littleEndianInt(contractVersion));
        ArrayList<WascSection> sections = new ArrayList<WascSection>();
        sections.add(new WascSection(wasmSectionCode, wasmData, 0));
        sections.add(new WascSection(2, abiData, 0));
        if (namesSectionData != null) {
            sections.add(new WascSection(6, namesSectionData, 0));
        }
        int sectionCount = sections.size();
        outputStream.write(WascTool.littleEndianInt(sectionCount));
        int eachHeaderSize = 12;
        int curBodyOffset = 12 + sectionCount * eachHeaderSize;
        for (int i = 0; i < sectionCount; ++i) {
            ((WascSection)sections.get((int)i)).offset = curBodyOffset;
            curBodyOffset += ((WascSection)sections.get((int)i)).body.length;
        }
        for (WascSection section : sections) {
            WascTool.writeSectionHeader(outputStream, section.sectionCode, section.offset, section.body.length);
        }
        for (WascSection section : sections) {
            outputStream.write(section.body);
        }
    }

    private static int getLz4SectionCode(int wasmSectionCode) {
        if (wasmSectionCode == 1) {
            return 4;
        }
        if (wasmSectionCode == 8) {
            return 9;
        }
        throw new RuntimeException("not supporte lz4 wasc section of section code " + wasmSectionCode);
    }

    public static void generateWascFile(int contractVersion, int wasmSectionCode, boolean compressWasm, String wascOutputFilePath, String wasmFilePath, String abiFilePath, boolean dumpNames, List<String> funcNames) throws IOException {
        byte[] wasmData = FileUtils.readFileToByteArray(new File(wasmFilePath));
        byte[] abiData = FileUtils.readFileToByteArray(new File(abiFilePath));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        if (compressWasm) {
            wasmSectionCode = WascTool.getLz4SectionCode(wasmSectionCode);
            log.info("start use lz4 to compress wasm section, wasm section code {}", (Object)wasmSectionCode);
            int originalWasmBytesLength = wasmData.length;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            LZ4FrameOutputStream lz4FrameOutputStream = new LZ4FrameOutputStream(out);
            lz4FrameOutputStream.write(wasmData);
            lz4FrameOutputStream.close();
            wasmData = out.toByteArray();
            int compressedLength = wasmData.length;
            log.info("lz4 compressed wasm section from {} bytes to {} bytes", (Object)originalWasmBytesLength, (Object)compressedLength);
        }
        byte[] namesSectionData = null;
        if (dumpNames) {
            namesSectionData = String.join((CharSequence)"\n", funcNames).getBytes(StandardCharsets.UTF_8);
        }
        WascTool.generateWascFile(bos, contractVersion, wasmSectionCode, wasmData, abiData, namesSectionData);
        FileUtils.writeByteArrayToFile(new File(wascOutputFilePath), bos.toByteArray());
    }

    private static class WascSection {
        public int sectionCode;
        public byte[] body;
        public int offset;

        public WascSection(int sectionCode, byte[] body, int offset) {
            this.sectionCode = sectionCode;
            this.body = body;
            this.offset = offset;
        }
    }

    public static final class WascSectionCodes {
        public static final int WASM_SECTION = 1;
        public static final int ABI_SECTION = 2;
        public static final int COMPRESSED_WASM_SECTION = 4;
        public static final int NAMES_SECTION = 6;
        public static final int WASM_JIT_SECTION = 8;
        public static final int COMPRESSED_WASM_JIT_SECTION = 9;
    }
}

