/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.vm;

import com.antgroup.antchain.myjava.dependency.ClassSourcePacker;
import com.antgroup.antchain.myjava.dependency.DependencyAnalyzerFactory;
import com.antgroup.antchain.myjava.dependency.PreciseDependencyAnalyzer;
import com.antgroup.antchain.myjava.interop.PlatformMarker;
import com.antgroup.antchain.myjava.model.ClassReaderSource;
import com.antgroup.antchain.myjava.model.ReferenceCache;
import com.antgroup.antchain.myjava.parsing.ClasspathClassHolderSource;
import com.antgroup.antchain.myjava.vm.MyJavaTarget;
import com.antgroup.antchain.myjava.vm.MyJavaVM;

public class MyJavaVMBuilder {
    MyJavaTarget target;
    ClassReaderSource classSource;
    ClassLoader classLoader;
    ReferenceCache referenceCache = new ReferenceCache();
    DependencyAnalyzerFactory dependencyAnalyzerFactory = PreciseDependencyAnalyzer::new;
    ClassSourcePacker classSourcePacker = (src, names) -> src;
    boolean obfuscated;
    boolean strict;

    public MyJavaVMBuilder(MyJavaTarget target) {
        this.target = target;
        this.classLoader = MyJavaVMBuilder.class.getClassLoader();
        this.classSource = !MyJavaVMBuilder.isBootstrap() ? new ClasspathClassHolderSource(this.classLoader, this.referenceCache) : name -> null;
    }

    public ClassReaderSource getClassSource() {
        return this.classSource;
    }

    public MyJavaVMBuilder setClassSource(ClassReaderSource classSource) {
        this.classSource = classSource;
        return this;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public MyJavaVMBuilder setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public DependencyAnalyzerFactory getDependencyAnalyzerFactory() {
        return this.dependencyAnalyzerFactory;
    }

    public MyJavaVMBuilder setDependencyAnalyzerFactory(DependencyAnalyzerFactory dependencyAnalyzerFactory) {
        this.dependencyAnalyzerFactory = dependencyAnalyzerFactory;
        return this;
    }

    public MyJavaVMBuilder setReferenceCache(ReferenceCache referenceCache) {
        this.referenceCache = referenceCache;
        return this;
    }

    public MyJavaVMBuilder setClassSourcePacker(ClassSourcePacker classSourcePacker) {
        this.classSourcePacker = classSourcePacker;
        return this;
    }

    public MyJavaVMBuilder setObfuscated(boolean obfuscated) {
        this.obfuscated = obfuscated;
        return this;
    }

    public MyJavaVMBuilder setStrict(boolean strict) {
        this.strict = strict;
        return this;
    }

    public MyJavaVM build() {
        return new MyJavaVM(this);
    }

    @PlatformMarker
    private static boolean isBootstrap() {
        return false;
    }
}

