/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.vm;

import com.alibaba.fastjson.parser.ParserConfig;
import com.antgroup.antchain.myjava.backend.wasm.generate.WasmDependencyListener;
import com.antgroup.antchain.myjava.cache.AlwaysStaleCacheStatus;
import com.antgroup.antchain.myjava.cache.AnnotationAwareCacheStatus;
import com.antgroup.antchain.myjava.cache.CacheStatus;
import com.antgroup.antchain.myjava.cache.EmptyProgramCache;
import com.antgroup.antchain.myjava.cache.ProgramDependencyExtractor;
import com.antgroup.antchain.myjava.common.ServiceRepository;
import com.antgroup.antchain.myjava.dependency.BootstrapMethodSubstitutor;
import com.antgroup.antchain.myjava.dependency.ClassSourcePacker;
import com.antgroup.antchain.myjava.dependency.DependencyAnalyzer;
import com.antgroup.antchain.myjava.dependency.DependencyInfo;
import com.antgroup.antchain.myjava.dependency.DependencyListener;
import com.antgroup.antchain.myjava.dependency.DependencyPlugin;
import com.antgroup.antchain.myjava.dependency.Linker;
import com.antgroup.antchain.myjava.dependency.MethodDependency;
import com.antgroup.antchain.myjava.diagnostics.AccumulationDiagnostics;
import com.antgroup.antchain.myjava.diagnostics.Diagnostics;
import com.antgroup.antchain.myjava.diagnostics.ProblemProvider;
import com.antgroup.antchain.myjava.model.BasicBlock;
import com.antgroup.antchain.myjava.model.ClassHierarchy;
import com.antgroup.antchain.myjava.model.ClassHolder;
import com.antgroup.antchain.myjava.model.ClassHolderSource;
import com.antgroup.antchain.myjava.model.ClassHolderTransformer;
import com.antgroup.antchain.myjava.model.ClassReader;
import com.antgroup.antchain.myjava.model.ClassReaderSource;
import com.antgroup.antchain.myjava.model.ElementModifier;
import com.antgroup.antchain.myjava.model.FieldHolder;
import com.antgroup.antchain.myjava.model.FieldReference;
import com.antgroup.antchain.myjava.model.Instruction;
import com.antgroup.antchain.myjava.model.ListableClassHolderSource;
import com.antgroup.antchain.myjava.model.ListableClassReaderSource;
import com.antgroup.antchain.myjava.model.MethodDescriptor;
import com.antgroup.antchain.myjava.model.MethodHolder;
import com.antgroup.antchain.myjava.model.MethodReader;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.MutableClassHolderSource;
import com.antgroup.antchain.myjava.model.Program;
import com.antgroup.antchain.myjava.model.ProgramCache;
import com.antgroup.antchain.myjava.model.ValueType;
import com.antgroup.antchain.myjava.model.analysis.ClassInitializerAnalysis;
import com.antgroup.antchain.myjava.model.analysis.ClassInitializerInfo;
import com.antgroup.antchain.myjava.model.instructions.InitClassInstruction;
import com.antgroup.antchain.myjava.model.instructions.InvokeInstruction;
import com.antgroup.antchain.myjava.model.optimization.ArrayUnwrapMotion;
import com.antgroup.antchain.myjava.model.optimization.ClassInitElimination;
import com.antgroup.antchain.myjava.model.optimization.ConstantConditionElimination;
import com.antgroup.antchain.myjava.model.optimization.DefaultInliningStrategy;
import com.antgroup.antchain.myjava.model.optimization.Devirtualization;
import com.antgroup.antchain.myjava.model.optimization.GlobalValueNumbering;
import com.antgroup.antchain.myjava.model.optimization.Inlining;
import com.antgroup.antchain.myjava.model.optimization.LoopInvariantMotion;
import com.antgroup.antchain.myjava.model.optimization.MethodOptimization;
import com.antgroup.antchain.myjava.model.optimization.MethodOptimizationContext;
import com.antgroup.antchain.myjava.model.optimization.RedundantJumpElimination;
import com.antgroup.antchain.myjava.model.optimization.RedundantNullCheckElimination;
import com.antgroup.antchain.myjava.model.optimization.RepeatedFieldReadElimination;
import com.antgroup.antchain.myjava.model.optimization.ScalarReplacement;
import com.antgroup.antchain.myjava.model.optimization.UnreachableBasicBlockElimination;
import com.antgroup.antchain.myjava.model.optimization.UnusedVariableElimination;
import com.antgroup.antchain.myjava.model.text.ListingBuilder;
import com.antgroup.antchain.myjava.model.transformation.ClassInitializerInsertionTransformer;
import com.antgroup.antchain.myjava.model.util.MissingItemsProcessor;
import com.antgroup.antchain.myjava.model.util.ModelUtils;
import com.antgroup.antchain.myjava.model.util.ProgramUtils;
import com.antgroup.antchain.myjava.model.util.RegisterAllocator;
import com.antgroup.antchain.myjava.vm.BuildTarget;
import com.antgroup.antchain.myjava.vm.DirectoryBuildTarget;
import com.antgroup.antchain.myjava.vm.MyJavaEntryPoint;
import com.antgroup.antchain.myjava.vm.MyJavaOptimizationLevel;
import com.antgroup.antchain.myjava.vm.MyJavaPhase;
import com.antgroup.antchain.myjava.vm.MyJavaPluginLoader;
import com.antgroup.antchain.myjava.vm.MyJavaProgressFeedback;
import com.antgroup.antchain.myjava.vm.MyJavaProgressListener;
import com.antgroup.antchain.myjava.vm.MyJavaTarget;
import com.antgroup.antchain.myjava.vm.MyJavaTargetController;
import com.antgroup.antchain.myjava.vm.MyJavaVMBuilder;
import com.antgroup.antchain.myjava.vm.spi.MyJavaHost;
import com.antgroup.antchain.myjava.vm.spi.MyJavaHostExtension;
import com.antgroup.antchain.myjava.vm.spi.MyJavaPlugin;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyJavaVM
implements MyJavaHost,
ServiceRepository {
    private static final Logger log = LoggerFactory.getLogger(MyJavaVM.class);
    private static final MethodDescriptor MAIN_METHOD_DESC = new MethodDescriptor("main", ValueType.arrayOf(ValueType.object("java.lang.String")), ValueType.VOID);
    private final DependencyAnalyzer dependencyAnalyzer;
    private final AccumulationDiagnostics diagnostics = new AccumulationDiagnostics();
    private final ClassLoader classLoader;
    private final Map<String, MyJavaEntryPoint> entryPoints = new LinkedHashMap<String, MyJavaEntryPoint>();
    private final Map<String, MyJavaEntryPoint> readonlyEntryPoints = Collections.unmodifiableMap(this.entryPoints);
    private final Set<String> preservedClasses = new HashSet<String>();
    private final Set<String> readonlyPreservedClasses = Collections.unmodifiableSet(this.preservedClasses);
    private final Map<Class<?>, Object> services = new HashMap();
    private final Properties properties = new Properties();
    private ProgramCache programCache = EmptyProgramCache.INSTANCE;
    private CacheStatus rawCacheStatus = AlwaysStaleCacheStatus.INSTANCE;
    private MyJavaOptimizationLevel optimizationLevel = MyJavaOptimizationLevel.SIMPLE;
    private MyJavaProgressListener progressListener;
    private boolean cancelled;
    private ListableClassHolderSource writtenClasses;
    private MyJavaTarget target;
    private Map<Class<?>, MyJavaHostExtension> extensions = new HashMap();
    private Set<? extends MethodReference> virtualMethods;
    private AnnotationAwareCacheStatus cacheStatus;
    private ProgramDependencyExtractor programDependencyExtractor = new ProgramDependencyExtractor();
    private List<Predicate<MethodReference>> additionalVirtualMethods = new ArrayList<Predicate<MethodReference>>();
    private int lastKnownClasses;
    private int compileProgressReportStart;
    private int compileProgressReportLimit;
    private int compileProgressLimit;
    private int compileProgressValue;
    private ClassSourcePacker classSourcePacker;
    private ClassInitializerInfo classInitializerInfo;
    private MyJavaTargetController targetController = new MyJavaTargetController(){

        @Override
        public boolean wasCancelled() {
            return MyJavaVM.this.wasCancelled();
        }

        @Override
        public ClassLoader getClassLoader() {
            return MyJavaVM.this.classLoader;
        }

        @Override
        public ClassReaderSource getUnprocessedClassSource() {
            return MyJavaVM.this.dependencyAnalyzer.getClassSource();
        }

        @Override
        public CacheStatus getCacheStatus() {
            return MyJavaVM.this.cacheStatus;
        }

        @Override
        public DependencyInfo getDependencyInfo() {
            return MyJavaVM.this.dependencyAnalyzer;
        }

        @Override
        public Diagnostics getDiagnostics() {
            return MyJavaVM.this.diagnostics;
        }

        @Override
        public Properties getProperties() {
            return MyJavaVM.this.properties;
        }

        @Override
        public ServiceRepository getServices() {
            return MyJavaVM.this;
        }

        public Map<String, MyJavaEntryPoint> getEntryPoints() {
            return MyJavaVM.this.readonlyEntryPoints;
        }

        public Set<String> getPreservedClasses() {
            return MyJavaVM.this.readonlyPreservedClasses;
        }

        @Override
        public boolean isFriendlyToDebugger() {
            return MyJavaVM.this.optimizationLevel == MyJavaOptimizationLevel.SIMPLE || MyJavaVM.this.optimizationLevel == MyJavaOptimizationLevel.SIMPLE_OPTIMIZED;
        }

        @Override
        public boolean isVirtual(MethodReference method) {
            return MyJavaVM.this.isVirtual(method);
        }

        @Override
        public MyJavaProgressFeedback reportProgress(int progress) {
            progress = progress * (MyJavaVM.this.compileProgressReportLimit - MyJavaVM.this.compileProgressReportStart) / 1000 + MyJavaVM.this.compileProgressReportStart;
            return MyJavaVM.this.progressListener.progressReached(progress);
        }

        @Override
        public void addVirtualMethods(Predicate<MethodReference> methods) {
            MyJavaVM.this.addVirtualMethods(methods);
        }

        @Override
        public ClassInitializerInfo getClassInitializerInfo() {
            return MyJavaVM.this.classInitializerInfo;
        }

        @Override
        public MyJavaOptimizationLevel getOptimizationLevel() {
            return MyJavaVM.this.optimizationLevel;
        }
    };

    MyJavaVM(MyJavaVMBuilder builder) {
        this.target = builder.target;
        this.classLoader = builder.classLoader;
        this.classSourcePacker = builder.classSourcePacker;
        this.dependencyAnalyzer = builder.dependencyAnalyzerFactory.create(builder.classSource, this.classLoader, this, this.diagnostics, builder.referenceCache);
        this.dependencyAnalyzer.setObfuscated(builder.obfuscated);
        this.dependencyAnalyzer.setStrict(builder.strict);
        this.progressListener = new MyJavaProgressListener(){

            @Override
            public MyJavaProgressFeedback progressReached(int progress) {
                return MyJavaProgressFeedback.CONTINUE;
            }

            @Override
            public MyJavaProgressFeedback phaseStarted(MyJavaPhase phase, int count) {
                return MyJavaProgressFeedback.CONTINUE;
            }
        };
        for (ClassHolderTransformer transformer : this.target.getTransformers()) {
            this.dependencyAnalyzer.addClassTransformer(transformer);
        }
        for (DependencyListener listener : this.target.getDependencyListeners()) {
            this.dependencyAnalyzer.addDependencyListener(listener);
        }
        for (MyJavaHostExtension extension : this.target.getHostExtensions()) {
            for (Class<? extends MyJavaHostExtension> extensionType : this.getExtensionTypes(extension)) {
                this.extensions.put(extensionType, extension);
            }
        }
        ParserConfig.getGlobalInstance().setSafeMode(true);
    }

    public void addVirtualMethods(Predicate<MethodReference> virtualMethods) {
        this.additionalVirtualMethods.add(virtualMethods);
    }

    @Override
    public void add(DependencyListener listener) {
        this.dependencyAnalyzer.addDependencyListener(listener);
    }

    @Override
    public void add(ClassHolderTransformer transformer) {
        this.dependencyAnalyzer.addClassTransformer(transformer);
    }

    @Override
    public void add(MethodReference methodRef, BootstrapMethodSubstitutor substitutor) {
        this.dependencyAnalyzer.addBootstrapMethodSubstitutor(methodRef, substitutor);
    }

    @Override
    public void add(MethodReference methodRef, DependencyPlugin dependencyPlugin) {
        this.dependencyAnalyzer.addDependencyPlugin(methodRef, dependencyPlugin);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setProperties(Properties properties) {
        this.properties.clear();
        if (properties != null) {
            this.properties.putAll((Map<?, ?>)properties);
        }
    }

    @Override
    public Properties getProperties() {
        return new Properties(this.properties);
    }

    public ProgramCache getProgramCache() {
        return this.programCache;
    }

    public void setProgramCache(ProgramCache programCache) {
        this.programCache = programCache;
    }

    public void setCacheStatus(CacheStatus cacheStatus) {
        this.rawCacheStatus = cacheStatus;
    }

    public MyJavaOptimizationLevel getOptimizationLevel() {
        return this.optimizationLevel;
    }

    public void setOptimizationLevel(MyJavaOptimizationLevel optimizationLevel) {
        this.optimizationLevel = optimizationLevel;
    }

    public MyJavaProgressListener getProgressListener() {
        return this.progressListener;
    }

    public void setProgressListener(MyJavaProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public boolean wasCancelled() {
        return this.cancelled;
    }

    public ProblemProvider getProblemProvider() {
        return this.diagnostics;
    }

    @Override
    public String[] getPlatformTags() {
        return this.target.getPlatformTags();
    }

    public void entryPoint(String className, String name) {
        if (this.entryPoints.containsKey(name)) {
            throw new IllegalArgumentException("Entry point with public name `" + name + "' already defined for class " + className);
        }
        ClassReader cls = this.dependencyAnalyzer.getClassSource().get(className);
        if (cls == null) {
            this.diagnostics.error(null, "There's no main class: '{{c0}}'", className);
            return;
        }
        if (cls.getMethod(MAIN_METHOD_DESC) == null) {
            this.diagnostics.error(null, "Specified main class '{{c0}}' does not have method '" + MAIN_METHOD_DESC + "'", cls.getName());
            return;
        }
        MethodDependency mainMethod = this.dependencyAnalyzer.linkMethod(new MethodReference(className, "main", ValueType.parse(String[].class), ValueType.VOID));
        MyJavaEntryPoint entryPoint = new MyJavaEntryPoint(name, mainMethod);
        this.dependencyAnalyzer.defer(() -> {
            this.dependencyAnalyzer.linkClass(className).initClass(null);
            mainMethod.getVariable(1).propagate(this.dependencyAnalyzer.getType("[Ljava/lang/String;"));
            mainMethod.getVariable(1).getArrayItem().propagate(this.dependencyAnalyzer.getType("java.lang.String"));
            mainMethod.use();
        });
        this.entryPoints.put(name, entryPoint);
    }

    public void entryPoint(String className) {
        this.entryPoint(className, "main");
    }

    public void preserveType(String className) {
        this.dependencyAnalyzer.defer(() -> this.dependencyAnalyzer.linkClass(className).initClass(null));
        this.preservedClasses.add(className);
    }

    public ClassReaderSource getDependencyClassSource() {
        return this.dependencyAnalyzer.getClassSource();
    }

    public Collection<String> getClasses() {
        return this.dependencyAnalyzer.getReachableClasses();
    }

    public Collection<MethodReference> getMethods() {
        return this.dependencyAnalyzer.getReachableMethods();
    }

    public DependencyInfo getDependencyInfo() {
        return this.dependencyAnalyzer;
    }

    public ListableClassReaderSource getWrittenClasses() {
        return this.writtenClasses;
    }

    public void setLastKnownClasses(int lastKnownClasses) {
        this.lastKnownClasses = lastKnownClasses;
    }

    public void build(BuildTarget buildTarget, String outputName) {
        ListableClassHolderSource classSet;
        boolean isLazy;
        this.reportPhase(MyJavaPhase.DEPENDENCY_ANALYSIS, this.lastKnownClasses > 0 ? this.lastKnownClasses : 1);
        if (this.wasCancelled()) {
            return;
        }
        this.dependencyAnalyzer.setAsyncSupported(this.target.isAsyncSupported());
        this.dependencyAnalyzer.setInterruptor(() -> {
            int progress = this.lastKnownClasses > 0 ? this.dependencyAnalyzer.getReachableClasses().size() : 0;
            this.cancelled |= this.progressListener.progressReached(progress) != MyJavaProgressFeedback.CONTINUE;
            return !this.cancelled;
        });
        this.target.contributeDependencies(this.dependencyAnalyzer);
        this.dependencyAnalyzer.processDependencies();
        HashSet<MethodReader> linkClassStatic = new HashSet();
        List<DependencyListener> listeners = this.dependencyAnalyzer.getListeners();
        for (DependencyListener listener : listeners) {
            if (!Objects.equals(listener.getClass().getName(), WasmDependencyListener.class.getName())) continue;
            WasmDependencyListener tmpListener = (WasmDependencyListener)listener;
            linkClassStatic = tmpListener.linkClassStatic;
        }
        if (this.wasCancelled() || !this.diagnostics.getSevereProblems().isEmpty()) {
            return;
        }
        this.dependencyAnalyzer.setInterruptor(null);
        this.dependencyAnalyzer.cleanup(this.classSourcePacker);
        this.cacheStatus = new AnnotationAwareCacheStatus(this.rawCacheStatus, this.dependencyAnalyzer.getIncrementalDependencies(), this.dependencyAnalyzer.getClassSource());
        this.cacheStatus.addSynthesizedClasses(this.dependencyAnalyzer::isSynthesizedClass);
        if (this.wasCancelled()) {
            return;
        }
        boolean bl = isLazy = this.optimizationLevel == MyJavaOptimizationLevel.SIMPLE || this.optimizationLevel == MyJavaOptimizationLevel.SIMPLE_OPTIMIZED;
        if (isLazy) {
            this.classInitializerInfo = ClassInitializerInfo.EMPTY;
            this.target.setController(this.targetController);
            this.target.analyzeBeforeOptimizations(new ListableClassReaderSourceAdapter(this.dependencyAnalyzer.getClassSource(), new LinkedHashSet<String>(this.dependencyAnalyzer.getReachableClasses())));
            this.initCompileProgress(1000);
            classSet = this.optimizationLevel == MyJavaOptimizationLevel.SIMPLE ? this.lazyPipeline() : this.eagerPipeline();
        } else {
            this.initCompileProgress(500);
            classSet = this.eagerPipeline();
            if (this.wasCancelled()) {
                return;
            }
        }
        if (this.wasCancelled()) {
            return;
        }
        try {
            if (!isLazy) {
                this.compileProgressReportStart = 500;
                this.compileProgressReportLimit = 1000;
            }
            this.target.emit(classSet, buildTarget, outputName, linkClassStatic);
        }
        catch (IOException e) {
            throw new RuntimeException("Error generating output files", e);
        }
    }

    private void initCompileProgress(int limit) {
        this.reportPhase(MyJavaPhase.COMPILING, 1000);
        this.compileProgressReportStart = 0;
        this.compileProgressReportLimit = limit;
    }

    private ListableClassHolderSource eagerPipeline() {
        ListableClassHolderSource classSet;
        this.compileProgressValue = 0;
        this.compileProgressLimit = this.dependencyAnalyzer.getReachableClasses().size();
        this.compileProgressLimit = this.optimizationLevel == MyJavaOptimizationLevel.ADVANCED ? (this.compileProgressLimit *= 4) : (this.compileProgressLimit *= 2);
        this.writtenClasses = classSet = this.link(this.dependencyAnalyzer);
        if (this.wasCancelled()) {
            return null;
        }
        if (this.optimizationLevel != MyJavaOptimizationLevel.SIMPLE) {
            this.devirtualize(classSet);
            if (this.wasCancelled()) {
                return null;
            }
        }
        if (this.optimizationLevel != MyJavaOptimizationLevel.SIMPLE_OPTIMIZED && this.optimizationLevel != MyJavaOptimizationLevel.SIMPLE) {
            ClassInitializerAnalysis classInitializerAnalysis = new ClassInitializerAnalysis(classSet, this.dependencyAnalyzer.getClassHierarchy());
            classInitializerAnalysis.analyze(this.dependencyAnalyzer);
            this.classInitializerInfo = classInitializerAnalysis;
            this.insertClassInit(classSet);
            this.eliminateClassInit(classSet);
        } else {
            this.insertClassInit(classSet);
            this.classInitializerInfo = ClassInitializerInfo.EMPTY;
        }
        this.dependencyAnalyzer.cleanupTypes();
        this.target.setController(this.targetController);
        if (this.wasCancelled()) {
            return null;
        }
        this.target.analyzeBeforeOptimizations(new ListableClassReaderSourceAdapter(this.dependencyAnalyzer.getClassSource(), new LinkedHashSet<String>(this.dependencyAnalyzer.getReachableClasses())));
        this.optimize(classSet);
        if (this.wasCancelled()) {
            return null;
        }
        return classSet;
    }

    private ListableClassHolderSource lazyPipeline() {
        PostProcessingClassHolderSource result = new PostProcessingClassHolderSource();
        this.writtenClasses = result;
        return result;
    }

    private void insertClassInit(ListableClassHolderSource classes) {
        ClassInitializerInsertionTransformer clinitInsertion = new ClassInitializerInsertionTransformer(this.dependencyAnalyzer.getClassSource(), this.classInitializerInfo);
        for (String className : classes.getClassNames()) {
            ClassHolder cls = classes.get(className);
            for (MethodHolder method : cls.getMethods()) {
                Program program = method.getProgram();
                if (program == null) continue;
                clinitInsertion.apply(method, program);
            }
        }
    }

    private void eliminateClassInit(ListableClassHolderSource classes) {
        for (String className : classes.getClassNames()) {
            ClassHolder cls = classes.get(className);
            for (MethodHolder method : cls.getMethods()) {
                Program program = method.getProgram();
                if (program == null) continue;
                for (BasicBlock block : program.getBasicBlocks()) {
                    for (Instruction instruction : block) {
                        InitClassInstruction clinit;
                        if (!(instruction instanceof InitClassInstruction) || this.classInitializerInfo.isDynamicInitializer((clinit = (InitClassInstruction)instruction).getClassName())) continue;
                        clinit.delete();
                    }
                }
            }
        }
        for (MyJavaEntryPoint entryPoint : this.entryPoints.values()) {
            this.addInitializersToEntryPoint(classes, entryPoint.getMethod());
        }
    }

    private void addInitializersToEntryPoint(ClassHolderSource classes, MethodReference methodRef) {
        ClassHolder cls = classes.get(methodRef.getClassName());
        if (cls == null) {
            return;
        }
        MethodHolder method = cls.getMethod(methodRef.getDescriptor());
        if (method == null) {
            return;
        }
        Program program = method.getProgram();
        BasicBlock block = program.basicBlockAt(0);
        Instruction first = block.getFirstInstruction();
        for (String string : this.classInitializerInfo.getInitializationOrder()) {
            InvokeInstruction invoke = new InvokeInstruction();
            invoke.setMethod(new MethodReference(string, "<clinit>", ValueType.VOID));
            first.insertPrevious(invoke);
        }
    }

    public ListableClassHolderSource link(DependencyAnalyzer dependency) {
        Linker linker = new Linker(dependency);
        MutableClassHolderSource cutClasses = new MutableClassHolderSource();
        MissingItemsProcessor missingItemsProcessor = new MissingItemsProcessor(dependency, dependency.getClassHierarchy(), this.diagnostics, this.target.getPlatformTags());
        if (this.wasCancelled()) {
            return cutClasses;
        }
        if (this.wasCancelled()) {
            return cutClasses;
        }
        for (String className : dependency.getReachableClasses()) {
            ClassReader clsReader = dependency.getClassSource().get(className);
            if (clsReader != null) {
                ClassHolder cls = ModelUtils.copyClass(clsReader);
                cutClasses.putClassHolder(cls);
                missingItemsProcessor.processClass(cls);
                linker.link(cls);
            }
            this.reportCompileProgress(++this.compileProgressValue);
            if (!this.wasCancelled()) continue;
            break;
        }
        return cutClasses;
    }

    private void reportPhase(MyJavaPhase phase, int progressLimit) {
        if (this.progressListener.phaseStarted(phase, progressLimit) == MyJavaProgressFeedback.CANCEL) {
            this.cancelled = true;
        }
    }

    private void reportProgress(int progress) {
        if (this.progressListener.progressReached(progress) == MyJavaProgressFeedback.CANCEL) {
            this.cancelled = true;
        }
    }

    private void reportCompileProgress(int progress) {
        this.reportProgress(this.compileProgressReportStart + progress * (this.compileProgressReportLimit - this.compileProgressReportStart) / this.compileProgressLimit);
    }

    private void devirtualize(ListableClassHolderSource classes) {
        if (this.wasCancelled()) {
            return;
        }
        boolean shouldLog = System.getProperty("com.antgroup.antchain.myjava.logDevirtualization", "false").equals("true");
        if (shouldLog) {
            log.info("Running devirtualization");
        }
        Devirtualization devirtualization = new Devirtualization(this.dependencyAnalyzer, this.dependencyAnalyzer.getClassHierarchy());
        for (String className : classes.getClassNames()) {
            ClassHolder cls = classes.get(className);
            for (MethodHolder method : cls.getMethods()) {
                if (method.getProgram() == null) continue;
                devirtualization.apply(method);
            }
            this.reportCompileProgress(++this.compileProgressValue);
            if (!this.wasCancelled()) continue;
            break;
        }
        this.virtualMethods = devirtualization.getVirtualMethods();
        if (shouldLog) {
            log.info("Devirtualization complete");
            log.info("Virtual calls: {}", (Object)devirtualization.getVirtualCallSites());
            log.info("Direct calls: {}", (Object)devirtualization.getDirectCallSites());
        }
    }

    private void inline(ListableClassHolderSource classes) {
        if (this.optimizationLevel == MyJavaOptimizationLevel.SIMPLE) {
            return;
        }
        DefaultInliningStrategy inliningStrategy = this.optimizationLevel == MyJavaOptimizationLevel.FULL ? new DefaultInliningStrategy(20, 7, 300, false) : new DefaultInliningStrategy(100, 7, 300, true);
        Inlining inlining = new Inlining(new ClassHierarchy(classes), this.dependencyAnalyzer, inliningStrategy, classes, this::isExternal, this.optimizationLevel != MyJavaOptimizationLevel.SIMPLE, this.target.getInliningFilter());
        List<MethodReference> methodReferences = inlining.getOrder();
        int classCount = classes.getClassNames().size();
        int initialValue = this.compileProgressValue;
        for (int i = 0; i < methodReferences.size(); ++i) {
            int newProgress;
            MethodHolder method;
            MethodReference methodReference = methodReferences.get(i);
            ClassHolder cls = classes.get(methodReference.getClassName());
            if (cls == null || (method = cls.getMethod(methodReference.getDescriptor())) == null) continue;
            if (method.getProgram() != null) {
                if (!inlining.hasUsages(methodReference)) {
                    inlining.removeUsages(method.getProgram());
                } else {
                    Program program = method.getProgram();
                    MethodOptimizationContextImpl context = new MethodOptimizationContextImpl(method);
                    inlining.apply(program, method.getReference());
                    new UnusedVariableElimination().optimize(context, program);
                }
            }
            if ((newProgress = initialValue + classCount * i / methodReferences.size()) <= this.compileProgressValue) continue;
            this.compileProgressValue = newProgress;
            this.reportCompileProgress(++this.compileProgressValue);
            if (this.wasCancelled()) break;
        }
    }

    private void optimize(ListableClassHolderSource classSource) {
        for (String className : classSource.getClassNames()) {
            ClassHolder cls = classSource.get(className);
            for (MethodHolder method : cls.getMethods()) {
                this.optimizeMethod(method);
            }
            this.reportCompileProgress(++this.compileProgressValue);
            if (!this.wasCancelled()) continue;
            break;
        }
    }

    private void optimizeMethod(MethodHolder method) {
        Program optimizedProgram;
        if (method.getProgram() == null) {
            return;
        }
        Program program = optimizedProgram = !this.cacheStatus.isStaleMethod(method.getReference()) ? this.programCache.get(method.getReference(), this.cacheStatus) : null;
        if (optimizedProgram == null) {
            Program finalProgram = optimizedProgram = this.optimizeMethodCacheMiss(method, ProgramUtils.copy(method.getProgram()));
            this.programCache.store(method.getReference(), finalProgram, () -> this.programDependencyExtractor.extractDependencies(finalProgram));
        }
        method.setProgram(optimizedProgram);
    }

    private Program optimizeMethodCacheMiss(MethodHolder method, Program optimizedProgram) {
        this.target.beforeOptimizations(optimizedProgram, method);
        if (optimizedProgram.basicBlockCount() > 0) {
            boolean changed;
            MethodOptimizationContextImpl context = new MethodOptimizationContextImpl(method);
            do {
                changed = false;
                for (MethodOptimization optimization : this.getOptimizations()) {
                    try {
                        changed |= optimization.optimize(context, optimizedProgram);
                    }
                    catch (AssertionError | Exception e) {
                        ListingBuilder listingBuilder = new ListingBuilder();
                        try {
                            String listing = listingBuilder.buildListing(optimizedProgram, "");
                            log.error("Error optimizing program for method " + method.getReference() + ":\n" + listing);
                        }
                        catch (RuntimeException e2) {
                            log.error("Error optimizing program for method " + method.getReference());
                        }
                        throw new RuntimeException((Throwable)e);
                    }
                }
            } while (changed);
            this.target.afterOptimizations(optimizedProgram, method);
            if (this.target.requiresRegisterAllocation()) {
                RegisterAllocator allocator = new RegisterAllocator();
                allocator.allocateRegisters(method.getReference(), optimizedProgram, this.optimizationLevel == MyJavaOptimizationLevel.SIMPLE || this.optimizationLevel == MyJavaOptimizationLevel.SIMPLE_OPTIMIZED);
            }
        }
        return optimizedProgram;
    }

    private List<MethodOptimization> getOptimizations() {
        ArrayList<MethodOptimization> optimizations = new ArrayList<MethodOptimization>();
        optimizations.add(new RedundantJumpElimination());
        optimizations.add(new ArrayUnwrapMotion());
        if (this.optimizationLevel.ordinal() >= MyJavaOptimizationLevel.ADVANCED.ordinal()) {
            optimizations.add(new ScalarReplacement());
            optimizations.add(new LoopInvariantMotion());
        }
        if (this.optimizationLevel.ordinal() >= MyJavaOptimizationLevel.ADVANCED.ordinal()) {
            optimizations.add(new RepeatedFieldReadElimination());
        }
        optimizations.add(new GlobalValueNumbering(this.optimizationLevel == MyJavaOptimizationLevel.SIMPLE || this.optimizationLevel == MyJavaOptimizationLevel.SIMPLE_OPTIMIZED));
        optimizations.add(new RedundantNullCheckElimination());
        if (this.optimizationLevel.ordinal() >= MyJavaOptimizationLevel.ADVANCED.ordinal()) {
            optimizations.add(new ConstantConditionElimination());
            optimizations.add(new RedundantJumpElimination());
            optimizations.add(new UnusedVariableElimination());
        }
        optimizations.add(new ClassInitElimination());
        optimizations.add(new UnreachableBasicBlockElimination());
        optimizations.add(new UnusedVariableElimination());
        return optimizations;
    }

    public void build(File dir, String fileName) {
        this.build(new DirectoryBuildTarget(dir), fileName);
    }

    public void installPlugins() {
        for (MyJavaPlugin plugin : MyJavaPluginLoader.load(this.classLoader)) {
            plugin.install(this);
        }
    }

    @Override
    public <T> T getService(Class<T> type) {
        Object service = this.services.get(type);
        if (service == null) {
            throw new IllegalArgumentException("Service not registered: " + type.getName());
        }
        return type.cast(service);
    }

    @Override
    public <T> void registerService(Class<T> type, T instance) {
        this.services.put(type, instance);
    }

    @Override
    public <T extends MyJavaHostExtension> T getExtension(Class<T> extensionType) {
        MyJavaHostExtension extension = this.extensions.get(extensionType);
        return (T)(extension != null ? (MyJavaHostExtension)extensionType.cast(extension) : null);
    }

    private Collection<Class<? extends MyJavaHostExtension>> getExtensionTypes(MyJavaHostExtension extension) {
        return Arrays.stream(extension.getClass().getInterfaces()).filter(cls -> cls.isInterface() && MyJavaHostExtension.class.isAssignableFrom((Class<?>)cls)).map(cls -> cls.asSubclass(MyJavaHostExtension.class)).collect(Collectors.toSet());
    }

    boolean isExternal(MethodReference method) {
        MethodDependency dep = this.dependencyAnalyzer.getMethod(method);
        if (dep != null && dep.isCalled()) {
            return true;
        }
        return this.isVirtual(method);
    }

    boolean isVirtual(MethodReference method) {
        if (method.getName().equals("<clinit>")) {
            return false;
        }
        return this.virtualMethods == null || this.virtualMethods.contains(method) || this.additionalVirtualMethods.stream().anyMatch(p -> p.test(method));
    }

    static class ListableClassReaderSourceAdapter
    implements ListableClassReaderSource {
        private ClassReaderSource classSource;
        private Set<String> classes;

        ListableClassReaderSourceAdapter(ClassReaderSource classSource, Set<String> classes) {
            this.classSource = classSource;
            this.classes = Collections.unmodifiableSet(classes.stream().filter(className -> classSource.get((String)className) != null).collect(Collectors.toSet()));
        }

        @Override
        public Set<String> getClassNames() {
            return this.classes;
        }

        @Override
        public ClassReader get(String name) {
            return this.classes.contains(name) ? this.classSource.get(name) : null;
        }
    }

    class PostProcessingClassHolderSource
    implements ListableClassHolderSource {
        private Linker linker;
        private MissingItemsProcessor missingItemsProcessor;
        private Map<String, ClassHolder> cache;
        private Set<String> classNames;
        private ClassInitializerInsertionTransformer clinitInsertion;

        PostProcessingClassHolderSource() {
            this.linker = new Linker(MyJavaVM.this.dependencyAnalyzer);
            this.missingItemsProcessor = new MissingItemsProcessor(MyJavaVM.this.dependencyAnalyzer, MyJavaVM.this.dependencyAnalyzer.getClassHierarchy(), MyJavaVM.this.diagnostics, MyJavaVM.this.target.getPlatformTags());
            this.cache = new HashMap<String, ClassHolder>();
            this.classNames = Collections.unmodifiableSet(new HashSet(MyJavaVM.this.dependencyAnalyzer.getReachableClasses().stream().filter(className -> MyJavaVM.this.dependencyAnalyzer.getClassSource().get((String)className) != null).collect(Collectors.toList())));
            this.clinitInsertion = new ClassInitializerInsertionTransformer(MyJavaVM.this.dependencyAnalyzer.getClassSource(), MyJavaVM.this.classInitializerInfo);
        }

        @Override
        public ClassHolder get(String name) {
            return this.cache.computeIfAbsent(name, className -> {
                ClassReader classReader = MyJavaVM.this.dependencyAnalyzer.getClassSource().get((String)className);
                if (classReader == null) {
                    return null;
                }
                ClassHolder cls = ModelUtils.copyClass(classReader, false);
                for (FieldHolder field : cls.getFields().toArray(new FieldHolder[0])) {
                    FieldReference fieldRef = new FieldReference(cls.getName(), field.getName());
                    if (MyJavaVM.this.dependencyAnalyzer.getField(fieldRef) != null) continue;
                    cls.removeField(field);
                }
                Function<MethodHolder, Program> programSupplier = method -> {
                    Program program;
                    Program program2 = program = !MyJavaVM.this.cacheStatus.isStaleMethod(method.getReference()) ? MyJavaVM.this.programCache.get(method.getReference(), MyJavaVM.this.cacheStatus) : null;
                    if (program == null) {
                        program = ProgramUtils.copy(classReader.getMethod(method.getDescriptor()).getProgram());
                        this.missingItemsProcessor.processMethod(method.getReference(), program);
                        this.linker.link((MethodReader)method, program);
                        this.clinitInsertion.apply((MethodReader)method, program);
                        Program finalProgram = program = MyJavaVM.this.optimizeMethodCacheMiss(method, program);
                        MyJavaVM.this.programCache.store(method.getReference(), finalProgram, () -> MyJavaVM.this.programDependencyExtractor.extractDependencies(finalProgram));
                    }
                    return program;
                };
                for (MethodHolder method2 : cls.getMethods().toArray(new MethodHolder[0])) {
                    MethodDependency methodDep = MyJavaVM.this.dependencyAnalyzer.getMethod(method2.getReference());
                    if (methodDep == null || !methodDep.isUsed()) {
                        if (method2.hasModifier(ElementModifier.STATIC)) {
                            cls.removeMethod(method2);
                            continue;
                        }
                        method2.getModifiers().add(ElementModifier.ABSTRACT);
                        method2.getModifiers().remove((Object)ElementModifier.NATIVE);
                        method2.setProgram(null);
                        continue;
                    }
                    MethodReader methodReader = classReader.getMethod(method2.getDescriptor());
                    if (methodReader == null || methodReader.getProgram() == null) continue;
                    method2.setProgramSupplier(programSupplier);
                }
                return cls;
            });
        }

        @Override
        public Set<String> getClassNames() {
            return this.classNames;
        }
    }

    class MethodOptimizationContextImpl
    implements MethodOptimizationContext {
        private MethodReader method;

        MethodOptimizationContextImpl(MethodReader method) {
            this.method = method;
        }

        @Override
        public MethodReader getMethod() {
            return this.method;
        }

        @Override
        public DependencyInfo getDependencyInfo() {
            return MyJavaVM.this.dependencyAnalyzer;
        }

        @Override
        public ClassReaderSource getClassSource() {
            return MyJavaVM.this.dependencyAnalyzer.getClassSource();
        }
    }
}

