/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.vm;

import com.antgroup.antchain.myjava.vm.BuildTarget;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class MemoryBuildTarget
implements BuildTarget {
    private Map<String, ByteArrayOutputStream> data = new LinkedHashMap<String, ByteArrayOutputStream>();
    private Set<? extends String> names = Collections.unmodifiableSet(this.data.keySet());

    public Set<? extends String> getNames() {
        return this.names;
    }

    public byte[] getContent(String name) {
        ByteArrayOutputStream stream = this.data.get(name);
        return stream != null ? stream.toByteArray() : null;
    }

    public void clear() {
        this.data.clear();
    }

    @Override
    public OutputStream createResource(String fileName) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.data.put(fileName, stream);
        return stream;
    }

    @Override
    public String getFilePath(String fileName) throws IOException {
        return new File(fileName).getPath();
    }

    @Override
    public String getResourceFileDirectory(String fileName) throws IOException {
        return new File(fileName).getParent();
    }

    public OutputStream appendToResource(String fileName) {
        return this.data.computeIfAbsent(fileName, k -> new ByteArrayOutputStream());
    }
}

