/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.runtime;

import com.antgroup.antchain.myjava.interop.Address;
import com.antgroup.antchain.myjava.interop.Export;
import com.antgroup.antchain.myjava.interop.Import;
import com.antgroup.antchain.myjava.interop.NativeInNoJvm;
import com.antgroup.antchain.myjava.interop.NoMetadata;
import com.antgroup.antchain.myjava.interop.StaticInit;
import com.antgroup.antchain.myjava.interop.Unmanaged;
import com.antgroup.antchain.myjava.runtime.MychainLib;
import com.antgroup.antchain.myjava.runtime.RuntimeObject;
import com.antgroup.antchain.myjava.runtime.WasmHeap;

@StaticInit
@Unmanaged
@NoMetadata
public final class WasmRuntime {
    private static boolean wasmStartFuncCalled = false;

    private WasmRuntime() {
    }

    public static int compare(int a, int b) {
        return WasmRuntime.gt(a, b) ? 1 : (WasmRuntime.lt(a, b) ? -1 : 0);
    }

    public static int compare(long a, long b) {
        return WasmRuntime.gt(a, b) ? 1 : (WasmRuntime.lt(a, b) ? -1 : 0);
    }

    public static int compare(float a, float b) {
        return WasmRuntime.gt(a, b) ? 1 : (WasmRuntime.lt(a, b) ? -1 : 0);
    }

    public static int compare(double a, double b) {
        return WasmRuntime.gt(a, b) ? 1 : (WasmRuntime.lt(a, b) ? -1 : 0);
    }

    public static float remainder(float a, float b) {
        return a - (float)((int)(a / b)) * b;
    }

    public static double remainder(double a, double b) {
        return a - (double)((long)(a / b)) * b;
    }

    private static native boolean lt(int var0, int var1);

    private static native boolean gt(int var0, int var1);

    private static native boolean lt(long var0, long var2);

    private static native boolean gt(long var0, long var2);

    private static native boolean lt(float var0, float var1);

    private static native boolean gt(float var0, float var1);

    private static native boolean lt(double var0, double var2);

    private static native boolean gt(double var0, double var2);

    public static Address align(Address address, int alignment) {
        int value = address.toInt();
        if (value == 0) {
            return address;
        }
        value = ((value - 1) / alignment + 1) * alignment;
        return Address.fromInt(value);
    }

    @NativeInNoJvm
    public static boolean inWasmRuntime() {
        return false;
    }

    public static int align(int value, int alignment) {
        if (value == 0) {
            return value;
        }
        value = ((value - 1) / alignment + 1) * alignment;
        return value;
    }

    @Import(name="print", module="spectest")
    public static native void print(int var0);

    @Import(name="println", module="env")
    public static native int printlnString(int var0, int var1);

    @Import(name="logInt", module="env")
    public static native void printInt(int var0);

    @Import(name="abort", module="env")
    public static native void abort();

    @Import(name="MyAbort", module="env")
    public static native int revert(int var0, int var1);

    @Import(name="SetReturnValue", module="env")
    public static native int setReturnValue(int var0, int var1);

    @Import(name="ReadInterfaceName", module="env")
    public static native int readInterfaceName(int var0, int var1);

    @Import(name="ReadInterfaceParams", module="env")
    public static native int readInterfaceParams(int var0, int var1);

    @Import(name="ReadInterfaceNameSize", module="env")
    public static native int readInterfaceNameSize();

    @Import(name="ReadInterfaceParamsSize", module="env")
    public static native int readInterfaceParamsSize();

    @Import(name="CheckAccount", module="env")
    public static native int checkAccount(int var0, int var1);

    @Import(name="GetBlockHash", module="env")
    public static native int getBlockHash(long var0, int var2, int var3);

    @Import(name="GetOrigin", module="env")
    public static native int getOrigin(int var0, int var1);

    @Import(name="GetAuthMap", module="env")
    public static native int getAuthMap(int var0, int var1, int var2, int var3);

    @Import(name="GetAuthMapInCache", module="env")
    public static native int getAuthMapInCache(int var0, int var1, int var2, int var3);

    @Import(name="GetBalance", module="env")
    public static native int getBalance(int var0, int var1, int var2);

    @Import(name="GetCode", module="env")
    public static native int getCode(int var0, int var1, int var2, int var3);

    @Import(name="GetCodeHash", module="env")
    public static native int getCodeHash(int var0, int var1, int var2, int var3);

    @Import(name="GetRecoverKey", module="env")
    public static native int getRecoverKey(int var0, int var1, int var2, int var3);

    @Import(name="GetAccountStatus", module="env")
    public static native int getAccountStatus(int var0, int var1, int var2);

    @Import(name="GetTxHash", module="env")
    public static native int getTxHash(int var0, int var1);

    @Import(name="TransferBalance", module="env")
    public static native int transferBalance(int var0, int var1, long var2);

    @Import(name="Log", module="env")
    public static native int log(int var0, int var1, int var2, int var3);

    @Import(name="GetDataSize", module="env")
    public static native int getDataSize();

    @Import(name="GetData", module="env")
    public static native int getData(int var0, int var1);

    @Import(name="GetSender", module="env")
    public static native int getSender(int var0, int var1);

    @Import(name="GetSelf", module="env")
    public static native int getSelf(int var0, int var1);

    @Import(name="GetRelatedTransactionListSize", module="env")
    public static native int getRelatedTransactionListSize(int var0, int var1, long var2, int var4);

    @Import(name="GetRelatedTransactionList", module="env")
    public static native int getRelatedTransactionList(int var0, int var1, long var2, long var4, int var6, int var7);

    @Import(name="ReadBuffer", module="env")
    public static native int readBuffer(int var0, int var1);

    @Import(name="GetTransaction", module="env")
    public static native int getTransaction(int var0, int var1, int var2, int var3);

    @Import(name="GetConfidentialDeposit", module="env")
    public static native int getConfidentialDeposit(int var0, int var1, int var2, int var3);

    @Import(name="CreateContract", module="env")
    public static native int createContract(int var0, int var1, int var2, int var3);

    @Import(name="Digest", module="env")
    public static native int digest(int var0, int var1, int var2, int var3, int var4);

    @Import(name="VerifyRsa2", module="env")
    public static native int verifyRsa2(int var0, int var1, int var2, int var3, int var4, int var5, int var6);

    @Import(name="Base64Encode", module="env")
    public static native int base64Encode(int var0, int var1, int var2, int var3);

    @Import(name="Base64Decode", module="env")
    public static native int base64Decode(int var0, int var1, int var2, int var3);

    @Import(name="Ecrecovery", module="env")
    public static native int ecrecovery(int var0, int var1, int var2, int var3, int var4, int var5);

    @Import(name="VerifyMessageSM2", module="env")
    public static native int verifyMessageSM2(int var0, int var1, int var2, int var3, int var4, int var5, int var6);

    @Import(name="VerifyMessageECCK1", module="env")
    public static native int verifyMessageECCK1(int var0, int var1, int var2, int var3, int var4, int var5, int var6);

    @Import(name="VerifyMessageECCR1", module="env")
    public static native int verifyMessageECCR1(int var0, int var1, int var2, int var3, int var4, int var5, int var6);

    @Import(name="BellmanSnarkVerify", module="env")
    public static native int bellmanSnarkVerify(int var0, int var1, int var2, int var3, int var4, int var5);

    @Import(name="RangeProofVerify", module="env")
    public static native int rangeProofVerify(int var0, int var1, int var2, int var3, int var4);

    @Import(name="AddPedersenCommit", module="env")
    public static native int addPedersenCommit(int var0, int var1, int var2, int var3, int var4, int var5, int var6);

    @Import(name="SubPedersenCommit", module="env")
    public static native int subPedersenCommit(int var0, int var1, int var2, int var3, int var4, int var5, int var6);

    @Import(name="CalculatePedersenCommit", module="env")
    public static native int calculatePedersenCommit(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    @Import(name="PedersenCommitEqualityVerify", module="env")
    public static native int pedersenCommitEqualityVerify(int var0, int var1, int var2, int var3, int var4);

    @Import(name="LiftedElgamalContractHomomorphicAdd", module="env")
    public static native int liftedElgamalContractHomomorphicAdd(int var0, int var1, int var2, int var3, int var4);

    @Import(name="LiftedElgamalContractHomomorphicSub", module="env")
    public static native int liftedElgamalContractHomomorphicSub(int var0, int var1, int var2, int var3, int var4);

    @Import(name="LiftedElgamalScalarMutiply", module="env")
    public static native int liftedElgamalScalarMutiply(int var0, int var1, long var2, int var4);

    @Import(name="LiftedElgamalContractZeroCheckVerify", module="env")
    public static native int liftedElgamalContractZeroCheckVerify(int var0, int var1, int var2, int var3, int var4);

    @Import(name="LiftedElgamalContractRangeVerify", module="env")
    public static native int liftedElgamalContractRangeVerify(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    @Import(name="SetStorage", module="env")
    public static native int setStorage(int var0, int var1, int var2, int var3);

    @Import(name="GetStorageSize", module="env")
    public static native int getStorageSize(int var0, int var1, int var2);

    @Import(name="GetStorage", module="env")
    public static native int getStorage(int var0, int var1, int var2, int var3);

    @Import(name="DeleteStorage", module="env")
    public static native int deleteStorage(int var0, int var1);

    @Import(name="Result", module="env")
    public static native int result(int var0, int var1);

    @Import(name="GetCallResult", module="env")
    public static native int getCallResult(int var0, int var1);

    @Import(name="ReadBufferRef", module="env")
    public static native int readBufferRef(int var0, int var1);

    @Import(name="VerifyCommitment", module="env")
    public static native int verifyCommitment(int var0, int var1, int var2, int var3, int var4, int var5);

    @Import(name="VerifyRange", module="env")
    public static native int verifyRange(int var0, long var1);

    @Import(name="VerifyBalance", module="env")
    public static native int verifyBalance(int var0);

    @Import(name="FTraceBegin", module="env")
    public static native int fTraceBegin(int var0, int var1);

    @Import(name="DeployContract", module="env")
    public static native int deployContract(int var0, int var1, int var2, int var3, int var4, int var5);

    @Import(name="UpdateContract", module="env")
    public static native int updateContract(int var0, int var1, int var2);

    @Import(name="UpdateContractStatus", module="env")
    public static native int updateContractStatus(int var0, int var1);

    @Import(name="DCGetStorageSize", module="env")
    public static native int dcGetStorageSize(int var0, int var1, int var2, int var3, int var4);

    @Import(name="DCSetStorage", module="env")
    public static native int dcSetStorage(int var0, int var1, int var2, int var3, int var4, int var5);

    @Import(name="DCDeleteStorage", module="env")
    public static native int dcDeleteStorage(int var0, int var1, int var2, int var3);

    @Import(name="DCSetAcl", module="env")
    public static native int dcSetAcl(int var0, int var1, int var2, int var3);

    @Import(name="GrayscaleDeployContract", module="env")
    public static native int grayscaleDeployContract(int var0, int var1, int var2);

    @Import(name="GrayscaleVerification", module="env")
    public static native int grayscaleVerification(int var0);

    @Import(name="GrayscaleVersionSwitchBack", module="env")
    public static native int grayscaleVersionSwitchBack(int var0);

    @Import(name="GrayscaleUpdateContract", module="env")
    public static native int grayscaleUpdateContract(int var0);

    @Import(name="CallContract", module="env")
    public static native int callContract(int var0, int var1, int var2, int var3, long var4, long var6, int var8, int var9);

    @Import(name="__call_evm__", module="env")
    public static native int callEvm(int var0, int var1, int var2, int var3, int var4, int var5, long var6, long var8);

    public static void fillZero(Address address, int count) {
        WasmRuntime.fill(address, (byte)0, count);
    }

    public static void fill(Address address, byte value, int count) {
        int value4 = value & 0xFF000000 | value & 0xFF0000 | value & 0xFF00 | value & 0xFF;
        int start = address.toInt();
        int alignedStart = start >>> 2 << 2;
        address = Address.fromInt(alignedStart);
        switch (start - alignedStart) {
            case 0: {
                address.putInt(value4);
                break;
            }
            case 1: {
                address.add(1).putByte(value);
                address.add(2).putByte(value);
                address.add(3).putByte(value);
                break;
            }
            case 2: {
                address.add(2).putByte(value);
                address.add(3).putByte(value);
                break;
            }
            case 3: {
                address.add(3).putByte(value);
            }
        }
        int end = start + count;
        int alignedEnd = end >>> 2 << 2;
        address = Address.fromInt(alignedEnd);
        switch (end - alignedEnd) {
            case 0: {
                break;
            }
            case 1: {
                address.putByte(value);
                break;
            }
            case 2: {
                address.putByte(value);
                address.add(1).putByte(value);
                break;
            }
            case 3: {
                address.putByte(value);
                address.add(1).putByte(value);
                address.add(2).putByte(value);
            }
        }
        address = Address.fromInt(alignedStart + 4);
        while (address.toInt() < alignedEnd) {
            address.putInt(value4);
            address = address.add(4);
        }
    }

    public static void moveMemoryBlock(Address source, Address target, int count) {
        if (count < 8) {
            WasmRuntime.slowMemoryMove(source, target, count);
            return;
        }
        int diff = source.toInt() - target.toInt();
        if (diff == 0) {
            return;
        }
        if ((diff & 3) != 0) {
            WasmRuntime.slowMemoryMove(source, target, count);
            return;
        }
        Address alignedSourceStart = Address.fromInt(source.toInt() >>> 2 << 2);
        Address alignedTargetStart = Address.fromInt(target.toInt() >>> 2 << 2);
        Address alignedSourceEnd = Address.fromInt(source.toInt() + count >>> 2 << 2);
        Address alignedTargetEnd = Address.fromInt(target.toInt() + count >>> 2 << 2);
        if (source.toInt() > target.toInt()) {
            switch (source.toInt() - alignedSourceStart.toInt()) {
                case 0: {
                    alignedTargetStart.putInt(alignedSourceStart.getInt());
                    break;
                }
                case 1: {
                    alignedTargetStart.add(1).putByte(alignedSourceStart.add(1).getByte());
                    alignedTargetStart.add(2).putShort(alignedSourceStart.add(2).getShort());
                    break;
                }
                case 2: {
                    alignedTargetStart.add(2).putShort(alignedSourceStart.add(2).getShort());
                    break;
                }
                case 3: {
                    alignedTargetStart.add(3).putByte(alignedSourceStart.add(3).getByte());
                }
            }
            alignedSourceStart = alignedSourceStart.add(4);
            alignedTargetStart = alignedTargetStart.add(4);
            while (alignedSourceStart.toInt() < alignedSourceEnd.toInt()) {
                alignedTargetStart.putInt(alignedSourceStart.getInt());
                alignedSourceStart = alignedSourceStart.add(4);
                alignedTargetStart = alignedTargetStart.add(4);
            }
            switch (source.toInt() + count - alignedSourceEnd.toInt()) {
                case 0: {
                    break;
                }
                case 1: {
                    alignedTargetEnd.putByte(alignedSourceEnd.getByte());
                    break;
                }
                case 2: {
                    alignedTargetEnd.putShort(alignedSourceEnd.getShort());
                    break;
                }
                case 3: {
                    alignedTargetEnd.putShort(alignedSourceEnd.getShort());
                    alignedTargetEnd.add(2).putByte(alignedSourceEnd.add(2).getByte());
                }
            }
        } else {
            switch (source.toInt() + count - alignedSourceEnd.toInt()) {
                case 0: {
                    break;
                }
                case 1: {
                    alignedTargetEnd.putByte(alignedSourceEnd.getByte());
                    break;
                }
                case 2: {
                    alignedTargetEnd.putShort(alignedSourceEnd.getShort());
                    break;
                }
                case 3: {
                    alignedTargetEnd.add(2).putByte(alignedSourceEnd.add(2).getByte());
                    alignedTargetEnd.putShort(alignedSourceEnd.getShort());
                }
            }
            while (alignedSourceEnd.toInt() > alignedSourceStart.toInt()) {
                alignedSourceEnd = alignedSourceEnd.add(-4);
                alignedTargetEnd = alignedTargetEnd.add(-4);
                alignedTargetEnd.putInt(alignedSourceEnd.getInt());
            }
            switch (source.toInt() - alignedSourceStart.toInt()) {
                case 1: {
                    alignedTargetStart.add(-2).putShort(alignedSourceStart.add(-2).getShort());
                    alignedTargetStart.add(-3).putByte(alignedSourceStart.add(-3).getByte());
                    break;
                }
                case 2: {
                    alignedTargetStart.add(-2).putShort(alignedSourceStart.add(-2).getShort());
                    break;
                }
                case 3: {
                    alignedTargetStart.add(-1).putByte(alignedSourceStart.add(-1).getByte());
                }
            }
        }
    }

    private static void slowMemoryMove(Address source, Address target, int count) {
        if (source.toInt() > target.toInt()) {
            while (count-- > 0) {
                target.putByte(source.getByte());
                target = target.add(1);
                source = source.add(1);
            }
        } else {
            source = source.add(count);
            target = target.add(count);
            while (count-- > 0) {
                target = target.add(-1);
                source = source.add(-1);
                target.putByte(source.getByte());
            }
        }
    }

    public static Address allocStack(int size) {
        Address stack = WasmHeap.stack;
        Address result = stack.add(4);
        stack = result.add((size << 2) + 4);
        stack.putInt(size);
        WasmHeap.stack = stack;
        return result;
    }

    public static Address getStackTop() {
        return WasmHeap.stack != WasmHeap.stackAddress ? WasmHeap.stack : null;
    }

    public static Address getNextStackFrame(Address stackFrame) {
        int size = stackFrame.getInt() + 2;
        Address result = stackFrame.add(-size * 4);
        if (result == WasmHeap.stackAddress) {
            result = null;
        }
        return result;
    }

    public static int getStackRootCount(Address stackFrame) {
        return stackFrame.getInt();
    }

    public static Address getStackRootPointer(Address stackFrame) {
        int size = stackFrame.getInt();
        return stackFrame.add(-size * 4);
    }

    private static Address getExceptionHandlerPtr(Address stackFrame) {
        int size = stackFrame.getInt();
        return stackFrame.add(-size * 4 - 4);
    }

    public static int getCallSiteId(Address stackFrame) {
        return WasmRuntime.getExceptionHandlerPtr(stackFrame).getInt();
    }

    public static void setExceptionHandlerId(Address stackFrame, int id) {
        WasmRuntime.getExceptionHandlerPtr(stackFrame).putInt(id);
    }

    private static int hashCode(RuntimeString string) {
        int hashCode = 0;
        int length = string.characters.length;
        Address chars = Address.ofData(string.characters);
        for (int i = 0; i < length; ++i) {
            hashCode = 31 * hashCode + chars.getChar();
            chars = chars.add(2);
        }
        return hashCode;
    }

    private static boolean equals(RuntimeString first, RuntimeString second) {
        if (first.characters.length != second.characters.length) {
            return false;
        }
        Address firstChars = Address.ofData(first.characters);
        Address secondChars = Address.ofData(second.characters);
        int length = first.characters.length;
        for (int i = 0; i < length; ++i) {
            if (firstChars.getChar() != secondChars.getChar()) {
                return false;
            }
            firstChars = firstChars.add(2);
            secondChars = secondChars.add(2);
        }
        return true;
    }

    public static String[] resourceMapKeys(Address map) {
        String[] result = new String[WasmRuntime.resourceMapSize(map)];
        WasmRuntime.fillResourceMapKeys(map, result);
        return result;
    }

    private static int resourceMapSize(Address map) {
        int result = 0;
        int sz = map.getInt();
        Address data = WasmRuntime.contentStart(map);
        for (int i = 0; i < sz; ++i) {
            if (data.getAddress() != null) {
                ++result;
            }
            data = data.add(Address.sizeOf() * 2);
        }
        return result;
    }

    private static void fillResourceMapKeys(Address map, String[] target) {
        int sz = map.getInt();
        Address data = WasmRuntime.contentStart(map);
        Address targetData = Address.ofData(target);
        for (int i = 0; i < sz; ++i) {
            Address entry = data.getAddress();
            if (entry != null) {
                targetData.putAddress(entry);
                targetData = targetData.add(Address.sizeOf());
            }
            data = data.add(Address.sizeOf());
        }
    }

    private static Address contentStart(Address resource) {
        return resource.add(Address.sizeOf());
    }

    public static Address lookupResource(Address map, String string) {
        RuntimeString runtimeString = (RuntimeString)Address.ofObject(string).toStructure();
        int hashCode = WasmRuntime.hashCode(runtimeString);
        int sz = map.getInt();
        Address content = WasmRuntime.contentStart(map);
        for (int i = 0; i < sz; ++i) {
            Address entry;
            Address key;
            int index = (hashCode + i) % sz;
            if (index < 0) {
                index += sz;
            }
            if ((key = (entry = content.add(index * Address.sizeOf() * 2)).getAddress()) == null) {
                return null;
            }
            if (!WasmRuntime.equals((RuntimeString)key.toStructure(), runtimeString)) continue;
            return entry;
        }
        return null;
    }

    public static native <T> T addressToObject(Address var0);

    public static native void invokeSpecialVoidIndirect2WithIntLong(int var0, int var1, long var2);

    public static native void invokeSpecialVoidIndirect3WithIntLongLong(int var0, int var1, long var2, long var4);

    public static native void invokeSpecialVoidIndirect3WithIntLongInt(int var0, int var1, long var2, int var4);

    public static native void invokeSpecialVoidIndirect3WithIntIntLong(int var0, int var1, int var2, long var3);

    public static native void invokeSpecialVoidIndirect4WithIntLongLongLong(int var0, int var1, long var2, long var4, long var6);

    public static native void invokeSpecialVoidIndirect4WithIntLongLongInt(int var0, int var1, long var2, long var4, int var6);

    public static native void invokeSpecialVoidIndirect4WithIntLongIntLong(int var0, int var1, long var2, int var4, long var5);

    public static native void invokeSpecialVoidIndirect4WithIntIntLongLong(int var0, int var1, int var2, long var3, long var5);

    public static native void invokeSpecialVoidIndirect4WithIntLongIntInt(int var0, int var1, long var2, int var4, int var5);

    public static native void invokeSpecialVoidIndirect4WithIntIntLongInt(int var0, int var1, int var2, long var3, int var5);

    public static native void invokeSpecialVoidIndirect4WithIntIntIntLong(int var0, int var1, int var2, int var3, long var4);

    public static native long invokeSpecialIndirect1ReturnLongWithInt(int var0, int var1);

    public static native long invokeSpecialIndirect2ReturnLongWithIntLong(int var0, int var1, long var2);

    public static native long invokeSpecialIndirect2ReturnLongWithIntInt(int var0, int var1, int var2);

    public static native int invokeSpecialIndirect2ReturnIntWithIntLong(int var0, int var1, long var2);

    public static native long invokeSpecialIndirect3ReturnLongWithIntLongLong(int var0, int var1, long var2, long var4);

    public static native int invokeSpecialIndirect3ReturnIntWithIntLongLong(int var0, int var1, long var2, long var4);

    public static native long invokeSpecialIndirect3ReturnLongWithIntIntLong(int var0, int var1, int var2, long var3);

    public static native long invokeSpecialIndirect3ReturnLongWithIntLongInt(int var0, int var1, long var2, int var4);

    public static native long invokeSpecialIndirect3ReturnLongWithIntIntInt(int var0, int var1, int var2, int var3);

    public static native int invokeSpecialIndirect3ReturnIntWithIntLongInt(int var0, int var1, long var2, int var4);

    public static native int invokeSpecialIndirect3ReturnIntWithIntIntLong(int var0, int var1, int var2, long var3);

    public static native long invokeSpecialIndirect4ReturnLongWithIntLongLongLong(int var0, int var1, long var2, long var4, long var6);

    public static native int invokeSpecialIndirect4ReturnIntWithIntLongLongLong(int var0, int var1, long var2, long var4, long var6);

    public static native long invokeSpecialIndirect4ReturnLongWithIntIntLongLong(int var0, int var1, int var2, long var3, long var5);

    public static native long invokeSpecialIndirect4ReturnLongWithIntLongIntLong(int var0, int var1, long var2, int var4, long var5);

    public static native long invokeSpecialIndirect4ReturnLongWithIntLongLongInt(int var0, int var1, long var2, long var4, int var6);

    public static native int invokeSpecialIndirect4ReturnIntWithIntIntLongLong(int var0, int var1, int var2, long var3, long var5);

    public static native int invokeSpecialIndirect4ReturnIntWithIntLongIntLong(int var0, int var1, long var2, int var4, long var5);

    public static native int invokeSpecialIndirect4ReturnIntWithIntLongLongInt(int var0, int var1, long var2, long var4, int var6);

    public static native long invokeSpecialIndirect4ReturnLongWithIntIntIntLong(int var0, int var1, int var2, int var3, long var4);

    public static native long invokeSpecialIndirect4ReturnLongWithIntIntLongInt(int var0, int var1, int var2, long var3, int var5);

    public static native long invokeSpecialIndirect4ReturnLongWithIntLongIntInt(int var0, int var1, long var2, int var4, int var5);

    public static native long invokeSpecialIndirect4ReturnLongWithIntIntIntInt(int var0, int var1, int var2, int var3, int var4);

    public static native int invokeSpecialIndirect4ReturnIntWithIntLongIntInt(int var0, int var1, long var2, int var4, int var5);

    public static native int invokeSpecialIndirect4ReturnIntWithIntIntLongInt(int var0, int var1, int var2, long var3, int var5);

    public static native int invokeSpecialIndirect4ReturnIntWithIntIntIntLong(int var0, int var1, int var2, int var3, long var4);

    public static native void invokeVoidIndirect0(int var0);

    public static native void invokeVoidIndirect1(int var0, int var1);

    public static native void invokeVoidIndirect2(int var0, int var1, int var2);

    public static native void invokeVoidIndirect3(int var0, int var1, int var2, int var3);

    public static native void invokeVoidIndirect4(int var0, int var1, int var2, int var3, int var4);

    public static native void invokeVoidIndirect5(int var0, int var1, int var2, int var3, int var4, int var5);

    public static native void invokeVoidIndirect6(int var0, int var1, int var2, int var3, int var4, int var5, int var6);

    public static native void invokeVoidIndirect7(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public static native void invokeVoidIndirect8(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public static native void invokeVoidIndirect9(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    public static native void invokeVoidIndirect10(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);

    public static native int invokeIndirect0(int var0);

    public static native int invokeIndirect1(int var0, int var1);

    public static native int invokeIndirect2(int var0, int var1, int var2);

    public static native int invokeIndirect3(int var0, int var1, int var2, int var3);

    public static native int invokeIndirect4(int var0, int var1, int var2, int var3, int var4);

    public static native int invokeIndirect5(int var0, int var1, int var2, int var3, int var4, int var5);

    public static native int invokeIndirect6(int var0, int var1, int var2, int var3, int var4, int var5, int var6);

    public static native int invokeIndirect7(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public static native int invokeIndirect8(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public static native int invokeIndirect9(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    public static native int invokeIndirect10(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);

    @Export(name="myjava_get_annotation_type")
    public static Class<?> getAnnotationType(Object annotationInstance) {
        return annotationInstance.getClass();
    }

    @NativeInNoJvm
    public static void abortUnreachable() {
        MychainLib.revert(MychainLib.OUT_OF_MEMORY);
    }

    public static void abortDirectly() {
        WasmRuntime.abortUnreachable();
    }

    public static native int getWrapperBodyAddress(int var0);

    public static native int numberOfLeadingZerosOfInt32(int var0);

    public static native long numberOfLeadingZerosOfInt64(long var0);

    public static native int numberOfTrailingZerosOfInt32(int var0);

    public static native long numberOfTrailingZerosOfInt64(long var0);

    public static native int bigCountOfInt32(int var0);

    public static native long bigCountOfInt64(long var0);

    public static native int rotateLeftOfInt32(int var0, int var1);

    public static native long rotateLeftOfInt64(long var0, long var2);

    public static native int rotateRightOfInt32(int var0, int var1);

    public static native long rotateRightOfInt64(long var0, long var2);

    public static native float absOfFloat32(float var0);

    public static native double absOfFloat64(double var0);

    public static native double ceilOfFloat64(double var0);

    public static native double floorOfFloat64(double var0);

    public static native double sqrtOfFloat64(double var0);

    public static native float minOfFloat32(float var0, float var1);

    public static native float maxOfFloat32(float var0, float var1);

    public static native double minOfFloat64(double var0, double var2);

    public static native double maxOfFloat64(double var0, double var2);

    public static native float copySignOfFloat32(float var0, float var1);

    public static native double copySignOfFloat64(double var0, double var2);

    @Unmanaged
    public static boolean isWasmStartFuncCalled() {
        return wasmStartFuncCalled;
    }

    @Unmanaged
    public static void setWasmStartFuncCalled() {
        wasmStartFuncCalled = true;
    }

    public static native void setInt32Global(int var0, int var1);

    public static native void setInt64Global(int var0, long var1);

    public static native int getInt32Global(int var0);

    public static native long getInt64Global(int var0);

    static class RuntimeString
    extends RuntimeObject {
        char[] characters;

        RuntimeString() {
        }
    }
}

