/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.runtime;

import com.antgroup.antchain.myjava.interop.Address;
import com.antgroup.antchain.myjava.interop.NoMetadata;
import com.antgroup.antchain.myjava.interop.StaticInit;
import com.antgroup.antchain.myjava.interop.Unmanaged;
import com.antgroup.antchain.myjava.runtime.MemoryTrace;
import com.antgroup.antchain.myjava.runtime.MychainLib;
import com.antgroup.antchain.myjava.runtime.WasmRuntime;

@StaticInit
@Unmanaged
@NoMetadata
public final class WasmHeap {
    public static final int PAGE_SIZE = 65536;
    public static final int DEFAULT_STACK_SIZE = 262144;
    public static final int DEFAULT_REGION_SIZE = 1024;
    public static int maxMemorySize;
    public static int minHeapSize;
    public static int maxHeapSize;
    public static Address storageAddress;
    public static int storageSize;
    public static Address markQueueAddress;
    public static int markQueueBytesSize;
    public static Address heapAddress;
    public static int heapSize;
    public static int regionSize;
    public static Address memoryLimit;
    public static Address stackAddress;
    public static Address stack;
    public static int stackSize;

    private WasmHeap() {
    }

    public static int calculateStorageSize(int heapSize) {
        return heapSize / 16;
    }

    public static int calculateMarkQueueSize(int heapSize) {
        return heapSize / 8;
    }

    public static int calculateRegionsCount(int heapSize, int regionSize) {
        return heapSize / regionSize + 1;
    }

    public static int calculateRegionsSize(int regionsCount) {
        return regionsCount * 2;
    }

    public static native void growMemory(int var0);

    public static void initHeapTrace(int maxHeap) {
    }

    public static void initHeap(Address start, int minHeap, int maxHeap, int maxMemory, int stackSize) {
        stackAddress = start;
        stack = start;
        heapAddress = WasmRuntime.align(stackAddress.add(stackSize), 16);
        memoryLimit = WasmRuntime.align(start, 65536);
        minHeapSize = minHeap;
        maxHeapSize = maxHeap;
        maxMemorySize = maxMemory;
        WasmHeap.stackSize = stackSize;
        WasmHeap.resizeHeap(minHeap);
    }

    public static void resizeHeap(int newHeapSize) {
        if (newHeapSize > maxHeapSize - heapAddress.toInt()) {
            newHeapSize = maxHeapSize - heapAddress.toInt();
        }
        if (newHeapSize <= heapSize) {
            return;
        }
        int newStorageSize = WasmHeap.calculateStorageSize(newHeapSize);
        int newMarkQueueSize = WasmHeap.calculateMarkQueueSize(newHeapSize);
        Address newStorageAddress = WasmRuntime.align(heapAddress.add(newHeapSize), 16);
        Address newMarkQueueAddress = WasmRuntime.align(newStorageAddress.add(newStorageSize), 16);
        Address newMemoryLimit = WasmRuntime.align(newMarkQueueAddress.add(newMarkQueueSize), 65536);
        if (newMemoryLimit.toInt() > maxMemorySize) {
            newMemoryLimit = Address.fromInt(maxMemorySize);
        }
        if (newMemoryLimit != memoryLimit) {
            WasmHeap.growMemory((int)(newMemoryLimit.toLong() - memoryLimit.toLong()) / 65536);
            memoryLimit = newMemoryLimit;
        }
        if (storageSize > 0) {
            WasmRuntime.moveMemoryBlock(storageAddress, newStorageAddress, storageSize);
        }
        if (markQueueBytesSize > 0) {
            if (newMarkQueueAddress.toInt() + markQueueBytesSize > memoryLimit.toInt()) {
                MychainLib.revert(MychainLib.OUT_OF_MEMORY);
            }
            WasmRuntime.moveMemoryBlock(markQueueAddress, newMarkQueueAddress, markQueueBytesSize);
        }
        MemoryTrace.resizeHeap(heapSize, newHeapSize, newMemoryLimit);
        storageAddress = newStorageAddress;
        markQueueAddress = newMarkQueueAddress;
        storageSize = newStorageSize;
        markQueueBytesSize = newMarkQueueSize;
        heapSize = newHeapSize;
    }

    static {
        storageSize = 0;
        markQueueBytesSize = 0;
        regionSize = 1024;
    }
}

