/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.runtime;

import com.antgroup.antchain.myjava.runtime.HexException;
import com.antgroup.antchain.myjava.runtime.MychainLib;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;

public class UInt128 {
    private long int0;
    private long int1;
    private long int2;
    private long int3;
    private static final long UINT32_MAX = 0xFFFFFFFFL;
    public static final UInt128 ZERO = new UInt128();
    public static final UInt128 ONE = UInt128.valueOf(1);
    public static final UInt128 MAX = UInt128.trimParts(0xFFFFFFFFL, 0xFFFFFFFFL, 0xFFFFFFFFL, 0xFFFFFFFFL);
    private static final UInt128 MAX_UINT128_SQRT = UInt128.trimParts(0L, 0L, 0xFFFFFFFFL, 0xFFFFFFFFL);

    public UInt128(byte[] data) {
        if (data.length < 16) {
            data = UInt128.fillZeroBefore(data, 16 - data.length);
        } else if (data.length > 16) {
            data = Arrays.copyOfRange(data, data.length - 16, data.length);
        }
        this.int0 = UInt128.unpackUint32BigEndian(data, 0);
        this.int1 = UInt128.unpackUint32BigEndian(data, 4);
        this.int2 = UInt128.unpackUint32BigEndian(data, 8);
        this.int3 = UInt128.unpackUint32BigEndian(data, 12);
    }

    private UInt128() {
        this.int0 = 0L;
        this.int1 = 0L;
        this.int2 = 0L;
        this.int3 = 0L;
    }

    private UInt128(long a, long b, long c, long d) {
        this.int0 = a;
        this.int1 = b;
        this.int2 = c;
        this.int3 = d;
    }

    private static byte[] fillZeroBefore(byte[] from, int fillZeroBytesCount) {
        int i;
        byte[] result = new byte[from.length + fillZeroBytesCount];
        for (i = 0; i < fillZeroBytesCount; ++i) {
            result[i] = 0;
        }
        for (i = 0; i < from.length; ++i) {
            result[i + fillZeroBytesCount] = from[i];
        }
        return result;
    }

    public static UInt128 valueOf(int value) {
        UInt128 result = new UInt128();
        result.int3 = value;
        return result;
    }

    public static UInt128 valueOf(long value) {
        UInt128 result = new UInt128();
        result.int3 = value & 0xFFFFFFFFFFFFFFFFL;
        result.int2 = value >> 32;
        return result;
    }

    public static UInt128 fromHex(String hexStr) throws HexException {
        byte[] bytes = MychainLib.hexToBytes(hexStr);
        return new UInt128(bytes);
    }

    private static UInt128 trimParts(long int0, long int1, long int2, long int3) {
        long tmp;
        long bytes4Mode = 0x100000000L;
        if (int3 > 0xFFFFFFFFL) {
            tmp = int3 / bytes4Mode;
            int3 %= bytes4Mode;
            int2 += tmp;
        } else if (int3 < 0L) {
            int3 += bytes4Mode;
            --int2;
        }
        if (int2 > 0xFFFFFFFFL) {
            tmp = int2 / bytes4Mode;
            int2 %= bytes4Mode;
            int1 += tmp;
        } else if (int2 < 0L) {
            int2 += bytes4Mode;
            --int1;
        }
        if (int1 > 0xFFFFFFFFL) {
            tmp = int1 / bytes4Mode;
            int1 %= bytes4Mode;
            int0 += tmp;
        } else if (int1 < 0L) {
            int1 += bytes4Mode;
            --int0;
        }
        if (int0 > 0xFFFFFFFFL) {
            int0 %= bytes4Mode;
        } else if (int0 < 0L && (int0 %= bytes4Mode) < 0L) {
            int0 += bytes4Mode;
        }
        UInt128 result = new UInt128();
        result.int0 = int0;
        result.int1 = int1;
        result.int2 = int2;
        result.int3 = int3;
        return result;
    }

    public UInt128 add(UInt128 other) {
        long newInt0 = this.int0 + other.int0;
        long newInt1 = this.int1 + other.int1;
        long newInt2 = this.int2 + other.int2;
        long newInt3 = this.int3 + other.int3;
        return UInt128.trimParts(newInt0, newInt1, newInt2, newInt3);
    }

    public UInt128 subtract(UInt128 other) {
        int compareResult = this.compareTo(other);
        if (compareResult == 0) {
            return ZERO;
        }
        if (compareResult < 0) {
            UInt128 reverseResult = other.subtract(this);
            byte[] reversedBytes = reverseResult.toByteArray();
            byte[] tmp = Arrays.copyOf(reversedBytes, reversedBytes.length);
            for (int i = 0; i < tmp.length; ++i) {
                tmp[i] = (byte)(tmp[i] ^ 0xFF);
            }
            return new UInt128(tmp).add(ONE);
        }
        return UInt128.trimParts(this.int0 - other.int0, this.int1 - other.int1, this.int2 - other.int2, this.int3 - other.int3);
    }

    public UInt128 multiply(UInt128 other) {
        ArrayList<Long> a = new ArrayList<Long>(Arrays.asList(this.int3, this.int2, this.int1, this.int0));
        ArrayList<Long> b = new ArrayList<Long>(Arrays.asList(other.int3, other.int2, other.int1, other.int0));
        ArrayList<Long> z = new ArrayList<Long>(Arrays.asList(0L, 0L, 0L, 0L));
        for (int i = 0; i < 4; ++i) {
            long carry = 0L;
            int j = 0;
            while (i + j < 4) {
                long product = a.get(i) * b.get(j) + z.get(i + j) + carry;
                z.set(i + j, product & 0xFFFFFFFFL);
                carry = product >>> 32;
                ++j;
            }
        }
        return new UInt128(z.get(3), z.get(2), z.get(1), z.get(0));
    }

    public UInt128 divide(UInt128 other) {
        if (other.compareTo(ZERO) == 0) {
            throw new RuntimeException("invalid divide zero");
        }
        if (other.compareTo(this) > 0) {
            return ZERO;
        }
        UInt128 dividend = this;
        UInt128 divisor = other;
        UInt128 quotient = new UInt128();
        for (int i = divisor.numberOfLeadingZeros() - dividend.numberOfLeadingZeros(); i >= 0; --i) {
            UInt128 temp = divisor.leftShift(i);
            if (temp.compareTo(dividend) > 0) continue;
            quotient.setBit(i);
            dividend = dividend.subtract(temp);
        }
        return quotient;
    }

    private void setBit(int pos) {
        if (pos >= 128 || pos < 0) {
            throw new RuntimeException("position overflow");
        }
        if (pos >= 96) {
            this.int0 |= 1L << pos - 96;
        } else if (pos >= 64) {
            this.int1 |= 1L << pos - 64;
        } else if (pos >= 32) {
            this.int2 |= 1L << pos - 32;
        } else {
            this.int3 |= 1L << pos;
        }
    }

    public UInt128 leftShift(int n) {
        if (n >= 128) {
            return ZERO;
        }
        long r_int0 = this.int0;
        long r_int1 = this.int1;
        long r_int2 = this.int2;
        long r_int3 = this.int3;
        while (n > 0) {
            int bit = n > 32 ? 32 : n;
            n -= bit;
            r_int2 = r_int2 << bit | (r_int3 <<= bit) >>> 32;
            r_int1 = r_int1 << bit | r_int2 >>> 32;
            r_int0 = r_int0 << bit | r_int1 >>> 32;
            r_int3 &= 0xFFFFFFFFL;
            r_int2 &= 0xFFFFFFFFL;
            r_int1 &= 0xFFFFFFFFL;
            r_int0 &= 0xFFFFFFFFL;
        }
        return new UInt128(r_int0, r_int1, r_int2, r_int3);
    }

    public int numberOfLeadingZeros() {
        if (Long.numberOfLeadingZeros(this.int0) != 64) {
            return Long.numberOfLeadingZeros(this.int0) - 32;
        }
        if (Long.numberOfLeadingZeros(this.int1) != 64) {
            return Long.numberOfLeadingZeros(this.int1) - 32 + 32;
        }
        if (Long.numberOfLeadingZeros(this.int2) != 64) {
            return Long.numberOfLeadingZeros(this.int2) - 32 + 32 + 32;
        }
        if (Long.numberOfLeadingZeros(this.int3) != 64) {
            return Long.numberOfLeadingZeros(this.int3) - 32 + 32 + 32 + 32;
        }
        return 128;
    }

    public UInt128 pow(int exp) {
        return new UInt128(this.toBigInteger().pow(exp).toByteArray());
    }

    public UInt128 sqrt() {
        UInt128 p;
        if (this.compareTo(ZERO) == 0) {
            return ZERO;
        }
        UInt128 left = ONE;
        UInt128 right = MAX_UINT128_SQRT;
        UInt128 two = ONE.add(ONE);
        while (left.compareTo(right) < 0 && right.subtract(left).compareTo(two) > 0) {
            UInt128 mid = left.add(right).divide(two);
            p = mid.multiply(mid);
            if (p.equals(this)) {
                return mid;
            }
            if (p.compareTo(this) > 0) {
                right = mid;
                continue;
            }
            left = mid;
        }
        UInt128 i = left;
        while (i.compareTo(right) <= 0) {
            p = i.multiply(i);
            if (p.equals(this)) {
                return i;
            }
            if (p.compareTo(this) > 0) {
                return i.subtract(ONE);
            }
            i = i.add(ONE);
        }
        return right;
    }

    public int compareTo(UInt128 other) {
        if (this.int0 > other.int0) {
            return 1;
        }
        if (this.int0 < other.int0) {
            return -1;
        }
        if (this.int1 > other.int1) {
            return 1;
        }
        if (this.int1 < other.int1) {
            return -1;
        }
        if (this.int2 > other.int2) {
            return 1;
        }
        if (this.int2 < other.int2) {
            return -1;
        }
        if (this.int3 > other.int3) {
            return 1;
        }
        if (this.int3 < other.int3) {
            return -1;
        }
        return 0;
    }

    public byte[] toByteArray() {
        byte[] result = new byte[16];
        UInt128.packUint32BigEndian(this.int0, result, 0);
        UInt128.packUint32BigEndian(this.int1, result, 4);
        UInt128.packUint32BigEndian(this.int2, result, 8);
        UInt128.packUint32BigEndian(this.int3, result, 12);
        return result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof UInt128)) {
            return false;
        }
        UInt128 other = (UInt128)o;
        return this.int0 == other.int0 && this.int1 == other.int1 && this.int2 == other.int2 && this.int3 == other.int3;
    }

    private static void packUint32BigEndian(long value, byte[] target, int targetStartIndex) {
        target[targetStartIndex] = (byte)(value >> 24 & 0xFFL);
        target[targetStartIndex + 1] = (byte)(value >> 16 & 0xFFL);
        target[targetStartIndex + 2] = (byte)(value >> 8 & 0xFFL);
        target[targetStartIndex + 3] = (byte)(value & 0xFFL);
    }

    private static long unpackUint32BigEndian(byte[] source, int sourceStartIndex) {
        long sum = 0L;
        for (int i = 0; i < 4; ++i) {
            sum = sum * 256L + (long)(source[sourceStartIndex + i] & 0xFF);
        }
        return sum;
    }

    public BigInteger toBigInteger() {
        byte[] bytes = this.toByteArray();
        if (bytes.length > 0 && (bytes[0] & Integer.MIN_VALUE) != 0) {
            byte[] tmp = new byte[bytes.length + 1];
            tmp[0] = 0;
            for (int i = 0; i < bytes.length; ++i) {
                tmp[i + 1] = bytes[i];
            }
            bytes = tmp;
        }
        return new BigInteger(bytes);
    }

    public int hashCode() {
        return this.toBigInteger().hashCode();
    }

    public String toString() {
        return this.toBigInteger().toString();
    }
}

