/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.runtime;

import com.antgroup.antchain.myjava.interop.NoMetadata;

@NoMetadata
public class PrimitiveAlgoUtil {
    private static char[][] byteHexCharsMapCache = null;

    private static char[][] getByteHexCharsMapCache() {
        if (byteHexCharsMapCache != null) {
            return byteHexCharsMapCache;
        }
        char[][] tmp = new char[256][];
        for (int i = 0; i < 256; ++i) {
            tmp[i] = PrimitiveAlgoUtil.doParseFromByteToHexString((byte)i);
        }
        byteHexCharsMapCache = tmp;
        return tmp;
    }

    public static char[] toHexStringFromByte(byte b) {
        char[][] cache = PrimitiveAlgoUtil.getByteHexCharsMapCache();
        return cache[b & 0xFF];
    }

    private static char[] doParseFromByteToHexString(byte b) {
        int bInt = b & 0xFF;
        int firstCharCode = bInt / 16;
        if (firstCharCode == 0) {
            int secondCharCode = bInt;
            char secondChar = '0';
            if (secondCharCode > 0 && secondCharCode < 10) {
                secondChar = (char)(48 + secondCharCode);
            } else if (secondCharCode >= 10) {
                secondChar = (char)(87 + secondCharCode);
            }
            char[] chars = new char[]{secondChar};
            return chars;
        }
        char firstChar = '0';
        if (firstCharCode > 0 && firstCharCode < 10) {
            firstChar = (char)(48 + firstCharCode);
        } else if (firstCharCode >= 10) {
            firstChar = (char)(97 + firstCharCode - 10);
        }
        int secondCharCode = bInt % 16;
        char secondChar = '0';
        if (secondCharCode > 0 && secondCharCode < 10) {
            secondChar = (char)(48 + secondCharCode);
        } else if (secondCharCode >= 10) {
            secondChar = (char)(87 + secondCharCode);
        }
        char[] chars = new char[]{firstChar, secondChar};
        return chars;
    }
}

