/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.parsing.substitution;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class PrefixMapping
implements Function<String, String> {
    private String packageClassPrefix;
    private String packageHierarchyClassPrefix;
    private final Map<String, PrefixMapping> subMappings = new HashMap<String, PrefixMapping>();

    @Override
    public String apply(String className) {
        String prefix = this.getPrefix(className.split("\\."));
        return prefix != null ? new StringBuilder(className).insert(className.lastIndexOf(".") + 1, prefix).toString() : className;
    }

    public String revert(String className) {
        String simpleClassName;
        String prefix = this.getPrefix(className.split("\\."));
        if (prefix == null) {
            return className;
        }
        String string = simpleClassName = className.lastIndexOf(".") > 0 ? className.substring(className.lastIndexOf(".") + 1) : className;
        if (!simpleClassName.startsWith(prefix)) {
            return className;
        }
        return new StringBuilder(className).delete(className.lastIndexOf(".") + 1, className.lastIndexOf(".") + 1 + prefix.length()).toString();
    }

    public void setPackageHierarchyClassPrefixRule(String[] packageNameSegments, String classPrefix) {
        if (packageNameSegments == null || packageNameSegments.length < 1) {
            this.packageHierarchyClassPrefix = classPrefix;
        } else {
            this.subMappings.computeIfAbsent(packageNameSegments[0], s -> new PrefixMapping()).setPackageHierarchyClassPrefixRule(Arrays.copyOfRange(packageNameSegments, 1, packageNameSegments.length), classPrefix);
        }
    }

    public void setPackageClassPrefixRule(String[] packageNameSegments, String classPrefix) {
        if (packageNameSegments == null || packageNameSegments.length < 1) {
            this.packageClassPrefix = classPrefix;
        } else {
            this.subMappings.computeIfAbsent(packageNameSegments[0], s -> new PrefixMapping()).setPackageClassPrefixRule(Arrays.copyOfRange(packageNameSegments, 1, packageNameSegments.length), classPrefix);
        }
    }

    private String getPrefix(String[] classNameSegments) {
        if (classNameSegments == null || classNameSegments.length <= 1) {
            return this.packageClassPrefix != null ? this.packageClassPrefix : this.packageHierarchyClassPrefix;
        }
        PrefixMapping prefixMapping = this.subMappings.get(classNameSegments[0]);
        if (prefixMapping != null) {
            String prefix = prefixMapping.getPrefix(Arrays.copyOfRange(classNameSegments, 1, classNameSegments.length));
            return prefix != null ? prefix : this.packageHierarchyClassPrefix;
        }
        return this.packageHierarchyClassPrefix;
    }
}

