/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.parsing.resource;

import com.antgroup.antchain.myjava.model.ClassHolder;
import com.antgroup.antchain.myjava.model.ReferenceCache;
import com.antgroup.antchain.myjava.parsing.Parser;
import com.antgroup.antchain.myjava.parsing.resource.ResourceReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Function;
import org.teavm.asm.ClassReader;
import org.teavm.asm.tree.ClassNode;

public class ResourceClassHolderMapper
implements Function<String, ClassHolder> {
    private Parser parser;
    private ResourceReader resourceReader;

    public ResourceClassHolderMapper(ResourceReader resourceReader, ReferenceCache referenceCache) {
        this.resourceReader = resourceReader;
        this.parser = new Parser(referenceCache);
    }

    @Override
    public ClassHolder apply(String name) {
        ClassNode clsNode = new ClassNode();
        String resourceName = name.replace('.', '/') + ".class";
        if (!this.resourceReader.hasResource(resourceName)) {
            return null;
        }
        try (InputStream input = this.resourceReader.openResource(resourceName);){
            ClassReader reader = new ClassReader(input);
            reader.accept(clsNode, 0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.parser.parseClass(clsNode);
    }
}

