/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.parsing;

import com.antgroup.antchain.myjava.parsing.ResourceProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;

public class JarFileResourceProvider
implements ResourceProvider {
    private File file;

    public JarFileResourceProvider(File file) {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        this.file = file;
    }

    public JarFileResourceProvider(String fileName) {
        this(new File(fileName));
    }

    @Override
    public boolean hasResource(String name) {
        boolean bl;
        JarFile jar = new JarFile(this.file);
        try {
            bl = jar.getEntry(name) != null;
        }
        catch (Throwable throwable) {
            try {
                try {
                    jar.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException ex) {
                throw new IllegalStateException("The underlying file does not exist", ex);
            }
            catch (IOException ex) {
                throw new IllegalStateException("Error reading jar file", ex);
            }
        }
        jar.close();
        return bl;
    }

    @Override
    public InputStream openResource(String name) {
        try {
            ZipEntry entry;
            JarInputStream input = new JarInputStream(new FileInputStream(this.file));
            do {
                if ((entry = input.getNextEntry()) == null) {
                    input.close();
                    throw new IllegalArgumentException("Resource not found: " + name);
                }
                if (!entry.getName().equals(name)) continue;
                return input;
            } while (!name.startsWith("/") || !entry.getName().equals(name.substring(1)));
            return input;
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("The underlying file does not exist");
        }
        catch (IOException e) {
            throw new IllegalStateException("Error reading jar file");
        }
    }
}

