/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.model.util;

import com.antgroup.antchain.myjava.common.Graph;
import com.antgroup.antchain.myjava.common.GraphBuilder;
import com.antgroup.antchain.myjava.common.IntegerStack;
import com.antgroup.antchain.myjava.model.BasicBlockReader;
import com.antgroup.antchain.myjava.model.FieldReference;
import com.antgroup.antchain.myjava.model.IncomingReader;
import com.antgroup.antchain.myjava.model.MethodDescriptor;
import com.antgroup.antchain.myjava.model.MethodHandle;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.PhiReader;
import com.antgroup.antchain.myjava.model.ProgramReader;
import com.antgroup.antchain.myjava.model.RuntimeConstant;
import com.antgroup.antchain.myjava.model.ValueType;
import com.antgroup.antchain.myjava.model.VariableReader;
import com.antgroup.antchain.myjava.model.instructions.AbstractInstructionReader;
import com.antgroup.antchain.myjava.model.instructions.ArrayElementType;
import com.antgroup.antchain.myjava.model.instructions.BinaryOperation;
import com.antgroup.antchain.myjava.model.instructions.CastIntegerDirection;
import com.antgroup.antchain.myjava.model.instructions.InstructionReader;
import com.antgroup.antchain.myjava.model.instructions.IntegerSubtype;
import com.antgroup.antchain.myjava.model.instructions.InvocationType;
import com.antgroup.antchain.myjava.model.instructions.NumericOperandType;
import com.antgroup.antchain.myjava.model.util.VariableType;
import java.util.List;

public class TypeInferer {
    private static InferenceKind[] typesByOrdinal = InferenceKind.values();
    InferenceType[] types;
    GraphBuilder builder;
    GraphBuilder arrayElemBuilder;
    InstructionReader reader = new AbstractInstructionReader(){

        @Override
        public void unwrapArray(VariableReader receiver, VariableReader array, ArrayElementType elementType) {
            TypeInferer.this.builder.addEdge(array.getIndex(), receiver.getIndex());
        }

        @Override
        public void stringConstant(VariableReader receiver, String cst) {
            TypeInferer.this.types[receiver.getIndex()] = new InferenceType(InferenceKind.OBJECT, 0);
        }

        @Override
        public void nullCheck(VariableReader receiver, VariableReader value) {
            TypeInferer.this.builder.addEdge(value.getIndex(), receiver.getIndex());
        }

        @Override
        public void negate(VariableReader receiver, VariableReader operand, NumericOperandType type) {
            TypeInferer.this.types[receiver.getIndex()] = new InferenceType(TypeInferer.this.convert(type), 0);
        }

        @Override
        public void longConstant(VariableReader receiver, long cst) {
            TypeInferer.this.types[receiver.getIndex()] = new InferenceType(InferenceKind.LONG, 0);
        }

        @Override
        public void isInstance(VariableReader receiver, VariableReader value, ValueType type) {
            TypeInferer.this.types[receiver.getIndex()] = new InferenceType(InferenceKind.BYTE, 0);
        }

        @Override
        public void invoke(VariableReader receiver, VariableReader instance, MethodReference method, List<? extends VariableReader> arguments, InvocationType type) {
            if (receiver != null) {
                TypeInferer.this.types[receiver.getIndex()] = TypeInferer.this.convert(method.getReturnType());
            }
        }

        @Override
        public void invokeDynamic(VariableReader receiver, VariableReader instance, MethodDescriptor method, List<? extends VariableReader> arguments, MethodHandle bootstrapMethod, List<RuntimeConstant> bootstrapArguments) {
            if (receiver != null) {
                TypeInferer.this.types[receiver.getIndex()] = TypeInferer.this.convert(method.getResultType());
            }
        }

        @Override
        public void integerConstant(VariableReader receiver, int cst) {
            TypeInferer.this.types[receiver.getIndex()] = new InferenceType(InferenceKind.INT, 0);
        }

        @Override
        public void getField(VariableReader receiver, VariableReader instance, FieldReference field, ValueType fieldType) {
            TypeInferer.this.types[receiver.getIndex()] = TypeInferer.this.convert(fieldType);
        }

        @Override
        public void getElement(VariableReader receiver, VariableReader array, VariableReader index, ArrayElementType type) {
            TypeInferer.this.arrayElemBuilder.addEdge(array.getIndex(), receiver.getIndex());
        }

        @Override
        public void floatConstant(VariableReader receiver, float cst) {
            TypeInferer.this.types[receiver.getIndex()] = new InferenceType(InferenceKind.FLOAT, 0);
        }

        @Override
        public void doubleConstant(VariableReader receiver, double cst) {
            TypeInferer.this.types[receiver.getIndex()] = new InferenceType(InferenceKind.DOUBLE, 0);
        }

        @Override
        public void createArray(VariableReader receiver, ValueType itemType, List<? extends VariableReader> dimensions) {
            TypeInferer.this.types[receiver.getIndex()] = TypeInferer.this.convert(ValueType.arrayOf(itemType));
        }

        @Override
        public void createArray(VariableReader receiver, ValueType itemType, VariableReader size) {
            TypeInferer.this.types[receiver.getIndex()] = TypeInferer.this.convert(ValueType.arrayOf(itemType));
        }

        @Override
        public void create(VariableReader receiver, String type) {
            TypeInferer.this.types[receiver.getIndex()] = new InferenceType(InferenceKind.OBJECT, 0);
        }

        @Override
        public void cloneArray(VariableReader receiver, VariableReader array) {
            TypeInferer.this.builder.addEdge(array.getIndex(), receiver.getIndex());
        }

        @Override
        public void classConstant(VariableReader receiver, ValueType cst) {
            TypeInferer.this.types[receiver.getIndex()] = new InferenceType(InferenceKind.OBJECT, 0);
        }

        @Override
        public void cast(VariableReader receiver, VariableReader value, IntegerSubtype type, CastIntegerDirection targetType) {
            TypeInferer.this.types[receiver.getIndex()] = new InferenceType(InferenceKind.BYTE, 0);
        }

        @Override
        public void cast(VariableReader receiver, VariableReader value, NumericOperandType sourceType, NumericOperandType targetType) {
            TypeInferer.this.types[receiver.getIndex()] = new InferenceType(TypeInferer.this.convert(targetType), 0);
        }

        @Override
        public void cast(VariableReader receiver, VariableReader value, ValueType targetType) {
            TypeInferer.this.types[receiver.getIndex()] = TypeInferer.this.convert(targetType);
        }

        @Override
        public void binary(BinaryOperation op, VariableReader receiver, VariableReader first, VariableReader second, NumericOperandType type) {
            switch (op) {
                case COMPARE: {
                    TypeInferer.this.types[receiver.getIndex()] = new InferenceType(InferenceKind.INT, 0);
                    break;
                }
                default: {
                    TypeInferer.this.types[receiver.getIndex()] = new InferenceType(TypeInferer.this.convert(type), 0);
                }
            }
        }

        @Override
        public void assign(VariableReader receiver, VariableReader assignee) {
            TypeInferer.this.builder.addEdge(assignee.getIndex(), receiver.getIndex());
        }

        @Override
        public void arrayLength(VariableReader receiver, VariableReader array) {
            TypeInferer.this.types[receiver.getIndex()] = new InferenceType(InferenceKind.INT, 0);
        }

        @Override
        public void boundCheck(VariableReader receiver, VariableReader index, VariableReader array, boolean lower) {
            TypeInferer.this.types[receiver.getIndex()] = new InferenceType(InferenceKind.INT, 0);
        }
    };

    /*
     * WARNING - void declaration
     */
    public void inferTypes(ProgramReader program, MethodReference method) {
        void var7_10;
        int i;
        int sz = program.variableCount();
        this.types = new InferenceType[sz];
        this.types[0] = new InferenceType(InferenceKind.OBJECT, 0);
        for (i = 0; i < method.parameterCount(); ++i) {
            ValueType param = method.parameterType(i);
            this.types[i + 1] = this.convert(param);
        }
        this.builder = new GraphBuilder(sz);
        this.arrayElemBuilder = new GraphBuilder(sz);
        for (i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlockReader block = program.basicBlockAt(i);
            if (block.getExceptionVariable() != null) {
                this.types[block.getExceptionVariable().getIndex()] = new InferenceType(InferenceKind.OBJECT, 0);
            }
            block.readAllInstructions(this.reader);
            for (PhiReader phiReader : block.readPhis()) {
                for (IncomingReader incomingReader : phiReader.readIncomings()) {
                    this.builder.addEdge(incomingReader.getValue().getIndex(), phiReader.getReceiver().getIndex());
                }
            }
        }
        IntegerStack stack = new IntegerStack(sz * 2);
        Graph graph = this.builder.build();
        Graph arrayElemGraph = this.arrayElemBuilder.build();
        boolean bl = false;
        while (var7_10 < graph.size()) {
            if (this.types[var7_10] != null && graph.outgoingEdgesCount((int)var7_10) > 0) {
                stack.push(this.types[var7_10].kind.ordinal());
                stack.push(this.types[var7_10].degree);
                stack.push((int)var7_10);
                this.types[var7_10] = null;
            }
            ++var7_10;
        }
        while (!stack.isEmpty()) {
            int n = stack.pop();
            int degree = stack.pop();
            InferenceKind inferenceKind = typesByOrdinal[stack.pop()];
            if (this.types[n] != null) continue;
            this.types[n] = new InferenceType(inferenceKind, degree);
            for (int successor : graph.outgoingEdges(n)) {
                if (this.types[successor] != null) continue;
                stack.push(inferenceKind.ordinal());
                stack.push(degree);
                stack.push(successor);
            }
            for (int successor : arrayElemGraph.outgoingEdges(n)) {
                if (this.types[successor] != null) continue;
                stack.push(inferenceKind.ordinal());
                stack.push(degree - 1);
                stack.push(successor);
            }
        }
    }

    public VariableType typeOf(int variableIndex) {
        InferenceType result = this.types[variableIndex];
        if (result == null) {
            return VariableType.OBJECT;
        }
        if (result.degree == 0) {
            switch (result.kind) {
                case BYTE: 
                case SHORT: 
                case CHAR: 
                case INT: {
                    return VariableType.INT;
                }
                case LONG: {
                    return VariableType.LONG;
                }
                case FLOAT: {
                    return VariableType.FLOAT;
                }
                case DOUBLE: {
                    return VariableType.DOUBLE;
                }
            }
            return VariableType.OBJECT;
        }
        if (result.degree == 1) {
            switch (result.kind) {
                case BYTE: {
                    return VariableType.BYTE_ARRAY;
                }
                case SHORT: {
                    return VariableType.SHORT_ARRAY;
                }
                case CHAR: {
                    return VariableType.CHAR_ARRAY;
                }
                case INT: {
                    return VariableType.INT_ARRAY;
                }
                case LONG: {
                    return VariableType.LONG_ARRAY;
                }
                case FLOAT: {
                    return VariableType.FLOAT_ARRAY;
                }
                case DOUBLE: {
                    return VariableType.DOUBLE_ARRAY;
                }
            }
        }
        return VariableType.OBJECT_ARRAY;
    }

    InferenceType convert(ValueType type) {
        int degree = 0;
        while (type instanceof ValueType.Array) {
            ++degree;
            type = ((ValueType.Array)type).getItemType();
        }
        if (type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: 
                case BYTE: {
                    return new InferenceType(InferenceKind.BYTE, degree);
                }
                case SHORT: {
                    return new InferenceType(InferenceKind.SHORT, degree);
                }
                case CHARACTER: {
                    return new InferenceType(InferenceKind.CHAR, degree);
                }
                case INTEGER: {
                    return new InferenceType(InferenceKind.INT, degree);
                }
                case FLOAT: {
                    return new InferenceType(InferenceKind.FLOAT, degree);
                }
                case DOUBLE: {
                    return new InferenceType(InferenceKind.DOUBLE, degree);
                }
                case LONG: {
                    return new InferenceType(InferenceKind.LONG, degree);
                }
            }
        }
        return new InferenceType(InferenceKind.OBJECT, degree);
    }

    InferenceKind convert(NumericOperandType type) {
        switch (type) {
            case INT: {
                return InferenceKind.INT;
            }
            case LONG: {
                return InferenceKind.LONG;
            }
            case FLOAT: {
                return InferenceKind.FLOAT;
            }
            case DOUBLE: {
                return InferenceKind.DOUBLE;
            }
        }
        throw new AssertionError();
    }

    static class InferenceType {
        final InferenceKind kind;
        final int degree;

        InferenceType(InferenceKind kind, int degree) {
            this.kind = kind;
            this.degree = degree;
        }
    }

    static enum InferenceKind {
        BYTE,
        SHORT,
        CHAR,
        INT,
        LONG,
        FLOAT,
        DOUBLE,
        OBJECT;

    }
}

