/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.model.util;

import com.antgroup.antchain.myjava.common.DisjointSet;
import com.antgroup.antchain.myjava.common.MutableGraphEdge;
import com.antgroup.antchain.myjava.common.MutableGraphNode;
import com.antgroup.antchain.myjava.model.BasicBlock;
import com.antgroup.antchain.myjava.model.Incoming;
import com.antgroup.antchain.myjava.model.Instruction;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.Phi;
import com.antgroup.antchain.myjava.model.Program;
import com.antgroup.antchain.myjava.model.ProgramReader;
import com.antgroup.antchain.myjava.model.TextLocation;
import com.antgroup.antchain.myjava.model.Variable;
import com.antgroup.antchain.myjava.model.instructions.AssignInstruction;
import com.antgroup.antchain.myjava.model.instructions.JumpInstruction;
import com.antgroup.antchain.myjava.model.util.BasicBlockMapper;
import com.antgroup.antchain.myjava.model.util.DefinitionExtractor;
import com.antgroup.antchain.myjava.model.util.GraphColorer;
import com.antgroup.antchain.myjava.model.util.InstructionVariableMapper;
import com.antgroup.antchain.myjava.model.util.InterferenceGraphBuilder;
import com.antgroup.antchain.myjava.model.util.LivenessAnalyzer;
import com.antgroup.antchain.myjava.model.util.TypeInferer;
import com.antgroup.antchain.myjava.model.util.VariableType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RegisterAllocator {
    public void allocateRegisters(MethodReference method, Program program, boolean debuggerFriendly) {
        Variable var;
        int i;
        this.insertPhiArgumentsCopies(program);
        InterferenceGraphBuilder interferenceBuilder = new InterferenceGraphBuilder();
        LivenessAnalyzer liveness = new LivenessAnalyzer();
        liveness.analyze(program, method.getDescriptor());
        List<MutableGraphNode> interferenceGraph = interferenceBuilder.build(program, method.parameterCount(), liveness);
        DisjointSet congruenceClasses = this.buildPhiCongruenceClasses(program);
        RegisterAllocator.joinClassNodes(interferenceGraph, congruenceClasses);
        this.removeRedundantCopies(program, interferenceGraph, congruenceClasses);
        int[] classArray = congruenceClasses.pack(program.variableCount());
        this.renameVariables(program, classArray);
        int[] colors = new int[program.variableCount()];
        Arrays.fill(colors, -1);
        for (int i2 = 0; i2 <= method.parameterCount(); ++i2) {
            colors[i2] = i2;
        }
        this.renameInterferenceGraph(interferenceGraph, congruenceClasses, classArray);
        GraphColorer colorer = new GraphColorer();
        int maxClass = 0;
        for (int cls : classArray) {
            maxClass = Math.max(maxClass, cls + 1);
        }
        int[] categories = this.getVariableCategories(program, method);
        String[] names = this.getVariableNames(program, debuggerFriendly);
        colorer.colorize(MutableGraphNode.toGraph(interferenceGraph), colors, categories, names);
        int maxColor = 0;
        for (int i3 = 0; i3 < colors.length; ++i3) {
            program.variableAt(i3).setRegister(colors[i3]);
            maxColor = Math.max(maxColor, colors[i3] + 1);
        }
        String[] namesByRegister = new String[maxColor];
        for (i = 0; i < program.variableCount(); ++i) {
            var = program.variableAt(i);
            if (var.getDebugName() == null || var.getRegister() < 0) continue;
            namesByRegister[var.getRegister()] = names[i];
        }
        for (i = 0; i < program.variableCount(); ++i) {
            var = program.variableAt(i);
            if (var.getRegister() < 0) continue;
            var.setDebugName(namesByRegister[var.getRegister()]);
        }
        for (i = 0; i < program.basicBlockCount(); ++i) {
            program.basicBlockAt(i).getPhis().clear();
        }
    }

    private int[] getVariableCategories(ProgramReader program, MethodReference method) {
        TypeInferer inferer = new TypeInferer();
        inferer.inferTypes(program, method);
        int[] categories = new int[program.variableCount()];
        for (int i = 0; i < program.variableCount(); ++i) {
            categories[i] = this.getCategory(inferer.typeOf(i));
        }
        return categories;
    }

    private int getCategory(VariableType type) {
        if (type == null) {
            return 255;
        }
        switch (type) {
            case INT: {
                return 0;
            }
            case LONG: {
                return 1;
            }
            case FLOAT: {
                return 2;
            }
            case DOUBLE: {
                return 3;
            }
            case OBJECT: {
                return 4;
            }
        }
        return 5;
    }

    private String[] getVariableNames(ProgramReader program, boolean debuggerFriendly) {
        String[] names = new String[program.variableCount()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = program.variableAt(i).getDebugName();
            if (!debuggerFriendly || names[i] != null) continue;
            names[i] = "";
        }
        return names;
    }

    private static void joinClassNodes(List<MutableGraphNode> graph, DisjointSet classes) {
        int sz = graph.size();
        for (int i = 0; i < sz; ++i) {
            int cls = classes.find(i);
            while (cls >= graph.size()) {
                graph.add(new MutableGraphNode(graph.size()));
            }
            if (cls == i) continue;
            for (MutableGraphEdge edge : graph.get(i).getEdges().toArray(new MutableGraphEdge[0])) {
                if (edge.getFirst() == graph.get(i)) {
                    edge.setFirst(graph.get(cls));
                }
                if (edge.getSecond() != graph.get(i)) continue;
                edge.setSecond(graph.get(cls));
            }
            graph.set(i, graph.get(cls));
        }
    }

    private void insertPhiArgumentsCopies(Program program) {
        ArrayList<Object> catchIncomingsByVariable = new ArrayList<Object>(Collections.nCopies(program.variableCount(), null));
        int sz = program.basicBlockCount();
        for (int i = 0; i < sz; ++i) {
            BasicBlock block = program.basicBlockAt(i);
            HashMap<BasicBlock, BasicBlock> blockMap = new HashMap<BasicBlock, BasicBlock>();
            ArrayList<Incoming> arrayList = new ArrayList<Incoming>();
            for (Phi phi : block.getPhis()) {
                for (Incoming incoming : phi.getIncomings()) {
                    int fromTry = incoming.getSource().getTryCatchBlocks().stream().anyMatch(tryCatch -> tryCatch.getHandler() == incoming.getPhi().getBasicBlock());
                    if (fromTry != 0) {
                        int valueIndex = incoming.getValue().getIndex();
                        ArrayList<Incoming> catchIncomings = (ArrayList<Incoming>)catchIncomingsByVariable.get(valueIndex);
                        if (catchIncomings == null) {
                            catchIncomings = new ArrayList<Incoming>(1);
                            catchIncomingsByVariable.set(valueIndex, catchIncomings);
                        }
                        catchIncomings.add(incoming);
                        continue;
                    }
                    this.insertCopy(incoming, blockMap);
                    arrayList.add(incoming);
                }
            }
            for (Incoming incoming : arrayList) {
                this.insertCopy(incoming, blockMap);
            }
        }
        DefinitionExtractor definitionExtractor = new DefinitionExtractor();
        ArrayList<Instruction> nextInstructions = new ArrayList<Instruction>();
        for (BasicBlock basicBlock : program.getBasicBlocks()) {
            for (Phi phi : basicBlock.getPhis()) {
                this.addExceptionHandlingCopies(catchIncomingsByVariable, phi.getReceiver(), basicBlock, program, basicBlock.getFirstInstruction().getLocation(), nextInstructions);
            }
            if (!nextInstructions.isEmpty()) {
                basicBlock.addFirstAll(nextInstructions);
                nextInstructions.clear();
            }
            for (Instruction instruction : basicBlock) {
                Variable[] definedVariables;
                instruction.acceptVisitor(definitionExtractor);
                for (Variable definedVariable : definedVariables = definitionExtractor.getDefinedVariables()) {
                    this.addExceptionHandlingCopies(catchIncomingsByVariable, definedVariable, basicBlock, program, instruction.getLocation(), nextInstructions);
                }
                if (nextInstructions.isEmpty()) continue;
                instruction.insertNextAll(nextInstructions);
                nextInstructions.clear();
            }
        }
        for (List list : catchIncomingsByVariable) {
            if (list == null) continue;
            for (Incoming incoming : list) {
                BasicBlock block = incoming.getSource();
                Variable variable = program.createVariable();
                variable.setLabel(incoming.getPhi().getReceiver().getLabel());
                variable.setDebugName(incoming.getPhi().getReceiver().getDebugName());
                AssignInstruction copyInstruction = new AssignInstruction();
                copyInstruction.setReceiver(variable);
                copyInstruction.setAssignee(incoming.getValue());
                copyInstruction.setLocation(block.getFirstInstruction().getLocation());
                incoming.setValue(variable);
                block.addFirst(copyInstruction);
            }
        }
    }

    private void addExceptionHandlingCopies(List<List<Incoming>> catchIncomingsByVariable, Variable definedVariable, BasicBlock block, Program program, TextLocation location, List<Instruction> nextInstructions) {
        if (definedVariable.getIndex() >= catchIncomingsByVariable.size()) {
            return;
        }
        List<Incoming> catchIncomings = catchIncomingsByVariable.get(definedVariable.getIndex());
        if (catchIncomings == null) {
            return;
        }
        Iterator<Incoming> iter = catchIncomings.iterator();
        while (iter.hasNext()) {
            Incoming incoming = iter.next();
            if (incoming.getSource() != block) continue;
            Variable copy = program.createVariable();
            copy.setLabel(incoming.getPhi().getReceiver().getLabel());
            copy.setDebugName(incoming.getPhi().getReceiver().getDebugName());
            AssignInstruction copyInstruction = new AssignInstruction();
            copyInstruction.setReceiver(copy);
            copyInstruction.setAssignee(incoming.getValue());
            copyInstruction.setLocation(location);
            incoming.setValue(copy);
            nextInstructions.add(copyInstruction);
            iter.remove();
        }
    }

    private void insertCopy(Incoming incoming, Map<BasicBlock, BasicBlock> blockMap) {
        Phi phi = incoming.getPhi();
        Program program = phi.getBasicBlock().getProgram();
        AssignInstruction copyInstruction = new AssignInstruction();
        Variable firstCopy = program.createVariable();
        firstCopy.setLabel(phi.getReceiver().getLabel());
        firstCopy.setDebugName(phi.getReceiver().getDebugName());
        copyInstruction.setReceiver(firstCopy);
        copyInstruction.setAssignee(incoming.getValue());
        BasicBlock source = blockMap.get(incoming.getSource());
        if (source == null) {
            source = incoming.getSource();
        } else {
            incoming.setSource(source);
        }
        if (!(incoming.getSource().getLastInstruction() instanceof JumpInstruction)) {
            BasicBlock copyBlock = program.createBasicBlock();
            JumpInstruction jumpInstruction = new JumpInstruction();
            jumpInstruction.setLocation(incoming.getSource().getLastInstruction().getLocation());
            jumpInstruction.setTarget(phi.getBasicBlock());
            copyBlock.add(jumpInstruction);
            incoming.getSource().getLastInstruction().acceptVisitor(new BasicBlockMapper(block -> block == phi.getBasicBlock().getIndex() ? copyBlock.getIndex() : block));
            blockMap.put(source, copyBlock);
            incoming.setSource(copyBlock);
            source = copyBlock;
        }
        source.getLastInstruction().insertPrevious(copyInstruction);
        incoming.setValue(copyInstruction.getReceiver());
    }

    private void removeRedundantCopies(Program program, List<MutableGraphNode> interferenceGraph, DisjointSet congruenceClasses) {
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlock block = program.basicBlockAt(i);
            Instruction insn = block.getFirstInstruction();
            while (insn != null) {
                Instruction nextInsn = insn.getNext();
                if (insn instanceof AssignInstruction) {
                    AssignInstruction assignment = (AssignInstruction)insn;
                    boolean interfere = false;
                    int copyClass = congruenceClasses.find(assignment.getReceiver().getIndex());
                    int origClass = congruenceClasses.find(assignment.getAssignee().getIndex());
                    for (MutableGraphEdge edge : interferenceGraph.get(origClass).getEdges()) {
                        int neighbour;
                        if (edge.getFirst() == edge.getSecond() || (neighbour = congruenceClasses.find(edge.getSecond().getTag())) != copyClass && neighbour != origClass) continue;
                        interfere = true;
                        break;
                    }
                    if (!interfere) {
                        int newClass = congruenceClasses.union(copyClass, origClass);
                        insn.delete();
                        if (newClass == interferenceGraph.size()) {
                            MutableGraphNode newNode = new MutableGraphNode(interferenceGraph.size());
                            interferenceGraph.add(newNode);
                        }
                        for (MutableGraphEdge edge : interferenceGraph.get(origClass).getEdges().toArray(new MutableGraphEdge[0])) {
                            if (edge.getFirst() == interferenceGraph.get(origClass)) {
                                edge.setFirst(interferenceGraph.get(newClass));
                            }
                            if (edge.getSecond() != interferenceGraph.get(origClass)) continue;
                            edge.setSecond(interferenceGraph.get(newClass));
                        }
                        for (MutableGraphEdge edge : interferenceGraph.get(copyClass).getEdges().toArray(new MutableGraphEdge[0])) {
                            if (edge.getFirst() == interferenceGraph.get(copyClass)) {
                                edge.setFirst(interferenceGraph.get(newClass));
                            }
                            if (edge.getSecond() != interferenceGraph.get(copyClass)) continue;
                            edge.setSecond(interferenceGraph.get(newClass));
                        }
                        interferenceGraph.set(copyClass, interferenceGraph.get(newClass));
                        interferenceGraph.set(origClass, interferenceGraph.get(newClass));
                    }
                }
                insn = nextInsn;
            }
        }
    }

    private void renameVariables(Program program, int[] varMap) {
        int i;
        InstructionVariableMapper mapper = new InstructionVariableMapper(var -> program.variableAt(varMap[var.getIndex()]));
        for (int i2 = 0; i2 < program.basicBlockCount(); ++i2) {
            BasicBlock block = program.basicBlockAt(i2);
            mapper.apply(block);
        }
        String[] originalNames = this.getVariableNames(program, false);
        for (i = 0; i < program.variableCount(); ++i) {
            program.variableAt(i).setDebugName(null);
        }
        for (i = 0; i < program.variableCount(); ++i) {
            Variable var2 = program.variableAt(varMap[i]);
            if (originalNames[i] == null) continue;
            var2.setDebugName(originalNames[i]);
        }
    }

    private void renameInterferenceGraph(List<MutableGraphNode> graph, DisjointSet classes, int[] varMap) {
        ArrayList<MutableGraphNode> newGraph = new ArrayList<MutableGraphNode>();
        for (int i = 0; i < graph.size(); ++i) {
            int mapped = varMap[i];
            while (newGraph.size() <= mapped) {
                newGraph.add(null);
            }
            if (newGraph.get(mapped) != null) continue;
            int cls = classes.find(i);
            newGraph.set(mapped, graph.get(cls));
            graph.get(cls).setTag(mapped);
        }
        graph.clear();
        graph.addAll(newGraph);
    }

    private DisjointSet buildPhiCongruenceClasses(Program program) {
        int i;
        DisjointSet classes = new DisjointSet();
        for (i = 0; i < program.variableCount(); ++i) {
            classes.create();
        }
        for (i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlock block = program.basicBlockAt(i);
            for (Phi phi : block.getPhis()) {
                for (Incoming incoming : phi.getIncomings()) {
                    classes.union(phi.getReceiver().getIndex(), incoming.getValue().getIndex());
                }
            }
        }
        return classes;
    }
}

