/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.model.util;

import com.antgroup.antchain.myjava.ast.ControlFlowEntry;
import com.antgroup.antchain.myjava.common.Graph;
import com.antgroup.antchain.myjava.common.GraphBuilder;
import com.antgroup.antchain.myjava.model.BasicBlock;
import com.antgroup.antchain.myjava.model.BasicBlockReader;
import com.antgroup.antchain.myjava.model.Incoming;
import com.antgroup.antchain.myjava.model.IncomingReader;
import com.antgroup.antchain.myjava.model.Instruction;
import com.antgroup.antchain.myjava.model.InstructionIterator;
import com.antgroup.antchain.myjava.model.InstructionReadVisitor;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.Phi;
import com.antgroup.antchain.myjava.model.PhiReader;
import com.antgroup.antchain.myjava.model.Program;
import com.antgroup.antchain.myjava.model.ProgramReader;
import com.antgroup.antchain.myjava.model.TextLocation;
import com.antgroup.antchain.myjava.model.TryCatchBlock;
import com.antgroup.antchain.myjava.model.TryCatchBlockReader;
import com.antgroup.antchain.myjava.model.Variable;
import com.antgroup.antchain.myjava.model.instructions.ConstructInstruction;
import com.antgroup.antchain.myjava.model.instructions.InvocationType;
import com.antgroup.antchain.myjava.model.instructions.InvokeInstruction;
import com.antgroup.antchain.myjava.model.instructions.RaiseInstruction;
import com.antgroup.antchain.myjava.model.util.DefinitionExtractor;
import com.antgroup.antchain.myjava.model.util.InstructionCopyReader;
import com.antgroup.antchain.myjava.model.util.LocationGraphBuilder;
import com.antgroup.antchain.myjava.model.util.ModelUtils;
import com.antgroup.antchain.myjava.model.util.TransitionExtractor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public final class ProgramUtils {
    private static final MethodReference NPE_INIT_METHOD = new MethodReference(NullPointerException.class, "<init>", Void.TYPE);

    private ProgramUtils() {
    }

    public static Graph buildControlFlowGraph(Program program) {
        GraphBuilder graphBuilder = new GraphBuilder(program.basicBlockCount());
        TransitionExtractor transitionExtractor = new TransitionExtractor();
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlock block = program.basicBlockAt(i);
            Instruction insn = block.getLastInstruction();
            if (insn != null) {
                insn.acceptVisitor(transitionExtractor);
                if (transitionExtractor.getTargets() != null) {
                    for (BasicBlock successor : transitionExtractor.getTargets()) {
                        graphBuilder.addEdge(i, successor.getIndex());
                    }
                }
            }
            for (TryCatchBlock tryCatch : block.getTryCatchBlocks()) {
                graphBuilder.addEdge(i, tryCatch.getHandler().getIndex());
            }
        }
        return graphBuilder.build();
    }

    public static ControlFlowEntry[] getLocationCFG(Program program) {
        return new LocationGraphBuilder().build(program);
    }

    public static Program copy(ProgramReader program) {
        int i;
        Program copy = new Program();
        for (i = 0; i < program.variableCount(); ++i) {
            Variable var = copy.createVariable();
            var.setDebugName(program.variableAt(i).getDebugName());
            var.setLabel(program.variableAt(i).getLabel());
        }
        for (i = 0; i < program.basicBlockCount(); ++i) {
            copy.createBasicBlock();
        }
        for (i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlockReader block = program.basicBlockAt(i);
            BasicBlock blockCopy = copy.basicBlockAt(i);
            ProgramUtils.copyBasicBlock(block, blockCopy);
        }
        ModelUtils.copyAnnotations(program.getAnnotations(), copy.getAnnotations());
        return copy;
    }

    public static void copyBasicBlock(BasicBlockReader block, BasicBlock target) {
        Program targetProgram = target.getProgram();
        if (block.getExceptionVariable() != null) {
            target.setExceptionVariable(targetProgram.variableAt(block.getExceptionVariable().getIndex()));
        }
        InstructionCopyReader copyReader = new InstructionCopyReader(targetProgram);
        InstructionIterator iterator = block.iterateInstructions();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.read(copyReader);
            target.add(copyReader.getCopy());
        }
        target.getPhis().addAll(ProgramUtils.copyPhis(block, targetProgram));
        target.getTryCatchBlocks().addAll(ProgramUtils.copyTryCatches(block, targetProgram));
    }

    public static List<Instruction> copyInstructions(Instruction from, Instruction to, Program target) {
        ArrayList<Instruction> result = new ArrayList<Instruction>();
        InstructionCopyReader copyReader = new InstructionCopyReader(target);
        InstructionReadVisitor visitor = new InstructionReadVisitor(copyReader);
        while (from != to) {
            from.acceptVisitor(visitor);
            copyReader.getCopy().setLocation(from.getLocation());
            result.add(copyReader.getCopy());
            from = from.getNext();
        }
        return result;
    }

    public static List<Phi> copyPhis(BasicBlockReader block, Program target) {
        ArrayList<Phi> result = new ArrayList<Phi>();
        for (PhiReader phiReader : block.readPhis()) {
            Phi phiCopy = new Phi();
            phiCopy.setReceiver(target.variableAt(phiReader.getReceiver().getIndex()));
            for (IncomingReader incomingReader : phiReader.readIncomings()) {
                Incoming incomingCopy = new Incoming();
                incomingCopy.setSource(target.basicBlockAt(incomingReader.getSource().getIndex()));
                incomingCopy.setValue(target.variableAt(incomingReader.getValue().getIndex()));
                phiCopy.getIncomings().add(incomingCopy);
            }
            result.add(phiCopy);
        }
        return result;
    }

    public static List<TryCatchBlock> copyTryCatches(BasicBlockReader block, Program target) {
        ArrayList<TryCatchBlock> result = new ArrayList<TryCatchBlock>();
        for (TryCatchBlockReader tryCatchBlockReader : block.readTryCatchBlocks()) {
            TryCatchBlock tryCatchCopy = new TryCatchBlock();
            tryCatchCopy.setExceptionType(tryCatchBlockReader.getExceptionType());
            tryCatchCopy.setHandler(target.basicBlockAt(tryCatchBlockReader.getHandler().getIndex()));
            result.add(tryCatchCopy);
        }
        return result;
    }

    public static List<List<Incoming>> getPhiOutputs(Program program) {
        int i;
        ArrayList<List<Incoming>> outputs = new ArrayList<List<Incoming>>(program.basicBlockCount());
        for (i = 0; i < program.basicBlockCount(); ++i) {
            outputs.add(new ArrayList());
        }
        for (i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlock block = program.basicBlockAt(i);
            for (Phi phi : block.getPhis()) {
                for (Incoming incoming : phi.getIncomings()) {
                    ((List)outputs.get(incoming.getSource().getIndex())).add(incoming);
                }
            }
        }
        return outputs;
    }

    public static BasicBlock[] getVariableDefinitionPlaces(Program program) {
        BasicBlock[] places = new BasicBlock[program.variableCount()];
        DefinitionExtractor defExtractor = new DefinitionExtractor();
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlock block = program.basicBlockAt(i);
            Variable exceptionVar = block.getExceptionVariable();
            if (exceptionVar != null) {
                places[exceptionVar.getIndex()] = block;
            }
            for (Phi phi : block.getPhis()) {
                places[phi.getReceiver().getIndex()] = block;
            }
            for (Instruction insn : block) {
                insn.acceptVisitor(defExtractor);
                for (Variable var : defExtractor.getDefinedVariables()) {
                    places[var.getIndex()] = block;
                }
            }
        }
        return places;
    }

    public static void makeUniqueLabels(Program program) {
        HashSet<String> occupiedLabels = new HashSet<String>();
        for (int i = 0; i < program.variableCount(); ++i) {
            Variable var = program.variableAt(i);
            if (var.getLabel() == null) continue;
            String suggestedName = var.getLabel();
            if (!occupiedLabels.add(suggestedName)) {
                int suffix = 1;
                String base = suggestedName + "_";
                while (!occupiedLabels.add(suggestedName = base + suffix++)) {
                }
            }
            var.setLabel(suggestedName);
        }
    }

    public static List<Instruction> createThrowNPEInstructions(Program program, TextLocation location) {
        ConstructInstruction newNPE = new ConstructInstruction();
        newNPE.setType(NullPointerException.class.getName());
        newNPE.setReceiver(program.createVariable());
        newNPE.setLocation(location);
        InvokeInstruction initNPE = new InvokeInstruction();
        initNPE.setType(InvocationType.SPECIAL);
        initNPE.setInstance(newNPE.getReceiver());
        initNPE.setMethod(NPE_INIT_METHOD);
        initNPE.setLocation(location);
        RaiseInstruction raise = new RaiseInstruction();
        raise.setException(newNPE.getReceiver());
        raise.setLocation(location);
        return Arrays.asList(newNPE, initNPE, raise);
    }

    public static List<Variable> getVariablesDefinedInBlock(BasicBlock block, DefinitionExtractor defExtractor) {
        ArrayList<Variable> varsDefinedInBlock = new ArrayList<Variable>();
        for (Phi phi : block.getPhis()) {
            varsDefinedInBlock.add(phi.getReceiver());
        }
        if (block.getExceptionVariable() != null) {
            varsDefinedInBlock.add(block.getExceptionVariable());
        }
        for (Instruction instruction : block) {
            instruction.acceptVisitor(defExtractor);
            Variable[] varsDefinedByInstruction = defExtractor.getDefinedVariables();
            if (varsDefinedByInstruction == null) continue;
            varsDefinedInBlock.addAll(Arrays.asList(varsDefinedByInstruction));
        }
        return varsDefinedInBlock;
    }
}

