/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.model.util;

import com.antgroup.antchain.myjava.common.MutableGraphNode;
import com.antgroup.antchain.myjava.model.BasicBlock;
import com.antgroup.antchain.myjava.model.Instruction;
import com.antgroup.antchain.myjava.model.Phi;
import com.antgroup.antchain.myjava.model.Program;
import com.antgroup.antchain.myjava.model.Variable;
import com.antgroup.antchain.myjava.model.util.DefinitionExtractor;
import com.antgroup.antchain.myjava.model.util.LivenessAnalyzer;
import com.antgroup.antchain.myjava.model.util.UsageExtractor;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

class InterferenceGraphBuilder {
    InterferenceGraphBuilder() {
    }

    public List<MutableGraphNode> build(Program program, int paramCount, LivenessAnalyzer liveness) {
        ArrayList<MutableGraphNode> nodes = new ArrayList<MutableGraphNode>();
        for (int i = 0; i < program.variableCount(); ++i) {
            nodes.add(new MutableGraphNode(i));
        }
        UsageExtractor useExtractor = new UsageExtractor();
        DefinitionExtractor defExtractor = new DefinitionExtractor();
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlock block = program.basicBlockAt(i);
            BitSet live = liveness.liveOut(i);
            for (Instruction insn = block.getLastInstruction(); insn != null; insn = insn.getPrevious()) {
                insn.acceptVisitor(useExtractor);
                insn.acceptVisitor(defExtractor);
                for (Variable var : defExtractor.getDefinedVariables()) {
                    this.connect(nodes, var.getIndex(), live);
                }
                for (Variable var : defExtractor.getDefinedVariables()) {
                    live.clear(var.getIndex());
                }
                for (Variable var : useExtractor.getUsedVariables()) {
                    live.set(var.getIndex());
                }
            }
            if (block.getExceptionVariable() != null) {
                this.connect(nodes, block.getExceptionVariable().getIndex(), live);
                live.clear(block.getExceptionVariable().getIndex());
            }
            if (block.getIndex() == 0) {
                for (int j = 0; j <= paramCount; ++j) {
                    this.connect(nodes, j, live);
                }
            }
            for (Phi phi : block.getPhis()) {
                this.connect(nodes, phi.getReceiver().getIndex(), live);
            }
        }
        return nodes;
    }

    private void connect(List<MutableGraphNode> nodes, int fromIndex, BitSet to) {
        MutableGraphNode from = nodes.get(fromIndex);
        ArrayList<MutableGraphNode> toList = new ArrayList<MutableGraphNode>(to.cardinality());
        int i = to.nextSetBit(0);
        while (i >= 0) {
            toList.add(nodes.get(i));
            i = to.nextSetBit(i + 1);
        }
        from.connectAll(toList);
    }
}

