/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.model.transformation;

import com.antgroup.antchain.myjava.model.BasicBlock;
import com.antgroup.antchain.myjava.model.Incoming;
import com.antgroup.antchain.myjava.model.Phi;
import com.antgroup.antchain.myjava.model.Program;
import com.antgroup.antchain.myjava.model.TryCatchBlock;
import com.antgroup.antchain.myjava.model.optimization.UnreachableBasicBlockEliminator;

public class NoSuchFieldCatchElimination {
    private UnreachableBasicBlockEliminator blockEliminator = new UnreachableBasicBlockEliminator();

    public void apply(Program program) {
        boolean modified = false;
        for (BasicBlock block : program.getBasicBlocks()) {
            for (int i = 0; i < block.getTryCatchBlocks().size(); ++i) {
                TryCatchBlock tryCatch = block.getTryCatchBlocks().get(i);
                if (tryCatch.getExceptionType() == null || !tryCatch.getExceptionType().equals(NoSuchFieldError.class.getName())) continue;
                this.updateTryCatchHandler(tryCatch);
                block.getTryCatchBlocks().remove(i--);
                modified = true;
            }
        }
        if (modified) {
            this.blockEliminator.optimize(program);
        }
    }

    private void updateTryCatchHandler(TryCatchBlock tryCatch) {
        for (Phi phi : tryCatch.getHandler().getPhis()) {
            for (int i = 0; i < phi.getIncomings().size(); ++i) {
                Incoming incoming = phi.getIncomings().get(i);
                if (incoming.getSource() != tryCatch.getProtectedBlock()) continue;
                phi.getIncomings().remove(i--);
            }
        }
    }
}

