/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.model.transformation;

import com.antgroup.antchain.myjava.model.BasicBlock;
import com.antgroup.antchain.myjava.model.ClassHolder;
import com.antgroup.antchain.myjava.model.ClassHolderTransformer;
import com.antgroup.antchain.myjava.model.ClassHolderTransformerContext;
import com.antgroup.antchain.myjava.model.FieldReference;
import com.antgroup.antchain.myjava.model.Instruction;
import com.antgroup.antchain.myjava.model.MethodHolder;
import com.antgroup.antchain.myjava.model.Program;
import com.antgroup.antchain.myjava.model.instructions.AssignInstruction;
import com.antgroup.antchain.myjava.model.instructions.EmptyInstruction;
import com.antgroup.antchain.myjava.model.instructions.GetFieldInstruction;
import com.antgroup.antchain.myjava.model.instructions.PutFieldInstruction;

public class ClassPatch
implements ClassHolderTransformer {
    private FieldReference platformClassField = new FieldReference("java.lang.Class", "platformClass");

    @Override
    public void transformClass(ClassHolder cls, ClassHolderTransformerContext context) {
        if (!cls.getName().equals("java.lang.Class")) {
            return;
        }
        for (MethodHolder method : cls.getMethods()) {
            this.patchProgram(method.getProgram());
        }
    }

    private void patchProgram(Program program) {
        if (program == null) {
            return;
        }
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlock block = program.basicBlockAt(i);
            for (Instruction instruction : block) {
                PutFieldInstruction putField;
                Instruction replacement;
                if (instruction instanceof GetFieldInstruction) {
                    GetFieldInstruction getField = (GetFieldInstruction)instruction;
                    if (!getField.getField().equals(this.platformClassField)) continue;
                    replacement = new AssignInstruction();
                    ((AssignInstruction)replacement).setReceiver(getField.getReceiver());
                    ((AssignInstruction)replacement).setAssignee(getField.getInstance());
                    replacement.setLocation(instruction.getLocation());
                    instruction.replace(replacement);
                    continue;
                }
                if (!(instruction instanceof PutFieldInstruction) || !(putField = (PutFieldInstruction)instruction).getField().equals(this.platformClassField)) continue;
                replacement = new EmptyInstruction();
                replacement.setLocation(instruction.getLocation());
                instruction.replace(replacement);
            }
        }
    }
}

