/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.model.optimization;

import com.antgroup.antchain.myjava.common.Graph;
import com.antgroup.antchain.myjava.model.BasicBlock;
import com.antgroup.antchain.myjava.model.Instruction;
import com.antgroup.antchain.myjava.model.InvokeDynamicInstruction;
import com.antgroup.antchain.myjava.model.MethodReader;
import com.antgroup.antchain.myjava.model.Phi;
import com.antgroup.antchain.myjava.model.Program;
import com.antgroup.antchain.myjava.model.Variable;
import com.antgroup.antchain.myjava.model.instructions.AbstractInstructionVisitor;
import com.antgroup.antchain.myjava.model.instructions.ArrayLengthInstruction;
import com.antgroup.antchain.myjava.model.instructions.AssignInstruction;
import com.antgroup.antchain.myjava.model.instructions.BinaryInstruction;
import com.antgroup.antchain.myjava.model.instructions.BoundCheckInstruction;
import com.antgroup.antchain.myjava.model.instructions.CastInstruction;
import com.antgroup.antchain.myjava.model.instructions.CastIntegerInstruction;
import com.antgroup.antchain.myjava.model.instructions.CastNumberInstruction;
import com.antgroup.antchain.myjava.model.instructions.ClassConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.CloneArrayInstruction;
import com.antgroup.antchain.myjava.model.instructions.ConstructArrayInstruction;
import com.antgroup.antchain.myjava.model.instructions.ConstructInstruction;
import com.antgroup.antchain.myjava.model.instructions.ConstructMultiArrayInstruction;
import com.antgroup.antchain.myjava.model.instructions.DoubleConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.FloatConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.GetElementInstruction;
import com.antgroup.antchain.myjava.model.instructions.GetFieldInstruction;
import com.antgroup.antchain.myjava.model.instructions.IntegerConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.InvokeInstruction;
import com.antgroup.antchain.myjava.model.instructions.IsInstanceInstruction;
import com.antgroup.antchain.myjava.model.instructions.LongConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.NegateInstruction;
import com.antgroup.antchain.myjava.model.instructions.NullCheckInstruction;
import com.antgroup.antchain.myjava.model.instructions.NullConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.StringConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.UnwrapArrayInstruction;
import com.antgroup.antchain.myjava.model.optimization.MethodOptimization;
import com.antgroup.antchain.myjava.model.optimization.MethodOptimizationContext;
import com.antgroup.antchain.myjava.model.optimization.VariableEscapeAnalyzer;
import com.antgroup.antchain.myjava.model.optimization.VariableUsageGraphBuilder;

public class UnusedVariableElimination
implements MethodOptimization {
    @Override
    public boolean optimize(MethodOptimizationContext context, Program program) {
        return this.optimize(context.getMethod(), program);
    }

    public boolean optimize(MethodReader method, Program program) {
        int i;
        Graph graph = VariableUsageGraphBuilder.build(program);
        boolean[] escaping = VariableEscapeAnalyzer.findEscapingVariables(program);
        boolean[] used = new boolean[escaping.length];
        for (int i2 = 0; i2 <= method.parameterCount(); ++i2) {
            used[i2] = true;
        }
        int[] stack = new int[graph.size() * 2];
        int top = 0;
        for (int i3 = 0; i3 < used.length; ++i3) {
            if (!escaping[i3]) continue;
            stack[top++] = i3;
        }
        while (top > 0) {
            int var;
            if (used[var = stack[--top]]) continue;
            used[var] = true;
            for (int arg : graph.incomingEdges(var)) {
                if (used[arg]) continue;
                stack[top++] = arg;
            }
        }
        InstructionOptimizer insnOptimizer = new InstructionOptimizer(used);
        for (i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlock block = program.basicBlockAt(i);
            if (block.getExceptionVariable() != null && !used[block.getExceptionVariable().getIndex()]) {
                block.setExceptionVariable(null);
            }
            for (Instruction insn : block) {
                insnOptimizer.eliminate = false;
                insn.acceptVisitor(insnOptimizer);
                if (!insnOptimizer.eliminate) continue;
                insn.delete();
            }
            for (int j = 0; j < block.getPhis().size(); ++j) {
                Phi phi = block.getPhis().get(j);
                if (used[phi.getReceiver().getIndex()]) continue;
                block.getPhis().remove(j--);
            }
        }
        for (i = 0; i < program.variableCount(); ++i) {
            if (used[i]) continue;
            program.deleteVariable(i);
        }
        program.pack();
        return false;
    }

    static class InstructionOptimizer
    extends AbstractInstructionVisitor {
        private boolean[] used;
        boolean eliminate;

        InstructionOptimizer(boolean[] used) {
            this.used = used;
        }

        private void requestUsage(Variable var) {
            if (!this.used[var.getIndex()]) {
                this.eliminate = true;
            }
        }

        @Override
        public void visit(ClassConstantInstruction insn) {
            this.requestUsage(insn.getReceiver());
        }

        @Override
        public void visit(NullConstantInstruction insn) {
            this.requestUsage(insn.getReceiver());
        }

        @Override
        public void visit(IntegerConstantInstruction insn) {
            this.requestUsage(insn.getReceiver());
        }

        @Override
        public void visit(LongConstantInstruction insn) {
            this.requestUsage(insn.getReceiver());
        }

        @Override
        public void visit(FloatConstantInstruction insn) {
            this.requestUsage(insn.getReceiver());
        }

        @Override
        public void visit(DoubleConstantInstruction insn) {
            this.requestUsage(insn.getReceiver());
        }

        @Override
        public void visit(StringConstantInstruction insn) {
            this.requestUsage(insn.getReceiver());
        }

        @Override
        public void visit(BinaryInstruction insn) {
            this.requestUsage(insn.getReceiver());
        }

        @Override
        public void visit(NegateInstruction insn) {
            this.requestUsage(insn.getReceiver());
        }

        @Override
        public void visit(AssignInstruction insn) {
            this.requestUsage(insn.getReceiver());
        }

        @Override
        public void visit(CastInstruction insn) {
            this.requestUsage(insn.getReceiver());
        }

        @Override
        public void visit(CastNumberInstruction insn) {
            this.requestUsage(insn.getReceiver());
        }

        @Override
        public void visit(CastIntegerInstruction insn) {
            this.requestUsage(insn.getReceiver());
        }

        @Override
        public void visit(ConstructArrayInstruction insn) {
            this.requestUsage(insn.getReceiver());
        }

        @Override
        public void visit(ConstructInstruction insn) {
            this.requestUsage(insn.getReceiver());
        }

        @Override
        public void visit(ConstructMultiArrayInstruction insn) {
            this.requestUsage(insn.getReceiver());
        }

        @Override
        public void visit(GetFieldInstruction insn) {
            this.requestUsage(insn.getReceiver());
        }

        @Override
        public void visit(ArrayLengthInstruction insn) {
            this.requestUsage(insn.getReceiver());
        }

        @Override
        public void visit(CloneArrayInstruction insn) {
            this.requestUsage(insn.getReceiver());
        }

        @Override
        public void visit(UnwrapArrayInstruction insn) {
            this.requestUsage(insn.getReceiver());
        }

        @Override
        public void visit(GetElementInstruction insn) {
            this.requestUsage(insn.getReceiver());
        }

        @Override
        public void visit(InvokeInstruction insn) {
            if (insn.getReceiver() != null && !this.used[insn.getReceiver().getIndex()]) {
                insn.setReceiver(null);
            }
        }

        @Override
        public void visit(InvokeDynamicInstruction insn) {
            if (insn.getReceiver() != null && !this.used[insn.getReceiver().getIndex()]) {
                insn.setReceiver(null);
            }
        }

        @Override
        public void visit(IsInstanceInstruction insn) {
            this.requestUsage(insn.getReceiver());
        }

        @Override
        public void visit(NullCheckInstruction insn) {
            this.requestUsage(insn.getReceiver());
        }

        @Override
        public void visit(BoundCheckInstruction insn) {
            this.requestUsage(insn.getReceiver());
        }
    }
}

