/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.model.optimization;

import com.antgroup.antchain.myjava.model.BasicBlockReader;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.ProgramReader;
import com.antgroup.antchain.myjava.model.VariableReader;
import com.antgroup.antchain.myjava.model.instructions.AbstractInstructionReader;
import com.antgroup.antchain.myjava.model.instructions.BinaryBranchingCondition;
import com.antgroup.antchain.myjava.model.instructions.BranchingCondition;
import com.antgroup.antchain.myjava.model.instructions.InvocationType;
import com.antgroup.antchain.myjava.model.instructions.SwitchTableEntryReader;
import com.antgroup.antchain.myjava.model.optimization.InliningContext;
import com.antgroup.antchain.myjava.model.optimization.InliningStep;
import com.antgroup.antchain.myjava.model.optimization.InliningStrategy;
import java.util.List;

public class DefaultInliningStrategy
implements InliningStrategy {
    private final int complexityThreshold;
    private final int depthThreshold;
    private final int totalComplexityThreshold;
    private final boolean onceUsedOnly;

    public DefaultInliningStrategy(int complexityThreshold, int depthThreshold, int totalComplexityThreshold, boolean onceUsedOnly) {
        this.complexityThreshold = complexityThreshold;
        this.depthThreshold = depthThreshold;
        this.totalComplexityThreshold = totalComplexityThreshold;
        this.onceUsedOnly = onceUsedOnly;
    }

    @Override
    public InliningStep start(MethodReference method, ProgramReader program) {
        Complexity complexity = DefaultInliningStrategy.getComplexity(program, null);
        if (complexity.score > this.totalComplexityThreshold) {
            return null;
        }
        ComplexityHolder complexityHolder = new ComplexityHolder();
        complexityHolder.complexity = complexity.score;
        return new InliningStepImpl(complexityHolder);
    }

    private static Complexity getComplexity(ProgramReader program, InliningContext context) {
        int complexity = 0;
        ComplexityCounter counter = new ComplexityCounter(context);
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlockReader block = program.basicBlockAt(i);
            counter.complexity = 0;
            block.readAllInstructions(counter);
            complexity += block.instructionCount() + counter.complexity;
        }
        Complexity result = new Complexity();
        result.score = complexity;
        result.callsToUsedOnceMethods = counter.callsToUsedOnceMethods;
        return result;
    }

    static class Complexity {
        int score;
        boolean callsToUsedOnceMethods;

        Complexity() {
        }
    }

    static class ComplexityCounter
    extends AbstractInstructionReader {
        InliningContext context;
        int complexity;
        boolean callsToUsedOnceMethods;

        ComplexityCounter(InliningContext context) {
            this.context = context;
        }

        @Override
        public void nop() {
            --this.complexity;
        }

        @Override
        public void assign(VariableReader receiver, VariableReader assignee) {
            --this.complexity;
        }

        @Override
        public void invoke(VariableReader receiver, VariableReader instance, MethodReference method, List<? extends VariableReader> arguments, InvocationType type) {
            ProgramReader program;
            if (type == InvocationType.SPECIAL && this.context != null && this.context.isUsedOnce(method) && !this.isTrivialCall(program = this.context.getProgram(method))) {
                this.callsToUsedOnceMethods = true;
            }
        }

        private boolean isTrivialCall(ProgramReader program) {
            if (program == null) {
                return false;
            }
            Complexity complexity = DefaultInliningStrategy.getComplexity(program, this.context);
            return complexity.score <= 1 && !complexity.callsToUsedOnceMethods;
        }

        @Override
        public void choose(VariableReader condition, List<? extends SwitchTableEntryReader> table, BasicBlockReader defaultTarget) {
            this.complexity += 2;
        }

        @Override
        public void jumpIf(BranchingCondition cond, VariableReader operand, BasicBlockReader consequent, BasicBlockReader alternative) {
            ++this.complexity;
        }

        @Override
        public void jumpIf(BinaryBranchingCondition cond, VariableReader first, VariableReader second, BasicBlockReader consequent, BasicBlockReader alternative) {
            ++this.complexity;
        }

        @Override
        public void jump(BasicBlockReader target) {
            --this.complexity;
        }

        @Override
        public void exit(VariableReader valueToReturn) {
            --this.complexity;
        }

        @Override
        public void raise(VariableReader exception) {
            --this.complexity;
        }
    }

    static class ComplexityHolder {
        int complexity;

        ComplexityHolder() {
        }
    }

    class InliningStepImpl
    implements InliningStep {
        ComplexityHolder complexityHolder;

        InliningStepImpl(ComplexityHolder complexityHolder) {
            this.complexityHolder = complexityHolder;
        }

        @Override
        public InliningStep tryInline(MethodReference method, ProgramReader program, InliningContext context) {
            if (context.getDepth() > DefaultInliningStrategy.this.depthThreshold) {
                return null;
            }
            Complexity complexity = DefaultInliningStrategy.getComplexity(program, context);
            if (DefaultInliningStrategy.this.onceUsedOnly && !context.isUsedOnce(method) && (complexity.callsToUsedOnceMethods || complexity.score > 1)) {
                return null;
            }
            if (complexity.score > DefaultInliningStrategy.this.complexityThreshold || this.complexityHolder.complexity + complexity.score > DefaultInliningStrategy.this.totalComplexityThreshold) {
                return null;
            }
            this.complexityHolder.complexity += complexity.score;
            return new InliningStepImpl(this.complexityHolder);
        }
    }
}

