/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.model.lowlevel;

import com.antgroup.antchain.myjava.model.BasicBlock;
import com.antgroup.antchain.myjava.model.Instruction;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.Phi;
import com.antgroup.antchain.myjava.model.Program;
import com.antgroup.antchain.myjava.model.ValueType;
import com.antgroup.antchain.myjava.model.Variable;
import com.antgroup.antchain.myjava.model.instructions.AbstractInstructionVisitor;
import com.antgroup.antchain.myjava.model.instructions.ArrayElementType;
import com.antgroup.antchain.myjava.model.instructions.AssignInstruction;
import com.antgroup.antchain.myjava.model.instructions.CastInstruction;
import com.antgroup.antchain.myjava.model.instructions.ClassConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.CloneArrayInstruction;
import com.antgroup.antchain.myjava.model.instructions.ConstructArrayInstruction;
import com.antgroup.antchain.myjava.model.instructions.ConstructInstruction;
import com.antgroup.antchain.myjava.model.instructions.ConstructMultiArrayInstruction;
import com.antgroup.antchain.myjava.model.instructions.InitClassInstruction;
import com.antgroup.antchain.myjava.model.instructions.InvokeInstruction;
import com.antgroup.antchain.myjava.model.instructions.MonitorEnterInstruction;
import com.antgroup.antchain.myjava.model.instructions.MonitorExitInstruction;
import com.antgroup.antchain.myjava.model.instructions.NullCheckInstruction;
import com.antgroup.antchain.myjava.model.instructions.NullConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.PutElementInstruction;
import com.antgroup.antchain.myjava.model.instructions.PutFieldInstruction;
import com.antgroup.antchain.myjava.model.instructions.StringConstantInstruction;
import com.antgroup.antchain.myjava.model.lowlevel.Characteristics;
import com.antgroup.antchain.myjava.model.util.DominatorWalker;
import com.antgroup.antchain.myjava.model.util.DominatorWalkerCallback;
import com.antgroup.antchain.myjava.model.util.DominatorWalkerContext;
import com.antgroup.antchain.myjava.runtime.GC;
import com.antgroup.antchain.myjava.runtime.RuntimeObject;
import org.teavm.hppc.IntArrayList;
import org.teavm.hppc.IntHashSet;
import org.teavm.hppc.IntSet;
import org.teavm.hppc.cursors.IntCursor;

public class WriteBarrierInsertion {
    private static final MethodReference BARRIER_METHOD = new MethodReference(GC.class, "writeBarrier", RuntimeObject.class, Void.TYPE);
    private Characteristics characteristics;

    public WriteBarrierInsertion(Characteristics characteristics) {
        this.characteristics = characteristics;
    }

    public void apply(Program program) {
        if (program.basicBlockCount() == 0) {
            return;
        }
        new DominatorWalker(program).walk(new WalkerCallbackImpl(program.variableCount()));
    }

    static class State {
        IntSet newBarriers = new IntHashSet();
        IntArrayList oldBarriers;

        State() {
        }
    }

    class WalkerCallbackImpl
    extends AbstractInstructionVisitor
    implements DominatorWalkerCallback<State> {
        private DominatorWalkerContext context;
        private boolean[] constantVariables;
        IntHashSet installedBarriers = new IntHashSet();
        State state;

        WalkerCallbackImpl(int variableCount) {
            this.constantVariables = new boolean[variableCount];
        }

        @Override
        public void setContext(DominatorWalkerContext context) {
            this.context = context;
        }

        @Override
        public State visit(BasicBlock block) {
            this.state = new State();
            if (this.context.isExceptionHandler(block.getIndex()) || !this.context.allPredecessorsVisited(block.getIndex())) {
                this.invalidateBarriers();
            } else {
                for (Phi phi : block.getPhis()) {
                    if (!phi.getIncomings().stream().allMatch(incoming -> this.installedBarriers.contains(incoming.getValue().getIndex()))) continue;
                    this.markAsInstalled(phi.getReceiver().getIndex());
                }
            }
            for (Instruction instruction : block) {
                instruction.acceptVisitor(this);
            }
            return this.state;
        }

        @Override
        public void endVisit(BasicBlock block, State state) {
            if (state.oldBarriers != null) {
                this.installedBarriers.clear();
                this.installedBarriers.addAll(state.oldBarriers);
            } else {
                for (IntCursor cursor : state.newBarriers) {
                    this.installedBarriers.remove(cursor.value);
                }
            }
        }

        @Override
        public void visit(NullConstantInstruction insn) {
            this.constantVariables[insn.getReceiver().getIndex()] = true;
        }

        @Override
        public void visit(ClassConstantInstruction insn) {
            this.constantVariables[insn.getReceiver().getIndex()] = true;
        }

        @Override
        public void visit(StringConstantInstruction insn) {
            this.constantVariables[insn.getReceiver().getIndex()] = true;
        }

        @Override
        public void visit(PutFieldInstruction insn) {
            if (insn.getInstance() != null && this.isManagedReferenceType(insn.getFieldType())) {
                this.installBarrier(insn, insn.getInstance(), insn.getValue());
            }
        }

        @Override
        public void visit(InvokeInstruction insn) {
            this.invalidateBarriers();
        }

        @Override
        public void visit(ConstructInstruction insn) {
            this.invalidateBarriers();
            this.markAsInstalled(insn.getReceiver().getIndex());
        }

        @Override
        public void visit(InitClassInstruction insn) {
            this.invalidateBarriers();
        }

        @Override
        public void visit(CloneArrayInstruction insn) {
            this.invalidateBarriers();
        }

        @Override
        public void visit(ConstructArrayInstruction insn) {
            this.invalidateBarriers();
        }

        @Override
        public void visit(ConstructMultiArrayInstruction insn) {
            this.invalidateBarriers();
        }

        @Override
        public void visit(MonitorEnterInstruction insn) {
            this.invalidateBarriers();
        }

        @Override
        public void visit(MonitorExitInstruction insn) {
            this.invalidateBarriers();
        }

        private boolean isManagedReferenceType(ValueType type) {
            if (type instanceof ValueType.Array) {
                return true;
            }
            if (type instanceof ValueType.Object) {
                return WriteBarrierInsertion.this.characteristics.isManaged(((ValueType.Object)type).getClassName());
            }
            return false;
        }

        @Override
        public void visit(PutElementInstruction insn) {
            if (insn.getType() == ArrayElementType.OBJECT) {
                this.installBarrier(insn, insn.getArray(), insn.getValue());
            }
        }

        @Override
        public void visit(AssignInstruction insn) {
            this.assign(insn.getAssignee(), insn.getReceiver());
        }

        @Override
        public void visit(CastInstruction insn) {
            this.assign(insn.getValue(), insn.getReceiver());
        }

        @Override
        public void visit(NullCheckInstruction insn) {
            this.assign(insn.getValue(), insn.getReceiver());
        }

        private void assign(Variable from, Variable to) {
            if (this.installedBarriers.contains(from.getIndex())) {
                this.markAsInstalled(to.getIndex());
            }
            if (this.constantVariables[from.getIndex()]) {
                this.constantVariables[to.getIndex()] = true;
            }
        }

        private void installBarrier(Instruction instruction, Variable variable, Variable value) {
            if (this.constantVariables[value.getIndex()]) {
                return;
            }
        }

        private boolean markAsInstalled(int index) {
            if (!this.installedBarriers.add(index)) {
                return false;
            }
            if (this.state.newBarriers != null) {
                this.state.newBarriers.add(index);
            }
            return true;
        }

        private void invalidateBarriers() {
            if (this.state.newBarriers != null) {
                this.state.oldBarriers = new IntArrayList();
                for (IntCursor cursor : this.installedBarriers) {
                    if (this.state.newBarriers.contains(cursor.value)) continue;
                    this.state.oldBarriers.add(cursor.value);
                }
                this.state.newBarriers = null;
            }
            this.installedBarriers.clear();
        }
    }
}

