/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.model.lowlevel;

import com.antgroup.antchain.myjava.model.BasicBlock;
import com.antgroup.antchain.myjava.model.Incoming;
import com.antgroup.antchain.myjava.model.Instruction;
import com.antgroup.antchain.myjava.model.MethodReader;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.Phi;
import com.antgroup.antchain.myjava.model.Program;
import com.antgroup.antchain.myjava.model.TryCatchBlock;
import com.antgroup.antchain.myjava.model.Variable;
import com.antgroup.antchain.myjava.model.instructions.ExitInstruction;
import com.antgroup.antchain.myjava.model.instructions.IntegerConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.InvocationType;
import com.antgroup.antchain.myjava.model.instructions.InvokeInstruction;
import com.antgroup.antchain.myjava.model.instructions.JumpInstruction;
import com.antgroup.antchain.myjava.model.lowlevel.CallSiteDescriptor;
import com.antgroup.antchain.myjava.model.lowlevel.Characteristics;
import com.antgroup.antchain.myjava.model.lowlevel.ExceptionHandlingShadowStackContributor;
import com.antgroup.antchain.myjava.model.lowlevel.GCShadowStackContributor;
import com.antgroup.antchain.myjava.model.util.BasicBlockMapper;
import com.antgroup.antchain.myjava.runtime.ShadowStack;
import java.util.ArrayList;

public class ShadowStackTransformer {
    private Characteristics characteristics;
    private GCShadowStackContributor gcContributor;
    private boolean exceptionHandling;
    private int callSiteIdGen;

    public ShadowStackTransformer(Characteristics characteristics, boolean exceptionHandling) {
        this.gcContributor = new GCShadowStackContributor(characteristics);
        this.characteristics = characteristics;
        this.exceptionHandling = exceptionHandling;
    }

    public void apply(Program program, MethodReader method) {
        boolean exceptions;
        if (!this.characteristics.isManaged(method.getReference())) {
            return;
        }
        int shadowStackSize = this.gcContributor.contribute(program, method);
        if (this.exceptionHandling) {
            ArrayList<CallSiteDescriptor> callSites = new ArrayList<CallSiteDescriptor>();
            ExceptionHandlingShadowStackContributor exceptionContributor = new ExceptionHandlingShadowStackContributor(this.characteristics, callSites, method.getReference(), program);
            exceptionContributor.callSiteIdGen = this.callSiteIdGen;
            exceptions = exceptionContributor.contribute();
            this.callSiteIdGen = exceptionContributor.callSiteIdGen;
            CallSiteDescriptor.save(callSites, program.getAnnotations());
        } else {
            exceptions = false;
            block0: for (BasicBlock block : program.getBasicBlocks()) {
                if (!block.getTryCatchBlocks().isEmpty()) {
                    exceptions = true;
                    break;
                }
                for (Instruction insn : block) {
                    if (!ExceptionHandlingShadowStackContributor.isCallInstruction(this.characteristics, insn)) continue;
                    exceptions = true;
                    break block0;
                }
            }
        }
        if (shadowStackSize > 0 || exceptions) {
            this.addStackAllocation(program, shadowStackSize);
            this.addStackRelease(program, shadowStackSize);
        }
    }

    private void addStackAllocation(Program program, int maxDepth) {
        BasicBlock block = program.basicBlockAt(0);
        if (!block.getTryCatchBlocks().isEmpty()) {
            this.splitFirstBlock(program);
        }
        ArrayList<Instruction> instructionsToAdd = new ArrayList<Instruction>();
        Variable sizeVariable = program.createVariable();
        IntegerConstantInstruction sizeConstant = new IntegerConstantInstruction();
        sizeConstant.setReceiver(sizeVariable);
        sizeConstant.setConstant(maxDepth);
        instructionsToAdd.add(sizeConstant);
        InvokeInstruction invocation = new InvokeInstruction();
        invocation.setType(InvocationType.SPECIAL);
        invocation.setMethod(new MethodReference(ShadowStack.class, "allocStack", Integer.TYPE, Void.TYPE));
        invocation.setArguments(sizeVariable);
        instructionsToAdd.add(invocation);
        block.addFirstAll(instructionsToAdd);
    }

    private void splitFirstBlock(Program program) {
        BasicBlock block = program.basicBlockAt(0);
        BasicBlock split = program.createBasicBlock();
        while (block.getFirstInstruction() != null) {
            Instruction instruction = block.getFirstInstruction();
            instruction.delete();
            split.add(instruction);
        }
        JumpInstruction jump = new JumpInstruction();
        jump.setLocation(split.getFirstInstruction().getLocation());
        jump.setTarget(split);
        block.add(jump);
        ArrayList<TryCatchBlock> tryCatchBlocks = new ArrayList<TryCatchBlock>(block.getTryCatchBlocks());
        block.getTryCatchBlocks().clear();
        split.getTryCatchBlocks().addAll(tryCatchBlocks);
        new BasicBlockMapper(b -> b == block ? split : b).transform(program);
    }

    private void addStackRelease(Program program, int maxDepth) {
        BasicBlock exitBlock;
        ArrayList<BasicBlock> blocks = new ArrayList<BasicBlock>();
        boolean hasResult = false;
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlock block = program.basicBlockAt(i);
            Instruction instruction = block.getLastInstruction();
            if (!(instruction instanceof ExitInstruction)) continue;
            blocks.add(block);
            if (((ExitInstruction)instruction).getValueToReturn() == null) continue;
            hasResult = true;
        }
        if (blocks.size() == 1) {
            exitBlock = (BasicBlock)blocks.get(0);
        } else {
            exitBlock = program.createBasicBlock();
            ExitInstruction exit = new ExitInstruction();
            exitBlock.add(exit);
            if (hasResult) {
                Phi phi = new Phi();
                phi.setReceiver(program.createVariable());
                exitBlock.getPhis().add(phi);
                exit.setValueToReturn(phi.getReceiver());
                for (BasicBlock block : blocks) {
                    ExitInstruction oldExit = (ExitInstruction)block.getLastInstruction();
                    Incoming incoming = new Incoming();
                    incoming.setSource(block);
                    incoming.setValue(oldExit.getValueToReturn());
                    phi.getIncomings().add(incoming);
                }
            }
            for (BasicBlock block : blocks) {
                ExitInstruction oldExit = (ExitInstruction)block.getLastInstruction();
                JumpInstruction jumpToExit = new JumpInstruction();
                jumpToExit.setTarget(exitBlock);
                jumpToExit.setLocation(oldExit.getLocation());
                jumpToExit.setLocation(oldExit.getLocation());
                block.getLastInstruction().replace(jumpToExit);
            }
        }
        ArrayList<Instruction> instructionsToAdd = new ArrayList<Instruction>();
        Variable sizeVariable = program.createVariable();
        IntegerConstantInstruction sizeConstant = new IntegerConstantInstruction();
        sizeConstant.setReceiver(sizeVariable);
        sizeConstant.setConstant(maxDepth);
        instructionsToAdd.add(sizeConstant);
        InvokeInstruction invocation = new InvokeInstruction();
        invocation.setType(InvocationType.SPECIAL);
        invocation.setMethod(new MethodReference(ShadowStack.class, "releaseStack", Integer.TYPE, Void.TYPE));
        invocation.setArguments(sizeVariable);
        instructionsToAdd.add(invocation);
        exitBlock.getLastInstruction().insertPreviousAll(instructionsToAdd);
    }
}

