/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.model.lowlevel;

import com.antgroup.antchain.myjava.model.BasicBlock;
import com.antgroup.antchain.myjava.model.Instruction;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.Program;
import com.antgroup.antchain.myjava.model.TextLocation;
import com.antgroup.antchain.myjava.model.ValueType;
import com.antgroup.antchain.myjava.model.Variable;
import com.antgroup.antchain.myjava.model.instructions.BranchingCondition;
import com.antgroup.antchain.myjava.model.instructions.BranchingInstruction;
import com.antgroup.antchain.myjava.model.instructions.ClassConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.InitClassInstruction;
import com.antgroup.antchain.myjava.model.instructions.InvocationType;
import com.antgroup.antchain.myjava.model.instructions.InvokeInstruction;
import com.antgroup.antchain.myjava.model.instructions.JumpInstruction;
import com.antgroup.antchain.myjava.model.util.BasicBlockSplitter;
import com.antgroup.antchain.myjava.runtime.Allocator;

public class ClassInitializerTransformer {
    public void transform(Program program) {
        BasicBlockSplitter splitter = new BasicBlockSplitter(program);
        int count = program.basicBlockCount();
        for (int i = 0; i < count; ++i) {
            BasicBlock next = program.basicBlockAt(i);
            block1: while (next != null) {
                BasicBlock block = next;
                next = null;
                for (Instruction instruction : block) {
                    if (!(instruction instanceof InitClassInstruction)) continue;
                    String className = ((InitClassInstruction)instruction).getClassName();
                    BasicBlock continueBlock = splitter.split(block, instruction);
                    BasicBlock initBlock = program.createBasicBlock();
                    instruction.delete();
                    initBlock.add(instruction);
                    JumpInstruction jumpToContinue = new JumpInstruction();
                    jumpToContinue.setTarget(continueBlock);
                    initBlock.add(jumpToContinue);
                    this.createInitCheck(program, block, className, continueBlock, initBlock, instruction.getLocation());
                    next = continueBlock;
                    continue block1;
                }
            }
        }
        splitter.fixProgram();
    }

    private void createInitCheck(Program program, BasicBlock block, String className, BasicBlock continueBlock, BasicBlock initBlock, TextLocation location) {
        Variable clsVariable = program.createVariable();
        Variable initializedVariable = program.createVariable();
        ClassConstantInstruction clsConstant = new ClassConstantInstruction();
        clsConstant.setReceiver(clsVariable);
        clsConstant.setConstant(ValueType.object(className));
        clsConstant.setLocation(location);
        block.add(clsConstant);
        InvokeInstruction checkInitialized = new InvokeInstruction();
        checkInitialized.setType(InvocationType.SPECIAL);
        checkInitialized.setMethod(new MethodReference(Allocator.class, "isInitialized", Class.class, Boolean.TYPE));
        checkInitialized.setArguments(clsVariable);
        checkInitialized.setReceiver(initializedVariable);
        checkInitialized.setLocation(location);
        block.add(checkInitialized);
        BranchingInstruction branching = new BranchingInstruction(BranchingCondition.NOT_EQUAL);
        branching.setOperand(initializedVariable);
        branching.setConsequent(continueBlock);
        branching.setAlternative(initBlock);
        branching.setLocation(location);
        block.add(branching);
    }
}

