/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.model.lowlevel;

import com.antgroup.antchain.myjava.model.BasicBlock;
import com.antgroup.antchain.myjava.model.Instruction;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.Program;
import com.antgroup.antchain.myjava.model.ValueType;
import com.antgroup.antchain.myjava.model.Variable;
import com.antgroup.antchain.myjava.model.instructions.ArrayLengthInstruction;
import com.antgroup.antchain.myjava.model.instructions.AssignInstruction;
import com.antgroup.antchain.myjava.model.instructions.BinaryInstruction;
import com.antgroup.antchain.myjava.model.instructions.BinaryOperation;
import com.antgroup.antchain.myjava.model.instructions.BoundCheckInstruction;
import com.antgroup.antchain.myjava.model.instructions.BranchingCondition;
import com.antgroup.antchain.myjava.model.instructions.BranchingInstruction;
import com.antgroup.antchain.myjava.model.instructions.DoubleConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.ExitInstruction;
import com.antgroup.antchain.myjava.model.instructions.FloatConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.IntegerConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.InvocationType;
import com.antgroup.antchain.myjava.model.instructions.InvokeInstruction;
import com.antgroup.antchain.myjava.model.instructions.JumpInstruction;
import com.antgroup.antchain.myjava.model.instructions.LongConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.NullCheckInstruction;
import com.antgroup.antchain.myjava.model.instructions.NullConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.NumericOperandType;
import com.antgroup.antchain.myjava.model.util.BasicBlockSplitter;
import com.antgroup.antchain.myjava.runtime.ExceptionHandling;

public class CheckInstructionTransformation {
    private BasicBlock returnBlock;
    private BasicBlock next;

    public void apply(Program program, ValueType returnType) {
        BasicBlockSplitter splitter = new BasicBlockSplitter(program);
        this.returnBlock = null;
        int count = program.basicBlockCount();
        for (int i = 0; i < count; ++i) {
            this.next = program.basicBlockAt(i);
            while (this.next != null) {
                BasicBlock block = this.next;
                this.next = null;
                for (Instruction instruction : block) {
                    if (instruction instanceof NullCheckInstruction) {
                        this.replaceNullCheck(splitter, program, (NullCheckInstruction)instruction);
                        continue;
                    }
                    if (!(instruction instanceof BoundCheckInstruction)) continue;
                    this.replaceBoundCheck(splitter, program, (BoundCheckInstruction)instruction);
                }
            }
        }
        if (this.returnBlock != null) {
            ExitInstruction fakeExit = new ExitInstruction();
            if (returnType != ValueType.VOID) {
                Variable fakeReturnVar = program.createVariable();
                this.createFakeReturnValue(this.returnBlock, fakeReturnVar, returnType);
                fakeExit.setValueToReturn(fakeReturnVar);
            }
            this.returnBlock.add(fakeExit);
        }
        splitter.fixProgram();
    }

    private void replaceNullCheck(BasicBlockSplitter splitter, Program program, NullCheckInstruction nullCheck) {
        BasicBlock block = nullCheck.getBasicBlock();
        BasicBlock continueBlock = splitter.split(block, nullCheck);
        BasicBlock throwBlock = program.createBasicBlock();
        InvokeInstruction throwNPE = new InvokeInstruction();
        throwNPE.setType(InvocationType.SPECIAL);
        throwNPE.setMethod(new MethodReference(ExceptionHandling.class, "throwNullPointerException", Void.TYPE));
        throwNPE.setLocation(nullCheck.getLocation());
        throwBlock.add(throwNPE);
        this.jumpToReturn(program, nullCheck, throwBlock);
        BranchingInstruction jumpIfNull = new BranchingInstruction(BranchingCondition.NULL);
        jumpIfNull.setOperand(nullCheck.getValue());
        jumpIfNull.setConsequent(throwBlock);
        jumpIfNull.setAlternative(continueBlock);
        jumpIfNull.setLocation(nullCheck.getLocation());
        nullCheck.replace(jumpIfNull);
        AssignInstruction assign = new AssignInstruction();
        assign.setAssignee(nullCheck.getValue());
        assign.setReceiver(nullCheck.getReceiver());
        assign.setLocation(nullCheck.getLocation());
        continueBlock.addFirst(assign);
        this.next = continueBlock;
    }

    private void replaceBoundCheck(BasicBlockSplitter splitter, Program program, BoundCheckInstruction boundCheck) {
        BasicBlock block = boundCheck.getBasicBlock();
        BasicBlock continueBlock = splitter.split(block, boundCheck);
        BasicBlock throwBlock = program.createBasicBlock();
        BasicBlock ifPositiveBlock = continueBlock;
        if (boundCheck.isLower() && boundCheck.getArray() != null) {
            ifPositiveBlock = program.createBasicBlock();
        }
        InvokeInstruction throwAIOOBE = new InvokeInstruction();
        throwAIOOBE.setType(InvocationType.SPECIAL);
        throwAIOOBE.setMethod(new MethodReference(ExceptionHandling.class, "throwArrayIndexOutOfBoundsException", Void.TYPE));
        throwAIOOBE.setLocation(boundCheck.getLocation());
        throwBlock.add(throwAIOOBE);
        this.jumpToReturn(program, boundCheck, throwBlock);
        if (boundCheck.isLower()) {
            BranchingInstruction jumpIfLess = new BranchingInstruction(BranchingCondition.LESS);
            jumpIfLess.setOperand(boundCheck.getIndex());
            jumpIfLess.setConsequent(throwBlock);
            jumpIfLess.setAlternative(ifPositiveBlock);
            jumpIfLess.setLocation(boundCheck.getLocation());
            boundCheck.replace(jumpIfLess);
        }
        if (boundCheck.getArray() != null) {
            ArrayLengthInstruction arrayLength = new ArrayLengthInstruction();
            arrayLength.setArray(boundCheck.getArray());
            arrayLength.setReceiver(program.createVariable());
            arrayLength.setLocation(boundCheck.getLocation());
            BinaryInstruction compare = new BinaryInstruction(BinaryOperation.COMPARE, NumericOperandType.INT);
            compare.setFirstOperand(boundCheck.getIndex());
            compare.setSecondOperand(arrayLength.getReceiver());
            compare.setReceiver(program.createVariable());
            compare.setLocation(boundCheck.getLocation());
            BranchingInstruction jumpIfGreater = new BranchingInstruction(BranchingCondition.GREATER_OR_EQUAL);
            jumpIfGreater.setOperand(compare.getReceiver());
            jumpIfGreater.setConsequent(throwBlock);
            jumpIfGreater.setAlternative(continueBlock);
            jumpIfGreater.setLocation(boundCheck.getLocation());
            if (boundCheck.isLower()) {
                ifPositiveBlock.add(jumpIfGreater);
            } else {
                boundCheck.replace(jumpIfGreater);
            }
            jumpIfGreater.insertPrevious(arrayLength);
            jumpIfGreater.insertPrevious(compare);
        }
        AssignInstruction assign = new AssignInstruction();
        assign.setAssignee(boundCheck.getIndex());
        assign.setReceiver(boundCheck.getReceiver());
        assign.setLocation(boundCheck.getLocation());
        continueBlock.addFirst(assign);
    }

    private void jumpToReturn(Program program, Instruction instruction, BasicBlock throwBlock) {
        if (this.returnBlock == null) {
            this.returnBlock = program.createBasicBlock();
        }
        JumpInstruction jumpToFakeReturn = new JumpInstruction();
        jumpToFakeReturn.setTarget(this.returnBlock);
        jumpToFakeReturn.setLocation(instruction.getLocation());
        throwBlock.add(jumpToFakeReturn);
    }

    private void createFakeReturnValue(BasicBlock block, Variable variable, ValueType type) {
        if (type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: 
                case BYTE: 
                case SHORT: 
                case INTEGER: 
                case CHARACTER: {
                    IntegerConstantInstruction intZero = new IntegerConstantInstruction();
                    intZero.setReceiver(variable);
                    block.add(intZero);
                    return;
                }
                case LONG: {
                    LongConstantInstruction longZero = new LongConstantInstruction();
                    longZero.setReceiver(variable);
                    block.add(longZero);
                    return;
                }
                case FLOAT: {
                    FloatConstantInstruction floatZero = new FloatConstantInstruction();
                    floatZero.setReceiver(variable);
                    block.add(floatZero);
                    return;
                }
                case DOUBLE: {
                    DoubleConstantInstruction doubleZero = new DoubleConstantInstruction();
                    doubleZero.setReceiver(variable);
                    block.add(doubleZero);
                    return;
                }
            }
        }
        NullConstantInstruction nullConstant = new NullConstantInstruction();
        nullConstant.setReceiver(variable);
        block.add(nullConstant);
    }
}

