/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.model.lowlevel;

import com.antgroup.antchain.myjava.interop.Address;
import com.antgroup.antchain.myjava.interop.Function;
import com.antgroup.antchain.myjava.interop.StaticInit;
import com.antgroup.antchain.myjava.interop.Structure;
import com.antgroup.antchain.myjava.interop.Unmanaged;
import com.antgroup.antchain.myjava.model.ClassReader;
import com.antgroup.antchain.myjava.model.ClassReaderSource;
import com.antgroup.antchain.myjava.model.MethodReader;
import com.antgroup.antchain.myjava.model.MethodReference;
import org.teavm.hppc.ObjectByteHashMap;
import org.teavm.hppc.ObjectByteMap;

public class Characteristics {
    private ClassReaderSource classSource;
    private ObjectByteMap<String> isStructure = new ObjectByteHashMap<String>();
    private ObjectByteMap<String> isStaticInit = new ObjectByteHashMap<String>();
    private ObjectByteMap<String> isFunction = new ObjectByteHashMap<String>();
    private ObjectByteMap<MethodReference> isManaged = new ObjectByteHashMap<MethodReference>();

    public Characteristics(ClassReaderSource classSource) {
        this.classSource = classSource;
    }

    public boolean isStructure(String className) {
        byte result = this.isStructure.getOrDefault(className, (byte)-1);
        if (result < 0) {
            ClassReader cls;
            result = className.equals(Structure.class.getName()) ? (byte)1 : ((cls = this.classSource.get(className)) != null && cls.getParent() != null ? (this.isStructure(cls.getParent()) ? (byte)1 : 0) : (byte)0);
            this.isStructure.put(className, result);
        }
        return result != 0;
    }

    public boolean isStaticInit(String className) {
        byte result = this.isStaticInit.getOrDefault(className, (byte)-1);
        if (result < 0) {
            ClassReader cls = this.classSource.get(className);
            result = cls != null && cls.getAnnotations().get(StaticInit.class.getName()) != null ? (byte)1 : 0;
            this.isStaticInit.put(className, result);
        }
        return result != 0;
    }

    public boolean isFunction(String className) {
        byte result = this.isFunction.getOrDefault(className, (byte)-1);
        if (result < 0) {
            ClassReader cls;
            result = className.equals(Function.class.getName()) ? (byte)1 : ((cls = this.classSource.get(className)) != null && cls.getParent() != null ? (this.isFunction(cls.getParent()) ? (byte)1 : 0) : (byte)0);
            this.isFunction.put(className, result);
        }
        return result != 0;
    }

    public boolean isManaged(String className) {
        return !this.isStructure(className) && !this.isFunction(className) && !className.equals(Address.class.getName());
    }

    public boolean isManaged(MethodReference methodReference) {
        byte result = this.isManaged.getOrDefault(methodReference, (byte)-1);
        if (result < 0) {
            result = this.computeIsManaged(methodReference) ? (byte)1 : 0;
            this.isManaged.put(methodReference, result);
        }
        return result != 0;
    }

    private boolean computeIsManaged(MethodReference methodReference) {
        MethodReader method = this.classSource.resolve(methodReference);
        if (method == null) {
            return true;
        }
        ClassReader cls = this.classSource.get(method.getOwnerName());
        if (cls.getAnnotations().get(Unmanaged.class.getName()) != null) {
            return false;
        }
        return method.getAnnotations().get(Unmanaged.class.getName()) == null;
    }
}

