/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.model.lowlevel;

import com.antgroup.antchain.myjava.model.AnnotationHolder;
import com.antgroup.antchain.myjava.model.AnnotationReader;
import com.antgroup.antchain.myjava.model.AnnotationValue;
import com.antgroup.antchain.myjava.model.InliningInfo;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.TextLocation;
import com.antgroup.antchain.myjava.model.lowlevel.CallSiteDescriptor;
import com.antgroup.antchain.myjava.model.lowlevel.CallSiteLocationAnnot;
import com.antgroup.antchain.myjava.model.lowlevel.CallSiteLocationsAnnot;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CallSiteLocation {
    private String fileName;
    private String className;
    private String methodName;
    private int lineNumber;

    public CallSiteLocation(String fileName, String className, String methodName, int lineNumber) {
        this.fileName = fileName;
        this.className = className;
        this.methodName = methodName;
        this.lineNumber = lineNumber;
    }

    public static CallSiteLocation[] fromTextLocation(TextLocation location, MethodReference callingMethod) {
        InliningInfo inlining;
        if (location == null) {
            return new CallSiteLocation[]{new CallSiteLocation("", callingMethod.getClassName(), callingMethod.getName(), -1)};
        }
        if (location.getInlining() == null) {
            return new CallSiteLocation[]{new CallSiteLocation(CallSiteLocation.convertFileName(location.getFileName()), callingMethod.getClassName(), callingMethod.getName(), location.getLine())};
        }
        ArrayList<CallSiteLocation> result = new ArrayList<CallSiteLocation>();
        result.add(new CallSiteLocation(CallSiteLocation.convertFileName(location.getFileName()), inlining.getMethod().getClassName(), inlining.getMethod().getName(), location.getLine()));
        for (inlining = location.getInlining(); inlining != null; inlining = inlining.getParent()) {
            MethodReference method = inlining.getParent() != null ? inlining.getParent().getMethod() : callingMethod;
            result.add(new CallSiteLocation(CallSiteLocation.convertFileName(inlining.getFileName()), method.getClassName(), method.getName(), inlining.getLine()));
        }
        return result.toArray(new CallSiteLocation[0]);
    }

    private static String convertFileName(String fileName) {
        if (fileName != null) {
            fileName = fileName.substring(fileName.lastIndexOf(47) + 1);
        }
        return fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CallSiteLocation)) {
            return false;
        }
        CallSiteLocation other = (CallSiteLocation)obj;
        return Objects.equals(this.fileName, other.fileName) && Objects.equals(this.className, other.className) && Objects.equals(this.methodName, other.methodName) && this.lineNumber == other.lineNumber;
    }

    public int hashCode() {
        return Objects.hash(this.fileName, this.className, this.methodName, this.lineNumber);
    }

    public AnnotationReader save() {
        AnnotationHolder annotation = new AnnotationHolder(CallSiteLocationAnnot.class.getName());
        annotation.getValues().put("fileName", CallSiteDescriptor.saveNullableString(this.fileName));
        annotation.getValues().put("className", CallSiteDescriptor.saveNullableString(this.className));
        annotation.getValues().put("methodName", CallSiteDescriptor.saveNullableString(this.methodName));
        annotation.getValues().put("lineNumber", new AnnotationValue(this.lineNumber));
        return annotation;
    }

    public static CallSiteLocation load(AnnotationReader reader) {
        return new CallSiteLocation(CallSiteDescriptor.loadNullableString(reader.getValue("fileName")), CallSiteDescriptor.loadNullableString(reader.getValue("className")), CallSiteDescriptor.loadNullableString(reader.getValue("methodName")), reader.getValue("lineNumber").getInt());
    }

    public static AnnotationReader saveMany(List<? extends CallSiteLocation> locations) {
        AnnotationHolder annotation = new AnnotationHolder(CallSiteLocationsAnnot.class.getName());
        ArrayList<AnnotationValue> list = new ArrayList<AnnotationValue>();
        for (CallSiteLocation callSiteLocation : locations) {
            list.add(new AnnotationValue(callSiteLocation.save()));
        }
        annotation.getValues().put("value", new AnnotationValue(list));
        return annotation;
    }

    public static List<? extends CallSiteLocation> loadMany(AnnotationReader reader) {
        ArrayList<CallSiteLocation> result = new ArrayList<CallSiteLocation>();
        for (AnnotationValue item : reader.getValue("value").getList()) {
            result.add(CallSiteLocation.load(item.getAnnotation()));
        }
        return result;
    }
}

