/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.model.emit;

import com.antgroup.antchain.myjava.model.BasicBlock;
import com.antgroup.antchain.myjava.model.ClassHierarchy;
import com.antgroup.antchain.myjava.model.ClassReader;
import com.antgroup.antchain.myjava.model.ClassReaderSource;
import com.antgroup.antchain.myjava.model.FieldReader;
import com.antgroup.antchain.myjava.model.FieldReference;
import com.antgroup.antchain.myjava.model.Instruction;
import com.antgroup.antchain.myjava.model.MethodDescriptor;
import com.antgroup.antchain.myjava.model.MethodHolder;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.Phi;
import com.antgroup.antchain.myjava.model.Program;
import com.antgroup.antchain.myjava.model.TextLocation;
import com.antgroup.antchain.myjava.model.ValueType;
import com.antgroup.antchain.myjava.model.Variable;
import com.antgroup.antchain.myjava.model.emit.ChooseEmitter;
import com.antgroup.antchain.myjava.model.emit.ConditionEmitter;
import com.antgroup.antchain.myjava.model.emit.ConditionProducer;
import com.antgroup.antchain.myjava.model.emit.EmitException;
import com.antgroup.antchain.myjava.model.emit.FragmentEmitter;
import com.antgroup.antchain.myjava.model.emit.IfEmitter;
import com.antgroup.antchain.myjava.model.emit.PhiEmitter;
import com.antgroup.antchain.myjava.model.emit.StringBuilderEmitter;
import com.antgroup.antchain.myjava.model.emit.StringChooseEmitter;
import com.antgroup.antchain.myjava.model.emit.ValueEmitter;
import com.antgroup.antchain.myjava.model.instructions.ClassConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.ConstructArrayInstruction;
import com.antgroup.antchain.myjava.model.instructions.ConstructInstruction;
import com.antgroup.antchain.myjava.model.instructions.DoubleConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.ExitInstruction;
import com.antgroup.antchain.myjava.model.instructions.FloatConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.GetFieldInstruction;
import com.antgroup.antchain.myjava.model.instructions.InitClassInstruction;
import com.antgroup.antchain.myjava.model.instructions.IntegerConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.InvocationType;
import com.antgroup.antchain.myjava.model.instructions.InvokeInstruction;
import com.antgroup.antchain.myjava.model.instructions.JumpInstruction;
import com.antgroup.antchain.myjava.model.instructions.LongConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.NullConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.PutFieldInstruction;
import com.antgroup.antchain.myjava.model.instructions.StringConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.SwitchInstruction;
import com.antgroup.antchain.myjava.model.util.TransitionExtractor;

public final class ProgramEmitter {
    private Program program;
    private BasicBlock block;
    ClassReaderSource classSource;
    ClassHierarchy hierarchy;
    private TextLocation currentLocation;

    private ProgramEmitter(Program program, BasicBlock block, ClassHierarchy hierarchy) {
        this.program = program;
        this.block = block;
        this.classSource = hierarchy.getClassSource();
        this.hierarchy = hierarchy;
    }

    public Program getProgram() {
        return this.program;
    }

    public BasicBlock getBlock() {
        return this.block;
    }

    public ProgramEmitter enter(BasicBlock block) {
        this.block = block;
        return this;
    }

    public BasicBlock prepareBlock() {
        return this.program.createBasicBlock();
    }

    public ValueEmitter constant(Class<?> cls) {
        return this.constant(ValueType.parse(cls));
    }

    public ValueEmitter constant(ValueType value) {
        Variable var = this.program.createVariable();
        ClassConstantInstruction insn = new ClassConstantInstruction();
        insn.setReceiver(var);
        insn.setConstant(value);
        this.addInstruction(insn);
        return this.var(var, (ValueType)ValueType.object("java.lang.Class"));
    }

    public ValueEmitter constant(String value) {
        Variable var = this.program.createVariable();
        StringConstantInstruction insn = new StringConstantInstruction();
        insn.setReceiver(var);
        insn.setConstant(value);
        this.addInstruction(insn);
        return this.var(var, (ValueType)ValueType.object("java.lang.String"));
    }

    public ValueEmitter constant(int value) {
        Variable var = this.program.createVariable();
        IntegerConstantInstruction insn = new IntegerConstantInstruction();
        insn.setReceiver(var);
        insn.setConstant(value);
        this.addInstruction(insn);
        return this.var(var, (ValueType)ValueType.INTEGER);
    }

    public ValueEmitter constant(long value) {
        Variable var = this.program.createVariable();
        LongConstantInstruction insn = new LongConstantInstruction();
        insn.setReceiver(var);
        insn.setConstant(value);
        this.addInstruction(insn);
        return this.var(var, (ValueType)ValueType.LONG);
    }

    public ValueEmitter constant(float value) {
        Variable var = this.program.createVariable();
        FloatConstantInstruction insn = new FloatConstantInstruction();
        insn.setReceiver(var);
        insn.setConstant(value);
        this.addInstruction(insn);
        return this.var(var, (ValueType)ValueType.FLOAT);
    }

    public ValueEmitter constant(double value) {
        Variable var = this.program.createVariable();
        DoubleConstantInstruction insn = new DoubleConstantInstruction();
        insn.setReceiver(var);
        insn.setConstant(value);
        this.addInstruction(insn);
        return this.var(var, (ValueType)ValueType.DOUBLE);
    }

    public ValueEmitter constantNull(ValueType type) {
        Variable var = this.program.createVariable();
        NullConstantInstruction insn = new NullConstantInstruction();
        insn.setReceiver(var);
        this.addInstruction(insn);
        return this.var(var, type);
    }

    public ValueEmitter constantNull(Class<?> type) {
        return this.constantNull(ValueType.parse(type));
    }

    public ValueEmitter defaultValue(ValueType type) {
        if (type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: {
                    return this.constant(0).cast(Boolean.TYPE);
                }
                case BYTE: {
                    return this.constant(0).cast(Byte.TYPE);
                }
                case SHORT: {
                    return this.constant(0).cast(Short.TYPE);
                }
                case CHARACTER: {
                    return this.constant(0).cast(Character.TYPE);
                }
                case INTEGER: {
                    return this.constant(0);
                }
                case LONG: {
                    return this.constant(0L);
                }
                case FLOAT: {
                    return this.constant(0.0f);
                }
                case DOUBLE: {
                    return this.constant(0.0);
                }
            }
        }
        return this.constantNull(type);
    }

    public ValueEmitter getField(FieldReference field, ValueType type) {
        FieldReader resolvedField = this.hierarchy.resolve(field);
        if (resolvedField != null) {
            field = resolvedField.getReference();
        }
        Variable var = this.program.createVariable();
        GetFieldInstruction insn = new GetFieldInstruction();
        insn.setField(field);
        insn.setFieldType(type);
        insn.setReceiver(var);
        this.addInstruction(insn);
        return this.var(var, type);
    }

    public ValueEmitter getField(String className, String fieldName, ValueType type) {
        return this.getField(new FieldReference(className, fieldName), type);
    }

    public ValueEmitter getField(Class<?> cls, String fieldName, Class<?> type) {
        return this.getField(cls.getName(), fieldName, ValueType.parse(type));
    }

    public ProgramEmitter setField(FieldReference field, ValueEmitter value) {
        FieldReader resolvedField = this.hierarchy.resolve(field);
        if (resolvedField != null) {
            field = resolvedField.getReference();
        }
        PutFieldInstruction insn = new PutFieldInstruction();
        insn.setField(field);
        insn.setFieldType(value.type);
        insn.setValue(value.getVariable());
        this.addInstruction(insn);
        return this;
    }

    public ProgramEmitter setField(String className, String fieldName, ValueEmitter value) {
        return this.setField(new FieldReference(className, fieldName), value);
    }

    public ProgramEmitter setField(Class<?> cls, String fieldName, ValueEmitter value) {
        return this.setField(new FieldReference(cls.getName(), fieldName), value);
    }

    public ValueEmitter invoke(MethodReference method, ValueEmitter ... arguments) {
        for (int i = 0; i < method.parameterCount(); ++i) {
            if (this.hierarchy.isSuperType(method.parameterType(i), arguments[i].getType(), true)) continue;
            throw new EmitException("Argument " + i + " of type " + arguments[i].getType() + " is not compatible with method " + method);
        }
        Variable result = null;
        if (method.getReturnType() != ValueType.VOID) {
            result = this.program.createVariable();
        }
        InvokeInstruction insn = new InvokeInstruction();
        insn.setType(InvocationType.SPECIAL);
        insn.setMethod(method);
        insn.setReceiver(result);
        Variable[] insnArguments = new Variable[arguments.length];
        for (int i = 0; i < insnArguments.length; ++i) {
            insnArguments[i] = arguments[i].variable;
        }
        insn.setArguments(insnArguments);
        this.addInstruction(insn);
        return result != null ? this.var(result, method.getReturnType()) : null;
    }

    public ValueEmitter invoke(String className, String methodName, ValueType resultType, ValueEmitter ... arguments) {
        Variable result = null;
        if (resultType != ValueType.VOID) {
            result = this.program.createVariable();
        }
        ValueType[] argumentTypes = new ValueType[arguments.length + 1];
        for (int i = 0; i < arguments.length; ++i) {
            argumentTypes[i] = arguments[i].type;
        }
        argumentTypes[arguments.length] = resultType;
        MethodReference method = new MethodReference(className, methodName, argumentTypes);
        InvokeInstruction insn = new InvokeInstruction();
        insn.setType(InvocationType.SPECIAL);
        insn.setMethod(method);
        insn.setReceiver(result);
        Variable[] insnArguments = new Variable[arguments.length];
        for (int i = 0; i < insnArguments.length; ++i) {
            insnArguments[i] = arguments[i].variable;
        }
        insn.setArguments(insnArguments);
        this.addInstruction(insn);
        return result != null ? this.var(result, resultType) : null;
    }

    public ValueEmitter invoke(Class<?> cls, String methodName, Class<?> resultType, ValueEmitter ... arguments) {
        return this.invoke(cls.getName(), methodName, ValueType.parse(resultType), arguments);
    }

    public ProgramEmitter invoke(String className, String methodName, ValueEmitter ... arguments) {
        this.invoke(className, methodName, ValueType.VOID, arguments);
        return this;
    }

    public ProgramEmitter invoke(Class<?> cls, String methodName, ValueEmitter ... arguments) {
        return this.invoke(cls.getName(), methodName, arguments);
    }

    public ValueEmitter construct(String className, ValueEmitter ... arguments) {
        Variable var = this.program.createVariable();
        ConstructInstruction insn = new ConstructInstruction();
        insn.setReceiver(var);
        insn.setType(className);
        this.addInstruction(insn);
        ValueEmitter instance = this.var(var, (ValueType)ValueType.object(className));
        instance.invokeSpecial("<init>", Void.TYPE, arguments);
        return instance;
    }

    public ValueEmitter construct(Class<?> cls, ValueEmitter ... arguments) {
        return this.construct(cls.getName(), arguments);
    }

    public ValueEmitter constructArray(ValueType type, ValueEmitter size) {
        Variable var = this.program.createVariable();
        ConstructArrayInstruction insn = new ConstructArrayInstruction();
        insn.setReceiver(var);
        insn.setSize(size.getVariable());
        insn.setItemType(type);
        this.addInstruction(insn);
        return this.var(var, ValueType.arrayOf(type));
    }

    public ValueEmitter constructArray(ValueType type, int size) {
        return this.constructArray(type, this.constant(size));
    }

    public ValueEmitter constructArray(Class<?> type, int size) {
        return this.constructArray(ValueType.parse(type), size);
    }

    public ValueEmitter constructArray(Class<?> type, ValueEmitter size) {
        return this.constructArray(ValueType.parse(type), size);
    }

    public ProgramEmitter initClass(String className) {
        InitClassInstruction insn = new InitClassInstruction();
        insn.setClassName(className);
        this.addInstruction(insn);
        return this;
    }

    public ProgramEmitter jump(BasicBlock block) {
        JumpInstruction insn = new JumpInstruction();
        insn.setTarget(block);
        this.addInstruction(insn);
        return this;
    }

    public void exit() {
        ExitInstruction insn = new ExitInstruction();
        this.addInstruction(insn);
    }

    public ValueEmitter var(Variable var, ValueType type) {
        return new ValueEmitter(this, this.block, var, type);
    }

    public ValueEmitter var(Variable var, Class<?> type) {
        return this.var(var, ValueType.parse(type));
    }

    public ValueEmitter var(Variable var, ClassReader type) {
        return this.var(var, (ValueType)ValueType.object(type.getName()));
    }

    public ValueEmitter var(int var, ValueType type) {
        return new ValueEmitter(this, this.block, this.program.variableAt(var), type);
    }

    public ValueEmitter var(int var, Class<?> type) {
        return this.var(var, ValueType.parse(type));
    }

    public ValueEmitter var(int var, ClassReader type) {
        return this.var(var, (ValueType)ValueType.object(type.getName()));
    }

    public ValueEmitter newVar(ValueType type) {
        return this.var(this.program.createVariable(), type);
    }

    public ValueEmitter newVar(ClassReader cls) {
        return this.var(this.program.createVariable(), (ValueType)ValueType.object(cls.getName()));
    }

    public ValueEmitter newVar(Class<?> type) {
        return this.var(this.program.createVariable(), type);
    }

    public TextLocation getCurrentLocation() {
        return this.currentLocation;
    }

    public void setCurrentLocation(TextLocation currentLocation) {
        this.currentLocation = currentLocation;
    }

    public void addInstruction(Instruction insn) {
        if (this.escapes()) {
            throw new EmitException("This block has already escaped");
        }
        if (this.currentLocation != null) {
            insn.setLocation(this.currentLocation);
        }
        this.block.add(insn);
    }

    public static ProgramEmitter create(MethodHolder method, ClassHierarchy classSource) {
        ProgramEmitter pe = ProgramEmitter.create(method.getDescriptor(), classSource);
        method.setProgram(pe.getProgram());
        return pe;
    }

    public static ProgramEmitter create(MethodDescriptor method, ClassHierarchy classSource) {
        Program program = new Program();
        BasicBlock zeroBlock = program.createBasicBlock();
        BasicBlock block = program.createBasicBlock();
        JumpInstruction insn = new JumpInstruction();
        insn.setTarget(block);
        zeroBlock.add(insn);
        program.createVariable();
        for (int i = 0; i < method.parameterCount(); ++i) {
            program.createVariable();
        }
        return new ProgramEmitter(program, block, classSource);
    }

    public IfEmitter when(ConditionEmitter cond) {
        return new IfEmitter(this, cond.fork, this.prepareBlock());
    }

    public IfEmitter when(ConditionProducer cond) {
        return this.when(cond.produce());
    }

    public PhiEmitter phi(ValueType type, BasicBlock block) {
        ValueEmitter value = this.newVar(type);
        Phi phi = new Phi();
        phi.setReceiver(value.getVariable());
        block.getPhis().add(phi);
        return new PhiEmitter(phi, value);
    }

    public PhiEmitter phi(Class<?> cls, BasicBlock block) {
        return this.phi(ValueType.parse(cls), block);
    }

    public PhiEmitter phi(ClassReader cls, BasicBlock block) {
        return this.phi(ValueType.object(cls.getName()), block);
    }

    public PhiEmitter phi(ValueType type) {
        return this.phi(type, this.block);
    }

    public PhiEmitter phi(Class<?> cls) {
        return this.phi(ValueType.parse(cls));
    }

    public PhiEmitter phi(ClassReader cls) {
        return this.phi(ValueType.object(cls.getName()));
    }

    public ChooseEmitter choice(ValueEmitter value) {
        SwitchInstruction insn = new SwitchInstruction();
        insn.setCondition(value.getVariable());
        this.addInstruction(insn);
        return new ChooseEmitter(this, insn, this.prepareBlock());
    }

    public StringChooseEmitter stringChoice(ValueEmitter value) {
        SwitchInstruction insn = new SwitchInstruction();
        return new StringChooseEmitter(this, value, insn, this.prepareBlock());
    }

    public ClassReaderSource getClassSource() {
        return this.classSource;
    }

    public boolean escapes() {
        Instruction insn = this.block.getLastInstruction();
        if (insn == null) {
            return false;
        }
        TransitionExtractor extractor = new TransitionExtractor();
        insn.acceptVisitor(extractor);
        return extractor.getTargets() != null;
    }

    public void emitAndJump(FragmentEmitter fragment, BasicBlock block) {
        fragment.emit();
        if (!this.escapes()) {
            this.jump(block);
        }
    }

    public StringBuilderEmitter string() {
        return new StringBuilderEmitter(this);
    }

    public static ProgramEmitter create(Program program, ClassHierarchy classSource) {
        return new ProgramEmitter(program, null, classSource);
    }
}

