/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.model.classes;

import com.antgroup.antchain.myjava.model.ClassHierarchy;
import com.antgroup.antchain.myjava.model.ClassReader;
import com.antgroup.antchain.myjava.model.ElementModifier;
import com.antgroup.antchain.myjava.model.ListableClassReaderSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class TagRegistry {
    private Map<String, List<Range>> ranges = new HashMap<String, List<Range>>();

    public TagRegistry(ListableClassReaderSource classSource, ClassHierarchy classHierarchy) {
        ArrayList<String> roots = new ArrayList<String>();
        HashMap<String, Set<String>> implementedBy = new HashMap<String, Set<String>>();
        HashMap<String, List<String>> hierarchy = new HashMap<String, List<String>>();
        for (String className : classSource.getClassNames()) {
            ClassReader cls = classSource.get(className);
            if (cls == null || cls.hasModifier(ElementModifier.INTERFACE)) continue;
            for (String iface : cls.getInterfaces()) {
                this.markImplementor(classHierarchy, className, iface, implementedBy);
            }
            if (cls.getParent() == null || cls.getParent().equals(cls.getName())) {
                roots.add(className);
                continue;
            }
            hierarchy.computeIfAbsent(cls.getParent(), key -> new ArrayList()).add(className);
        }
        HashMap<String, Range> simpleRanges = new HashMap<String, Range>();
        int current = 0;
        for (String root : roots) {
            current = 1 + this.assignRange(current, hierarchy, root, simpleRanges);
        }
        for (String className : classSource.getClassNames()) {
            ClassReader cls = classSource.get(className);
            if (cls == null) continue;
            if (cls.hasModifier(ElementModifier.INTERFACE)) {
                Set implementorRoots = (Set)implementedBy.get(cls.getName());
                if (implementorRoots == null) continue;
                List ifaceRanges = implementorRoots.stream().map(simpleRanges::get).filter(Objects::nonNull).sorted(Comparator.comparing(range -> range.lower)).collect(Collectors.toList());
                if (ifaceRanges.isEmpty()) continue;
                this.ranges.put(className, ifaceRanges);
                continue;
            }
            Range simpleRange = (Range)simpleRanges.get(className);
            if (simpleRange == null) continue;
            this.ranges.put(className, new ArrayList<Range>(Arrays.asList(simpleRange)));
        }
    }

    private String findTopmostImplementor(ClassHierarchy hierarchy, String className, String ifaceName) {
        String candidate;
        ClassReader cls = hierarchy.getClassSource().get(className);
        if (cls == null) {
            return null;
        }
        if (cls.getParent() != null && (candidate = this.findTopmostImplementor(hierarchy, cls.getParent(), ifaceName)) != null) {
            return candidate;
        }
        return hierarchy.isSuperType(ifaceName, className, false) ? className : null;
    }

    private void markImplementor(ClassHierarchy hierarchy, String className, String ifaceName, Map<String, Set<String>> implementedBy) {
        className = this.findTopmostImplementor(hierarchy, className, ifaceName);
        if (!implementedBy.computeIfAbsent(ifaceName, key -> new LinkedHashSet()).add(className)) {
            return;
        }
        ClassReader iface = hierarchy.getClassSource().get(ifaceName);
        if (iface == null) {
            return;
        }
        for (String superIface : iface.getInterfaces()) {
            this.markImplementor(hierarchy, className, superIface, implementedBy);
        }
    }

    private int assignRange(int start, Map<String, List<String>> hierarchy, String className, Map<String, Range> ranges) {
        int end = start + 1;
        for (String childClass : hierarchy.getOrDefault(className, Collections.emptyList())) {
            end = this.assignRange(end, hierarchy, childClass, ranges);
        }
        ranges.put(className, new Range(start, ++end));
        return end;
    }

    public List<Range> getRanges(String className) {
        return new ArrayList<Range>(this.ranges.getOrDefault(className, Collections.emptyList()));
    }

    public static class Range {
        public int lower;
        public int upper;

        private Range(int lower, int upper) {
            this.lower = lower;
            this.upper = upper;
        }
    }
}

