/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.model.analysis;

import com.antgroup.antchain.myjava.model.AccessLevel;
import com.antgroup.antchain.myjava.model.ClassReader;
import com.antgroup.antchain.myjava.model.ClassReaderSource;
import com.antgroup.antchain.myjava.model.ElementModifier;
import com.antgroup.antchain.myjava.model.MethodDescriptor;
import com.antgroup.antchain.myjava.model.MethodReader;
import com.antgroup.antchain.myjava.model.MethodReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class SubclassListProvider {
    private Map<String, ClassInfo> classes = new HashMap<String, ClassInfo>();
    private Map<MethodDescriptor, List<MethodReference>> methodImplementations = new HashMap<MethodDescriptor, List<MethodReference>>();
    private int limit;

    SubclassListProvider(ClassReaderSource classSource, Iterable<? extends String> classNames, int limit) {
        this.limit = limit;
        for (String string : classNames) {
            this.registerClass(classSource, string);
        }
    }

    private ClassInfo registerClass(ClassReaderSource classSource, String className) {
        ClassInfo classInfo = this.classes.get(className);
        if (classInfo == null) {
            classInfo = new ClassInfo();
            this.classes.put(className, classInfo);
            ClassReader cls = classSource.get(className);
            if (cls != null) {
                if (!cls.hasModifier(ElementModifier.INTERFACE) && !cls.hasModifier(ElementModifier.ABSTRACT)) {
                    classInfo.concrete = true;
                }
                this.increaseClassCount(classSource, className, new HashSet<String>(), classInfo.concrete);
                if (cls.getParent() != null) {
                    ClassInfo parentInfo = this.registerClass(classSource, cls.getParent());
                    if (parentInfo.directSubclasses == null) {
                        parentInfo.directSubclasses = new ArrayList<String>();
                    }
                    parentInfo.directSubclasses.add(className);
                }
                for (String string : cls.getInterfaces()) {
                    ClassInfo parentInfo = this.registerClass(classSource, string);
                    if (parentInfo.directSubclasses == null) {
                        parentInfo.directSubclasses = new ArrayList<String>();
                    }
                    parentInfo.directSubclasses.add(className);
                }
                for (MethodReader methodReader : cls.getMethods()) {
                    if (methodReader.hasModifier(ElementModifier.STATIC) || methodReader.hasModifier(ElementModifier.ABSTRACT) || methodReader.getLevel() == AccessLevel.PRIVATE) continue;
                    List<MethodReference> implementations = this.methodImplementations.get(methodReader.getDescriptor());
                    if (implementations == null) {
                        implementations = new ArrayList<MethodReference>();
                        this.methodImplementations.put(methodReader.getDescriptor(), implementations);
                    }
                    implementations.add(methodReader.getReference());
                }
            }
        }
        return classInfo;
    }

    private void increaseClassCount(ClassReaderSource classSource, String className, Set<String> visited, boolean concrete) {
        ClassReader cls;
        if (!visited.add(className)) {
            return;
        }
        ClassInfo classInfo = this.registerClass(classSource, className);
        if (!(concrete && classInfo.concreteCount <= this.limit || classInfo.count <= this.limit)) {
            return;
        }
        ++classInfo.count;
        if (concrete) {
            ++classInfo.concreteCount;
        }
        if ((cls = classSource.get(className)) != null) {
            if (cls.getParent() != null) {
                this.increaseClassCount(classSource, cls.getParent(), visited, concrete);
            }
            for (String itf : cls.getInterfaces()) {
                this.increaseClassCount(classSource, itf, visited, concrete);
            }
        }
    }

    List<? extends String> getSubclasses(String className, boolean includeAbstract) {
        ClassInfo classInfo = this.classes.get(className);
        if (classInfo == null) {
            return null;
        }
        if (includeAbstract ? classInfo.count > this.limit : classInfo.concreteCount > this.limit) {
            return null;
        }
        String[] result = new String[includeAbstract ? classInfo.count : classInfo.concreteCount];
        this.collectSubclasses(className, result, 0, new HashSet<String>(), includeAbstract);
        return Arrays.asList(result);
    }

    List<? extends MethodReference> getMethods(MethodDescriptor descriptor) {
        return this.methodImplementations.get(descriptor);
    }

    private int collectSubclasses(String className, String[] consumer, int index, Set<String> visited, boolean includeAbstract) {
        if (!visited.add(className)) {
            return index;
        }
        ClassInfo classInfo = this.classes.get(className);
        if (classInfo == null) {
            return index;
        }
        if (includeAbstract || classInfo.concrete) {
            consumer[index++] = className;
        }
        if (classInfo.directSubclasses != null) {
            for (String subclassName : classInfo.directSubclasses) {
                index = this.collectSubclasses(subclassName, consumer, index, visited, includeAbstract);
            }
        }
        return index;
    }

    static class ClassInfo {
        int count;
        int concreteCount;
        boolean concrete;
        List<String> directSubclasses;

        ClassInfo() {
        }
    }
}

