/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.model;

import com.antgroup.antchain.myjava.model.InliningInfo;
import java.io.Serializable;
import java.util.Objects;

public class TextLocation
implements Serializable {
    public static final TextLocation EMPTY = new TextLocation(null, -1);
    private static final InliningInfo[] EMPTY_ARRAY = new InliningInfo[0];
    private String fileName;
    private int line;
    private InliningInfo inlining;
    private transient int hash;

    public TextLocation(String fileName, int line) {
        this(fileName, line, null);
    }

    public TextLocation(String fileName, int line, InliningInfo inlining) {
        this.fileName = fileName;
        this.line = line;
        this.inlining = inlining;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLine() {
        return this.line;
    }

    public InliningInfo getInlining() {
        return this.inlining;
    }

    public InliningInfo[] getInliningPath() {
        InliningInfo inlining;
        if (this.inlining == null) {
            return EMPTY_ARRAY;
        }
        int sz = 0;
        for (inlining = this.inlining; inlining != null; inlining = inlining.getParent()) {
            ++sz;
        }
        InliningInfo[] result = new InliningInfo[sz];
        for (inlining = this.inlining; inlining != null; inlining = inlining.getParent()) {
            result[--sz] = inlining;
        }
        return result;
    }

    public boolean isEmpty() {
        return this.fileName == null && this.line < 0;
    }

    public int hashCode() {
        int result = this.hash;
        if (result == 0) {
            int prime = 31;
            result = 1;
            result = 31 * result + (this.fileName == null ? 0 : this.fileName.hashCode());
            result = 31 * result + this.line;
            this.hash = result = 31 * result + (this.inlining != null ? this.inlining.hashCode() : 0);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TextLocation)) {
            return false;
        }
        TextLocation other = (TextLocation)obj;
        return Objects.equals(this.fileName, other.fileName) && this.line == other.line && Objects.equals(this.inlining, other.inlining);
    }

    public String toString() {
        InliningInfo inlining;
        StringBuilder sb = new StringBuilder();
        sb.append(this.fileName).append(':').append(this.line);
        if (inlining != null) {
            sb.append('[');
            boolean first = true;
            for (inlining = this.inlining; inlining != null; inlining = inlining.getParent()) {
                if (!first) {
                    sb.append("->");
                }
                first = false;
                sb.append(inlining.getMethod()).append("@").append(inlining.getFileName()).append(':').append(inlining.getLine());
            }
            sb.append(']');
        }
        return sb.toString();
    }
}

