/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.model;

import com.antgroup.antchain.myjava.model.ClassHolder;
import com.antgroup.antchain.myjava.model.ClassHolderSource;
import com.antgroup.antchain.myjava.model.MethodHolder;
import com.antgroup.antchain.myjava.model.optimization.GlobalValueNumbering;
import com.antgroup.antchain.myjava.model.optimization.UnusedVariableElimination;
import com.antgroup.antchain.myjava.model.transformation.NoSuchFieldCatchElimination;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;

public class PreOptimizingClassHolderSource
implements ClassHolderSource {
    private ClassHolderSource innerClassSource;
    private Map<String, ClassHolder> cache = new LinkedHashMap<String, ClassHolder>();

    public PreOptimizingClassHolderSource(ClassHolderSource innerClassSource) {
        this.innerClassSource = innerClassSource;
    }

    @Override
    public ClassHolder get(String name) {
        ClassHolder cls = this.cache.get(name);
        if (cls == null) {
            cls = PreOptimizingClassHolderSource.optimize(this.innerClassSource::get, name);
            if (cls == null) {
                return null;
            }
            this.cache.put(name, cls);
        }
        return cls;
    }

    public static ClassHolder optimize(Function<String, ClassHolder> innerSource, String name) {
        ClassHolder cls = innerSource.apply(name);
        if (cls == null) {
            return cls;
        }
        NoSuchFieldCatchElimination noSuchFieldCatchElimination = new NoSuchFieldCatchElimination();
        for (MethodHolder method : cls.getMethods()) {
            if (method.getProgram() == null) continue;
            noSuchFieldCatchElimination.apply(method.getProgram());
            new GlobalValueNumbering(true).optimize(method.getProgram());
            new UnusedVariableElimination().optimize(method, method.getProgram());
        }
        return cls;
    }
}

