/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.model;

import com.antgroup.antchain.myjava.model.InvokeDynamicInstruction;
import com.antgroup.antchain.myjava.model.VariableReader;
import com.antgroup.antchain.myjava.model.instructions.ArrayLengthInstruction;
import com.antgroup.antchain.myjava.model.instructions.AssignInstruction;
import com.antgroup.antchain.myjava.model.instructions.BinaryBranchingInstruction;
import com.antgroup.antchain.myjava.model.instructions.BinaryInstruction;
import com.antgroup.antchain.myjava.model.instructions.BoundCheckInstruction;
import com.antgroup.antchain.myjava.model.instructions.BranchingInstruction;
import com.antgroup.antchain.myjava.model.instructions.CastInstruction;
import com.antgroup.antchain.myjava.model.instructions.CastIntegerInstruction;
import com.antgroup.antchain.myjava.model.instructions.CastNumberInstruction;
import com.antgroup.antchain.myjava.model.instructions.ClassConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.CloneArrayInstruction;
import com.antgroup.antchain.myjava.model.instructions.ConstructArrayInstruction;
import com.antgroup.antchain.myjava.model.instructions.ConstructInstruction;
import com.antgroup.antchain.myjava.model.instructions.ConstructMultiArrayInstruction;
import com.antgroup.antchain.myjava.model.instructions.DoubleConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.EmptyInstruction;
import com.antgroup.antchain.myjava.model.instructions.ExitInstruction;
import com.antgroup.antchain.myjava.model.instructions.FloatConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.GetElementInstruction;
import com.antgroup.antchain.myjava.model.instructions.GetFieldInstruction;
import com.antgroup.antchain.myjava.model.instructions.InitClassInstruction;
import com.antgroup.antchain.myjava.model.instructions.InstructionReader;
import com.antgroup.antchain.myjava.model.instructions.InstructionVisitor;
import com.antgroup.antchain.myjava.model.instructions.IntegerConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.InvokeInstruction;
import com.antgroup.antchain.myjava.model.instructions.IsInstanceInstruction;
import com.antgroup.antchain.myjava.model.instructions.JumpInstruction;
import com.antgroup.antchain.myjava.model.instructions.LongConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.MonitorEnterInstruction;
import com.antgroup.antchain.myjava.model.instructions.MonitorExitInstruction;
import com.antgroup.antchain.myjava.model.instructions.NegateInstruction;
import com.antgroup.antchain.myjava.model.instructions.NullCheckInstruction;
import com.antgroup.antchain.myjava.model.instructions.NullConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.PutElementInstruction;
import com.antgroup.antchain.myjava.model.instructions.PutFieldInstruction;
import com.antgroup.antchain.myjava.model.instructions.RaiseInstruction;
import com.antgroup.antchain.myjava.model.instructions.StringConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.SwitchInstruction;
import com.antgroup.antchain.myjava.model.instructions.UnwrapArrayInstruction;
import java.util.Collections;

public class InstructionReadVisitor
implements InstructionVisitor {
    InstructionReader reader;

    public InstructionReadVisitor(InstructionReader reader) {
        this.reader = reader;
    }

    @Override
    public void visit(EmptyInstruction insn) {
        this.reader.nop();
    }

    @Override
    public void visit(ClassConstantInstruction insn) {
        this.reader.classConstant(insn.getReceiver(), insn.getConstant());
    }

    @Override
    public void visit(NullConstantInstruction insn) {
        this.reader.nullConstant(insn.getReceiver());
    }

    @Override
    public void visit(IntegerConstantInstruction insn) {
        this.reader.integerConstant(insn.getReceiver(), insn.getConstant());
    }

    @Override
    public void visit(LongConstantInstruction insn) {
        this.reader.longConstant(insn.getReceiver(), insn.getConstant());
    }

    @Override
    public void visit(FloatConstantInstruction insn) {
        this.reader.floatConstant(insn.getReceiver(), insn.getConstant());
    }

    @Override
    public void visit(DoubleConstantInstruction insn) {
        this.reader.doubleConstant(insn.getReceiver(), insn.getConstant());
    }

    @Override
    public void visit(StringConstantInstruction insn) {
        this.reader.stringConstant(insn.getReceiver(), insn.getConstant());
    }

    @Override
    public void visit(BinaryInstruction insn) {
        this.reader.binary(insn.getOperation(), insn.getReceiver(), insn.getFirstOperand(), insn.getSecondOperand(), insn.getOperandType());
    }

    @Override
    public void visit(NegateInstruction insn) {
        this.reader.negate(insn.getReceiver(), insn.getOperand(), insn.getOperandType());
    }

    @Override
    public void visit(AssignInstruction insn) {
        this.reader.assign(insn.getReceiver(), insn.getAssignee());
    }

    @Override
    public void visit(CastInstruction insn) {
        this.reader.cast(insn.getReceiver(), insn.getValue(), insn.getTargetType());
    }

    @Override
    public void visit(CastNumberInstruction insn) {
        this.reader.cast((VariableReader)insn.getReceiver(), (VariableReader)insn.getValue(), insn.getSourceType(), insn.getTargetType());
    }

    @Override
    public void visit(CastIntegerInstruction insn) {
        this.reader.cast((VariableReader)insn.getReceiver(), (VariableReader)insn.getValue(), insn.getTargetType(), insn.getDirection());
    }

    @Override
    public void visit(BranchingInstruction insn) {
        this.reader.jumpIf(insn.getCondition(), insn.getOperand(), insn.getConsequent(), insn.getAlternative());
    }

    @Override
    public void visit(BinaryBranchingInstruction insn) {
        this.reader.jumpIf(insn.getCondition(), insn.getFirstOperand(), insn.getSecondOperand(), insn.getConsequent(), insn.getAlternative());
    }

    @Override
    public void visit(JumpInstruction insn) {
        this.reader.jump(insn.getTarget());
    }

    @Override
    public void visit(SwitchInstruction insn) {
        this.reader.choose(insn.getCondition(), Collections.unmodifiableList(insn.getEntries()), insn.getDefaultTarget());
    }

    @Override
    public void visit(ExitInstruction insn) {
        this.reader.exit(insn.getValueToReturn());
    }

    @Override
    public void visit(RaiseInstruction insn) {
        this.reader.raise(insn.getException());
    }

    @Override
    public void visit(ConstructArrayInstruction insn) {
        this.reader.createArray((VariableReader)insn.getReceiver(), insn.getItemType(), insn.getSize());
    }

    @Override
    public void visit(ConstructInstruction insn) {
        this.reader.create(insn.getReceiver(), insn.getType());
    }

    @Override
    public void visit(ConstructMultiArrayInstruction insn) {
        this.reader.createArray((VariableReader)insn.getReceiver(), insn.getItemType(), Collections.unmodifiableList(insn.getDimensions()));
    }

    @Override
    public void visit(GetFieldInstruction insn) {
        this.reader.getField(insn.getReceiver(), insn.getInstance(), insn.getField(), insn.getFieldType());
    }

    @Override
    public void visit(PutFieldInstruction insn) {
        this.reader.putField(insn.getInstance(), insn.getField(), insn.getValue(), insn.getFieldType());
    }

    @Override
    public void visit(ArrayLengthInstruction insn) {
        this.reader.arrayLength(insn.getReceiver(), insn.getArray());
    }

    @Override
    public void visit(CloneArrayInstruction insn) {
        this.reader.cloneArray(insn.getReceiver(), insn.getArray());
    }

    @Override
    public void visit(UnwrapArrayInstruction insn) {
        this.reader.unwrapArray(insn.getReceiver(), insn.getArray(), insn.getElementType());
    }

    @Override
    public void visit(GetElementInstruction insn) {
        this.reader.getElement(insn.getReceiver(), insn.getArray(), insn.getIndex(), insn.getType());
    }

    @Override
    public void visit(PutElementInstruction insn) {
        this.reader.putElement(insn.getArray(), insn.getIndex(), insn.getValue(), insn.getType());
    }

    @Override
    public void visit(InvokeInstruction insn) {
        this.reader.invoke(insn.getReceiver(), insn.getInstance(), insn.getMethod(), insn.getArguments(), insn.getType());
    }

    @Override
    public void visit(InvokeDynamicInstruction insn) {
        this.reader.invokeDynamic(insn.getReceiver(), insn.getInstance(), insn.getMethod(), Collections.unmodifiableList(insn.getArguments()), insn.getBootstrapMethod(), Collections.unmodifiableList(insn.getBootstrapArguments()));
    }

    @Override
    public void visit(IsInstanceInstruction insn) {
        this.reader.isInstance(insn.getReceiver(), insn.getValue(), insn.getType());
    }

    @Override
    public void visit(InitClassInstruction insn) {
        this.reader.initClass(insn.getClassName());
    }

    @Override
    public void visit(NullCheckInstruction insn) {
        this.reader.nullCheck(insn.getReceiver(), insn.getValue());
    }

    @Override
    public void visit(MonitorEnterInstruction insn) {
        this.reader.monitorEnter(insn.getObjectRef());
    }

    @Override
    public void visit(MonitorExitInstruction insn) {
        this.reader.monitorExit(insn.getObjectRef());
    }

    @Override
    public void visit(BoundCheckInstruction insn) {
        this.reader.boundCheck(insn.getReceiver(), insn.getIndex(), insn.getArray(), insn.isLower());
    }
}

